/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.DistinctCountClientAggregator;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.expression.function.DistinctCountAggregateFunction;
import org.apache.phoenix.expression.function.HyperLogLogClientAggregator;
import org.apache.phoenix.expression.function.HyperLogLogServerAggregator;
import org.apache.phoenix.parse.DistinctCountHyperLogLogAggregateParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;

@FunctionParseNode.BuiltInFunction(name="APPROX_COUNT_DISTINCT", nodeClass=DistinctCountHyperLogLogAggregateParseNode.class, args={@FunctionParseNode.Argument})
public class DistinctCountHyperLogLogAggregateFunction
extends DistinctCountAggregateFunction {
    public static final String NAME = "APPROX_COUNT_DISTINCT";
    public static final int NormalSetPrecision = 16;
    public static final int SparseSetPrecision = 25;

    public DistinctCountHyperLogLogAggregateFunction() {
    }

    public DistinctCountHyperLogLogAggregateFunction(List<Expression> childExpressions) {
        super(childExpressions, null);
    }

    public DistinctCountHyperLogLogAggregateFunction(List<Expression> childExpressions, CountAggregateFunction delegate) {
        super(childExpressions, delegate);
    }

    @Override
    public DistinctCountClientAggregator newClientAggregator() {
        return new HyperLogLogClientAggregator(SortOrder.getDefault());
    }

    @Override
    public Aggregator newServerAggregator(Configuration conf) {
        final Expression child = this.getAggregatorExpression();
        return new HyperLogLogServerAggregator(child.getSortOrder()){

            @Override
            protected PDataType getInputDataType() {
                return child.getDataType();
            }
        };
    }

    @Override
    public Aggregator newServerAggregator(Configuration conf, ImmutableBytesWritable ptr) {
        final Expression child = this.getAggregatorExpression();
        return new HyperLogLogServerAggregator(child.getSortOrder(), ptr){

            @Override
            protected PDataType getInputDataType() {
                return child.getDataType();
            }
        };
    }

    @Override
    public String getName() {
        return NAME;
    }
}

