/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.EncodeFormat;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;

@FunctionParseNode.BuiltInFunction(name="DECODE", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(enumeration="EncodeFormat")})
public class DecodeFunction
extends ScalarFunction {
    public static final String NAME = "DECODE";

    public DecodeFunction() {
    }

    public DecodeFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        byte[] out;
        Expression expression = this.getExpression();
        if (!expression.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        PDataType type = expression.getDataType();
        String stringToDecode = (String)type.toObject(ptr);
        Expression encodingExpression = this.getEncodingExpression();
        if (!encodingExpression.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            throw new IllegalDataException(new SQLExceptionInfo.Builder(SQLExceptionCode.ILLEGAL_DATA).setMessage("Missing bytes encoding").build().buildException());
        }
        type = encodingExpression.getDataType();
        String encoding = ((String)type.toObject(ptr)).toUpperCase();
        EncodeFormat format = EncodeFormat.valueOf(encoding);
        switch (format) {
            case HEX: {
                out = this.decodeHex(stringToDecode);
                break;
            }
            default: {
                throw new IllegalDataException("Unsupported encoding \"" + encoding + "\"");
            }
        }
        ptr.set(out);
        return true;
    }

    private byte[] decodeHex(String hexStr) {
        byte[] out = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length(); i += 2) {
            try {
                out[i / 2] = (byte)Integer.parseInt(hexStr.substring(i, i + 2), 16);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new IllegalDataException(new SQLExceptionInfo.Builder(SQLExceptionCode.ILLEGAL_DATA).setMessage("Value " + hexStr.substring(i, i + 2) + " cannot be cast to hex number").build().buildException());
            }
            catch (StringIndexOutOfBoundsException ex) {
                throw new IllegalDataException(new SQLExceptionInfo.Builder(SQLExceptionCode.ILLEGAL_DATA).setMessage("Invalid value length, cannot cast to hex number (" + hexStr + ")").build().buildException());
            }
        }
        return out;
    }

    @Override
    public PDataType getDataType() {
        return PVarbinary.INSTANCE;
    }

    @Override
    public boolean isNullable() {
        return this.getExpression().isNullable();
    }

    private Expression getExpression() {
        return (Expression)this.children.get(0);
    }

    private Expression getEncodingExpression() {
        return (Expression)this.children.get(1);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Integer getMaxLength() {
        return this.getExpression().getMaxLength();
    }
}

