/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PNumericType;

@FunctionParseNode.BuiltInFunction(name="ABS", args={@FunctionParseNode.Argument(allowedTypes={PDecimal.class})})
public class AbsFunction
extends ScalarFunction {
    public static final String NAME = "ABS";

    public AbsFunction() {
    }

    public AbsFunction(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression childExpr = (Expression)this.children.get(0);
        PDataType dataType = childExpr.getDataType();
        if (childExpr.evaluate(tuple, ptr)) {
            byte[] bytes = ptr.get();
            int offset = ptr.getOffset();
            int length = ptr.getLength();
            ptr.set(new byte[this.getDataType().getByteSize().intValue()]);
            ((PNumericType)dataType).abs(bytes, offset, length, childExpr.getSortOrder(), ptr);
            return true;
        }
        return false;
    }

    @Override
    public PDataType getDataType() {
        return ((Expression)this.children.get(0)).getDataType();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

