/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.ColumnExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.aggregator.DistinctValueWithCountClientAggregator;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;

public class PercentRankClientAggregator
extends DistinctValueWithCountClientAggregator {
    private final List<Expression> exps;

    public PercentRankClientAggregator(List<Expression> exps, SortOrder sortOrder) {
        super(sortOrder);
        this.exps = exps;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.cachedResult == null) {
            ColumnExpression columnExp = (ColumnExpression)this.exps.get(0);
            LiteralExpression isAscendingExpression = (LiteralExpression)this.exps.get(1);
            boolean isAscending = (Boolean)isAscendingExpression.getValue();
            LiteralExpression valueExp = (LiteralExpression)this.exps.get(2);
            Map<Object, Integer> sorted = this.getSortedValueVsCount(isAscending, columnExp.getDataType());
            long distinctCountsSum = 0L;
            Object value = valueExp.getValue();
            for (Map.Entry<Object, Integer> entry : sorted.entrySet()) {
                boolean done;
                Object colValue = entry.getKey();
                int compareResult = columnExp.getDataType().compareTo(colValue, value, valueExp.getDataType());
                boolean bl = isAscending ? compareResult > 0 : (done = compareResult <= 0);
                if (done) break;
                distinctCountsSum += (long)entry.getValue().intValue();
            }
            float result = (float)distinctCountsSum / (float)this.totalCount;
            this.cachedResult = new BigDecimal(result);
        }
        if (this.buffer == null) {
            this.initBuffer();
        }
        this.buffer = PDecimal.INSTANCE.toBytes(this.cachedResult);
        ptr.set(this.buffer);
        return true;
    }

    @Override
    protected PDataType getResultDataType() {
        return PDecimal.INSTANCE;
    }
}

