/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.BaseSingleExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;

public class NotExpression
extends BaseSingleExpression {
    public static Expression create(Expression child, ImmutableBytesWritable ptr) throws SQLException {
        if (child.getDataType() != PBoolean.INSTANCE) {
            throw TypeMismatchException.newException(child.getDataType(), PBoolean.INSTANCE, "NOT");
        }
        if (child.isStateless()) {
            if (!child.evaluate(null, ptr) || ptr.getLength() == 0) {
                return LiteralExpression.newConstant(null, (PDataType)PBoolean.INSTANCE, child.getDeterminism());
            }
            return LiteralExpression.newConstant((Object)((Boolean)PBoolean.INSTANCE.toObject(ptr) == false ? 1 : 0), (PDataType)PBoolean.INSTANCE, child.getDeterminism());
        }
        return new NotExpression(child);
    }

    public NotExpression() {
    }

    public NotExpression(Expression expression) {
        super(expression);
    }

    public NotExpression(List<Expression> l) {
        super(l);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!this.getChild().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        ptr.set(Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(ptr)) ? PDataType.FALSE_BYTES : PDataType.TRUE_BYTES);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PBoolean.INSTANCE;
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("NOT (");
        buf.append(((Expression)this.children.get(0)).toString());
        buf.append(")");
        return buf.toString();
    }
}

