/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.OrderPreservingTracker;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.DelegateQueryPlan;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.expression.ProjectedColumnExpression;
import org.apache.phoenix.iterate.DelegateResultIterator;
import org.apache.phoenix.iterate.FilterResultIterator;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;

public class TupleProjectionPlan
extends DelegateQueryPlan {
    private final TupleProjector tupleProjector;
    private final Expression postFilter;
    private final StatementContext statementContext;
    private ColumnResolver columnResolver = null;
    private List<OrderByCompiler.OrderBy> actualOutputOrderBys = Collections.emptyList();

    public TupleProjectionPlan(QueryPlan plan, TupleProjector tupleProjector, StatementContext statementContext, Expression postFilter) throws SQLException {
        super(plan);
        if (tupleProjector == null) {
            throw new IllegalArgumentException("tupleProjector is null");
        }
        this.tupleProjector = tupleProjector;
        this.statementContext = statementContext;
        this.postFilter = postFilter;
        if (this.statementContext != null) {
            this.columnResolver = statementContext.getResolver();
            this.actualOutputOrderBys = this.convertInputOrderBys(plan);
        }
    }

    private List<OrderByCompiler.OrderBy> convertInputOrderBys(QueryPlan targetQueryPlan) throws SQLException {
        List<OrderByCompiler.OrderBy> inputOrderBys = targetQueryPlan.getOutputOrderBys();
        if (inputOrderBys.isEmpty()) {
            return Collections.emptyList();
        }
        Expression[] selectColumnExpressions = this.tupleProjector.getExpressions();
        HashMap<Expression, Integer> selectColumnExpressionToIndex = new HashMap<Expression, Integer>(selectColumnExpressions.length);
        int columnIndex = 0;
        for (Expression selectColumnExpression : selectColumnExpressions) {
            selectColumnExpressionToIndex.put(selectColumnExpression, columnIndex++);
        }
        ArrayList<OrderByCompiler.OrderBy> newOrderBys = new ArrayList<OrderByCompiler.OrderBy>(inputOrderBys.size());
        for (OrderByCompiler.OrderBy inputOrderBy : inputOrderBys) {
            OrderByCompiler.OrderBy newOrderBy = this.convertSingleInputOrderBy(selectColumnExpressionToIndex, selectColumnExpressions, inputOrderBy);
            if (newOrderBy == OrderByCompiler.OrderBy.EMPTY_ORDER_BY) continue;
            newOrderBys.add(newOrderBy);
        }
        if (newOrderBys.isEmpty()) {
            return Collections.emptyList();
        }
        return newOrderBys;
    }

    private OrderByCompiler.OrderBy convertSingleInputOrderBy(Map<Expression, Integer> selectColumnExpressionToIndex, Expression[] selectColumnExpressions, OrderByCompiler.OrderBy inputOrderBy) throws SQLException {
        OrderPreservingTracker orderPreservingTracker = new OrderPreservingTracker(this.statementContext, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, OrderPreservingTracker.Ordering.UNORDERED, selectColumnExpressions.length, Collections.singletonList(inputOrderBy), null, null);
        for (Expression selectColumnExpression : selectColumnExpressions) {
            orderPreservingTracker.track(selectColumnExpression);
        }
        orderPreservingTracker.isOrderPreserving();
        List<OrderPreservingTracker.Info> orderPreservingTrackInfos = orderPreservingTracker.getOrderPreservingTrackInfos();
        if (orderPreservingTrackInfos.isEmpty()) {
            return OrderByCompiler.OrderBy.EMPTY_ORDER_BY;
        }
        ArrayList<OrderByExpression> newOrderByExpressions = new ArrayList<OrderByExpression>(orderPreservingTrackInfos.size());
        for (OrderPreservingTracker.Info orderPreservingTrackInfo : orderPreservingTrackInfos) {
            Expression expression = orderPreservingTrackInfo.getExpression();
            Integer index = selectColumnExpressionToIndex.get(expression);
            assert (index != null);
            ProjectedColumnExpression projectedValueColumnExpression = this.getProjectedValueColumnExpression(index);
            OrderByExpression newOrderByExpression = OrderByExpression.createByCheckIfOrderByReverse(projectedValueColumnExpression, orderPreservingTrackInfo.isNullsLast(), orderPreservingTrackInfo.isAscending(), false);
            newOrderByExpressions.add(newOrderByExpression);
        }
        return new OrderByCompiler.OrderBy(newOrderByExpressions);
    }

    private ProjectedColumnExpression getProjectedValueColumnExpression(int columnIndex) throws SQLException {
        assert (this.columnResolver != null);
        TableRef tableRef = this.columnResolver.getTables().get(0);
        ColumnRef columnRef = new ColumnRef(tableRef, columnIndex);
        return (ProjectedColumnExpression)columnRef.newColumnExpression();
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        ExplainPlan explainPlan = this.delegate.getExplainPlan();
        ArrayList planSteps = Lists.newArrayList(explainPlan.getPlanSteps());
        ExplainPlanAttributes explainPlanAttributes = explainPlan.getPlanStepsAsAttributes();
        if (this.postFilter != null) {
            planSteps.add("CLIENT FILTER BY " + this.postFilter.toString());
            ExplainPlanAttributes.ExplainPlanAttributesBuilder newBuilder = new ExplainPlanAttributes.ExplainPlanAttributesBuilder(explainPlanAttributes);
            newBuilder.setClientFilterBy(this.postFilter.toString());
            explainPlanAttributes = newBuilder.build();
        }
        return new ExplainPlan(planSteps, explainPlanAttributes);
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        ResultIterator iterator = new DelegateResultIterator(this.delegate.iterator(scanGrouper, scan)){

            @Override
            public Tuple next() throws SQLException {
                Tuple tuple = super.next();
                if (tuple == null) {
                    return null;
                }
                return TupleProjectionPlan.this.tupleProjector.projectResults(tuple);
            }

            public String toString() {
                return "TupleProjectionResultIterator [projector=" + TupleProjectionPlan.this.tupleProjector + "]";
            }
        };
        if (this.postFilter != null) {
            iterator = new FilterResultIterator(iterator, this.postFilter);
        }
        return iterator;
    }

    @Override
    public <T> T accept(QueryPlanVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public List<OrderByCompiler.OrderBy> getOutputOrderBys() {
        return this.actualOutputOrderBys;
    }
}

