/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.NavigableMap;
import java.util.Optional;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.generated.DynamicColumnMetaDataProtos;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.iterate.NonAggregateRegionScannerFactory;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanRegionObserver
extends BaseScannerRegionObserver
implements RegionCoprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanRegionObserver.class);
    public static final byte[] DYN_COLS_METADATA_CELL_QUALIFIER = Bytes.toBytes((String)"D#");
    public static final String DYNAMIC_COLUMN_METADATA_STORED_FOR_MUTATION = "_DynColsMetadataStoredForMutation";
    public static final String WILDCARD_SCAN_INCLUDES_DYNAMIC_COLUMNS = "_WildcardScanIncludesDynCols";

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public static void serializeIntoScan(Scan scan, int limit, List<OrderByExpression> orderByExpressions, int estimatedRowSize) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(stream);
            WritableUtils.writeVInt((DataOutput)output, (int)limit);
            WritableUtils.writeVInt((DataOutput)output, (int)estimatedRowSize);
            WritableUtils.writeVInt((DataOutput)output, (int)orderByExpressions.size());
            for (OrderByExpression orderingCol : orderByExpressions) {
                orderingCol.write(output);
            }
            scan.setAttribute("_TopN", stream.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        try {
            this.preBatchMutateWithExceptions(miniBatchOp, ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getTableDescriptor().getTableName().getNameAsString());
        }
        catch (Throwable t) {
            throw ServerUtil.createIOException("Unable to Put cells corresponding to dynamiccolumn metadata for " + ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable().getNameAsString(), t);
        }
    }

    private void preBatchMutateWithExceptions(MiniBatchOperationInProgress<Mutation> miniBatchOp, String tableName) throws IOException {
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m = (Mutation)miniBatchOp.getOperation(i);
            Put dynColShadowCellsPut = null;
            if (m instanceof Put && Bytes.equals((byte[])m.getAttribute(DYNAMIC_COLUMN_METADATA_STORED_FOR_MUTATION), (byte[])PDataType.TRUE_BYTES)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Adding dynamic column metadata for table: " + tableName + ". Put :" + m.toString());
                }
                NavigableMap famCellMap = m.getFamilyCellMap();
                for (byte[] fam : famCellMap.keySet()) {
                    List<PTableProtos.PColumn> dynColsInThisFam;
                    byte[] serializedDynColsList = m.getAttribute(Bytes.toString((byte[])fam));
                    if (serializedDynColsList == null || (dynColsInThisFam = DynamicColumnMetaDataProtos.DynamicColumnMetaData.parseFrom(serializedDynColsList).getDynamicColumnsList()).isEmpty()) continue;
                    if (dynColShadowCellsPut == null) {
                        dynColShadowCellsPut = new Put(m.getRow());
                    }
                    for (PTableProtos.PColumn dynColProto : dynColsInThisFam) {
                        dynColShadowCellsPut.addColumn(fam, ScanRegionObserver.getQualifierForDynamicColumnMetaDataCell(dynColProto), dynColProto.toByteArray());
                    }
                }
            }
            if (dynColShadowCellsPut == null) continue;
            miniBatchOp.addOperationsFromCP(i, new Mutation[]{dynColShadowCellsPut});
        }
    }

    private static byte[] getQualifierForDynamicColumnMetaDataCell(PTableProtos.PColumn dynColProto) throws IOException {
        PColumn dynCol = PColumnImpl.createFromProto(dynColProto);
        ByteArrayOutputStream qual = new ByteArrayOutputStream();
        qual.write(DYN_COLS_METADATA_CELL_QUALIFIER);
        qual.write(dynCol.getColumnQualifierBytes());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Storing shadow cell for dynamic column metadata for dynamic column : " + dynCol.getFamilyName().getString() + "." + dynCol.getName().getString());
        }
        return qual.toByteArray();
    }

    @Override
    protected RegionScanner doPostScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws Throwable {
        NonAggregateRegionScannerFactory nonAggregateROUtil = new NonAggregateRegionScannerFactory((RegionCoprocessorEnvironment)c.getEnvironment());
        return nonAggregateROUtil.getRegionScanner(scan, s);
    }

    @Override
    protected boolean skipRegionBoundaryCheck(Scan scan) {
        return super.skipRegionBoundaryCheck(scan) || ScanUtil.isSimpleScan(scan);
    }

    @Override
    protected boolean isRegionObserverFor(Scan scan) {
        return ScanUtil.isNonAggregateScan(scan);
    }
}

