/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TimerTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.PostDDLCompiler;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.UpgradeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataRegionObserver
implements RegionObserver,
RegionCoprocessor {
    public static final Logger LOGGER = LoggerFactory.getLogger(MetaDataRegionObserver.class);
    public static final String REBUILD_INDEX_APPEND_TO_URL_STRING = "REBUILDINDEX";
    public static final long PENDING_DISABLE_INACTIVE_STATE_COUNT = 10000L;
    private static final byte[] SYSTEM_CATALOG_KEY = SchemaUtil.getTableKey(ByteUtil.EMPTY_BYTE_ARRAY, QueryConstants.SYSTEM_SCHEMA_NAME_BYTES, PhoenixDatabaseMetaData.SYSTEM_CATALOG_TABLE_BYTES);
    protected ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private boolean enableRebuildIndex = true;
    private long rebuildIndexTimeInterval = 60000L;
    private static Map<PName, Long> batchExecutedPerTableMap = new HashMap<PName, Long>();
    @GuardedBy(value="MetaDataRegionObserver.class")
    private static Properties rebuildIndexConnectionProps;
    private long initialRebuildTaskDelay;

    public void preClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) {
        this.executor.shutdownNow();
        GlobalCache.getInstance((RegionCoprocessorEnvironment)c.getEnvironment()).getMetaDataCache().invalidateAll();
    }

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        Configuration config = env.getConfiguration();
        long sleepTime = config.getLong("phoenix.clock.skew.interval", 2000L);
        try {
            if (sleepTime > 0L) {
                Thread.sleep(sleepTime);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        this.enableRebuildIndex = config.getBoolean("phoenix.index.failure.handling.rebuild", true);
        this.rebuildIndexTimeInterval = config.getLong("phoenix.index.failure.handling.rebuild.interval", 60000L);
        this.initialRebuildTaskDelay = config.getLong("phoenix.index.rebuild.task.initial.delay", 10000L);
    }

    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> e) {
        final RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)e.getEnvironment();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Table metaTable = null;
                Table statsTable = null;
                try {
                    ReadOnlyProps props = new ReadOnlyProps(env.getConfiguration().iterator());
                    Thread.sleep(1000L);
                    metaTable = env.getConnection().getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, props));
                    statsTable = env.getConnection().getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_STATS_NAME_BYTES, props));
                    final Table mTable = metaTable;
                    final Table sTable = statsTable;
                    User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            if (UpgradeUtil.truncateStats(mTable, sTable)) {
                                LOGGER.info("Stats are successfully truncated for upgrade 4.7!!");
                            }
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    LOGGER.warn("Exception while truncate stats.., please check and delete stats manually inorder to get proper result with old client!!");
                    LOGGER.warn(exception.getStackTrace().toString());
                }
                finally {
                    try {
                        if (metaTable != null) {
                            metaTable.close();
                        }
                        if (statsTable != null) {
                            statsTable.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
        if (!this.enableRebuildIndex) {
            LOGGER.info("Failure Index Rebuild is skipped by configuration.");
            return;
        }
        if (ServerUtil.isKeyInRegion(SYSTEM_CATALOG_KEY, ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion())) {
            try {
                Class.forName(PhoenixDriver.class.getName());
                MetaDataRegionObserver.initRebuildIndexConnectionProps(((RegionCoprocessorEnvironment)e.getEnvironment()).getConfiguration());
                BuildIndexScheduleTask task = new BuildIndexScheduleTask((RegionCoprocessorEnvironment)e.getEnvironment());
                this.executor.scheduleWithFixedDelay(task, this.initialRebuildTaskDelay, this.rebuildIndexTimeInterval, TimeUnit.MILLISECONDS);
            }
            catch (ClassNotFoundException ex) {
                LOGGER.error("BuildIndexScheduleTask cannot start!", (Throwable)ex);
            }
        }
    }

    @VisibleForTesting
    public static synchronized void initRebuildIndexConnectionProps(Configuration config) {
        if (rebuildIndexConnectionProps == null) {
            Properties props = new Properties();
            long indexRebuildQueryTimeoutMs = config.getLong("phoenix.index.rebuild.query.timeout", 9002100L);
            long indexRebuildRPCTimeoutMs = config.getLong("phoenix.index.rebuild.rpc.timeout", 1800000L);
            long indexRebuildClientScannerTimeOutMs = config.getLong("phoenix.index.rebuild.client.scanner.timeout", 1800000L);
            int indexRebuildRpcRetriesCounter = config.getInt("phoenix.index.rebuild.rpc.retries.counter", 5);
            props.setProperty("phoenix.query.timeoutMs", Long.toString(indexRebuildQueryTimeoutMs));
            props.setProperty("hbase.client.scanner.timeout.period", Long.toString(indexRebuildClientScannerTimeOutMs));
            props.setProperty("hbase.rpc.timeout", Long.toString(indexRebuildRPCTimeoutMs));
            props.setProperty("hbase.client.retries.number", Long.toString(indexRebuildRpcRetriesCounter));
            props.setProperty("phoenix.index.population.wait.time", "0");
            rebuildIndexConnectionProps = PropertiesUtil.combineProperties(props, config);
        }
    }

    public static PhoenixConnection getRebuildIndexConnection(Configuration config) throws SQLException {
        MetaDataRegionObserver.initRebuildIndexConnectionProps(config);
        return QueryUtil.getConnectionOnServerWithCustomUrl(rebuildIndexConnectionProps, REBUILD_INDEX_APPEND_TO_URL_STRING).unwrap(PhoenixConnection.class);
    }

    public static class BuildIndexScheduleTask
    extends TimerTask {
        RegionCoprocessorEnvironment env;
        private final long rebuildIndexBatchSize;
        private final long configuredBatches;
        private final long indexDisableTimestampThreshold;
        private final long pendingDisableThreshold;
        private final ReadOnlyProps props;
        private final List<String> onlyTheseTables;

        public BuildIndexScheduleTask(RegionCoprocessorEnvironment env) {
            this(env, null);
        }

        public BuildIndexScheduleTask(RegionCoprocessorEnvironment env, List<String> onlyTheseTables) {
            this.onlyTheseTables = onlyTheseTables == null ? null : ImmutableList.copyOf(onlyTheseTables);
            this.env = env;
            Configuration configuration = env.getConfiguration();
            this.rebuildIndexBatchSize = configuration.getLong("phoenix.index.failure.handling.rebuild.period", Long.MAX_VALUE);
            this.configuredBatches = configuration.getLong("phoenix.index.rebuild.batch.perTable", 10L);
            this.indexDisableTimestampThreshold = configuration.getLong("phoenix.index.rebuild.disabletimestamp.threshold", 86400000L);
            this.pendingDisableThreshold = configuration.getLong("phoenix.index.pending.disable.threshold", 30000L);
            this.props = new ReadOnlyProps(env.getConfiguration().iterator());
        }

        public List<PTable> decrementIndexesPendingDisableCount(PhoenixConnection conn, PTable dataPTable, List<PTable> indexes) {
            ArrayList<PTable> indexesIncremented = new ArrayList<PTable>();
            for (PTable index : indexes) {
                try {
                    String indexName = index.getName().getString();
                    IndexUtil.incrementCounterForIndex(conn, indexName, -10000L);
                    indexesIncremented.add(index);
                }
                catch (Exception e) {
                    LOGGER.warn("Decrement  of -10000 for index :" + index.getName().getString() + "of table: " + dataPTable.getName().getString(), (Throwable)e);
                }
            }
            return indexesIncremented;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block65: {
                RegionScanner scanner = null;
                PhoenixConnection conn = null;
                try {
                    Scan scan = new Scan();
                    SingleColumnValueFilter filter = new SingleColumnValueFilter(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES, CompareFilter.CompareOp.NOT_EQUAL, PLong.INSTANCE.toBytes(0L));
                    filter.setFilterIfMissing(true);
                    scan.setFilter((Filter)filter);
                    scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_NAME_BYTES);
                    scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TABLE_NAME_BYTES);
                    scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES);
                    scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES);
                    Map dataTableToIndexesMap = null;
                    boolean hasMore = false;
                    ArrayList results = new ArrayList();
                    scanner = this.env.getRegion().getScanner(scan);
                    do {
                        results.clear();
                        hasMore = scanner.next(results);
                        if (results.isEmpty()) {
                            LOGGER.debug("Found no indexes with non zero INDEX_DISABLE_TIMESTAMP");
                            break;
                        }
                        Result r = Result.create(results);
                        byte[] disabledTimeStamp = r.getValue(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES);
                        Cell indexStateCell = r.getColumnLatestCell(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES);
                        if (disabledTimeStamp == null || disabledTimeStamp.length == 0) {
                            LOGGER.debug("Null or empty INDEX_DISABLE_TIMESTAMP");
                            continue;
                        }
                        byte[] dataTable = r.getValue(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TABLE_NAME_BYTES);
                        if (dataTable == null || dataTable.length == 0 || indexStateCell == null) {
                            LOGGER.debug("Null or data table name or index state");
                            continue;
                        }
                        byte[] indexStateBytes = CellUtil.cloneValue((Cell)indexStateCell);
                        byte[][] rowKeyMetaData = new byte[3][];
                        SchemaUtil.getVarChars(r.getRow(), 3, rowKeyMetaData);
                        byte[] schemaName = rowKeyMetaData[1];
                        byte[] indexTable = rowKeyMetaData[2];
                        if (indexTable == null || indexTable.length == 0) {
                            LOGGER.debug("We find IndexTable empty during rebuild scan:" + scan + "so, Index rebuild has been skipped for row=" + r);
                            continue;
                        }
                        String dataTableFullName = SchemaUtil.getTableName(schemaName, dataTable);
                        if (this.onlyTheseTables != null && !this.onlyTheseTables.contains(dataTableFullName)) {
                            LOGGER.debug("Could not find " + dataTableFullName + " in " + this.onlyTheseTables);
                            continue;
                        }
                        if (conn == null) {
                            conn = MetaDataRegionObserver.getRebuildIndexConnection(this.env.getConfiguration());
                            dataTableToIndexesMap = Maps.newHashMap();
                        }
                        PTable dataPTable = PhoenixRuntime.getTableNoCache(conn, dataTableFullName);
                        String indexTableFullName = SchemaUtil.getTableName(schemaName, indexTable);
                        PTable indexPTable = PhoenixRuntime.getTableNoCache(conn, indexTableFullName);
                        if (!dataPTable.getIndexes().contains(indexPTable)) {
                            LOGGER.debug(dataTableFullName + " does not contain " + indexPTable.getName().getString());
                            continue;
                        }
                        PIndexState indexState = PIndexState.fromSerializedValue(indexStateBytes[0]);
                        long pendingDisableCountLastUpdatedTs = IndexUtil.getIndexPendingDisableCountLastUpdatedTimestamp(conn, indexTableFullName);
                        long elapsedSinceDisable = EnvironmentEdgeManager.currentTimeMillis() - pendingDisableCountLastUpdatedTs;
                        if (indexState == PIndexState.PENDING_DISABLE) {
                            if (elapsedSinceDisable <= this.pendingDisableThreshold) continue;
                            IndexUtil.updateIndexState(conn, indexTableFullName, PIndexState.DISABLE, pendingDisableCountLastUpdatedTs);
                            continue;
                        }
                        if (!(indexState != PIndexState.DISABLE && indexState != PIndexState.PENDING_ACTIVE || MetaDataUtil.tableRegionsOnline(this.env.getConfiguration(), indexPTable))) {
                            LOGGER.debug("Index rebuild has been skipped because not all regions of index table=" + indexPTable.getName() + " are online.");
                            continue;
                        }
                        if (elapsedSinceDisable > this.indexDisableTimestampThreshold) {
                            try {
                                IndexUtil.updateIndexState(conn, indexTableFullName, PIndexState.DISABLE, 0L);
                                LOGGER.error("Unable to rebuild index " + indexTableFullName + ". Won't attempt again since index disable timestamp is older than current time by " + this.indexDisableTimestampThreshold + " milliseconds. Manual intervention needed to re-build the index");
                            }
                            catch (Throwable ex) {
                                LOGGER.error("Unable to mark index " + indexTableFullName + " as disabled.", ex);
                            }
                            continue;
                        }
                        if (indexState == PIndexState.DISABLE) {
                            if (IndexUtil.getIndexPendingDisableCount(conn, indexTableFullName) < 10000L) {
                                IndexUtil.incrementCounterForIndex(conn, indexTableFullName, 10000L);
                            }
                            IndexUtil.updateIndexState(conn, indexTableFullName, PIndexState.INACTIVE, null);
                            continue;
                        }
                        if (indexState == PIndexState.PENDING_ACTIVE) {
                            IndexUtil.updateIndexState(conn, indexTableFullName, PIndexState.ACTIVE, null);
                            continue;
                        }
                        if (indexState != PIndexState.INACTIVE && indexState != PIndexState.ACTIVE) {
                            LOGGER.warn("Unexpected index state of " + indexTableFullName + "=" + (Object)((Object)indexState) + ". Skipping partial rebuild attempt.");
                            continue;
                        }
                        long currentTime = EnvironmentEdgeManager.currentTimeMillis();
                        long forwardOverlapDurationMs = this.env.getConfiguration().getLong("phoenix.index.failure.handling.rebuild.overlap.forward.time", 180000L);
                        if (indexStateCell.getTimestamp() + forwardOverlapDurationMs > currentTime) {
                            LOGGER.debug("Still must wait " + (indexStateCell.getTimestamp() + forwardOverlapDurationMs - currentTime) + " before starting rebuild for " + indexTableFullName);
                            continue;
                        }
                        Long upperBoundOfRebuild = indexStateCell.getTimestamp() + forwardOverlapDurationMs;
                        List indexesToPartiallyRebuild = (List)dataTableToIndexesMap.get(dataPTable);
                        if (indexesToPartiallyRebuild == null) {
                            indexesToPartiallyRebuild = Lists.newArrayListWithExpectedSize((int)dataPTable.getIndexes().size());
                            dataTableToIndexesMap.put(dataPTable, indexesToPartiallyRebuild);
                        }
                        LOGGER.debug("We have found " + (Object)((Object)indexPTable.getIndexState()) + " Index:" + indexPTable.getName() + " on data table:" + dataPTable.getName() + " which failed to be updated at " + indexPTable.getIndexDisableTimestamp());
                        indexesToPartiallyRebuild.add(new Pair((Object)indexPTable, (Object)upperBoundOfRebuild));
                    } while (hasMore);
                    if (dataTableToIndexesMap == null) break block65;
                    long backwardOverlapDurationMs = this.env.getConfiguration().getLong("phoenix.index.failure.handling.rebuild.overlap.backward.time", this.env.getConfiguration().getLong("phoenix.index.failure.handling.rebuild.overlap.time", 1L));
                    for (Map.Entry entry : dataTableToIndexesMap.entrySet()) {
                        PTable dataPTable = (PTable)entry.getKey();
                        List pairs = (List)entry.getValue();
                        ArrayList indexesToPartiallyRebuild = Lists.newArrayListWithExpectedSize((int)pairs.size());
                        try {
                            Table metaTable = this.env.getConnection().getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.props));
                            Throwable throwable = null;
                            try {
                                long earliestDisableTimestamp = Long.MAX_VALUE;
                                long latestUpperBoundTimestamp = Long.MIN_VALUE;
                                ArrayList maintainers = Lists.newArrayListWithExpectedSize((int)pairs.size());
                                int signOfDisableTimeStamp = 0;
                                for (Pair pair : pairs) {
                                    PTable index = (PTable)pair.getFirst();
                                    Long upperBoundTimestamp = (Long)pair.getSecond();
                                    long disabledTimeStampVal = index.getIndexDisableTimestamp();
                                    if (disabledTimeStampVal != 0L) {
                                        if (signOfDisableTimeStamp != 0 && signOfDisableTimeStamp != Long.signum(disabledTimeStampVal)) {
                                            LOGGER.warn("Found unexpected mix of signs with INDEX_DISABLE_TIMESTAMP for " + dataPTable.getName().getString() + " with " + indexesToPartiallyRebuild);
                                        }
                                        signOfDisableTimeStamp = Long.signum(disabledTimeStampVal);
                                        if ((disabledTimeStampVal = Math.abs(disabledTimeStampVal)) < earliestDisableTimestamp) {
                                            earliestDisableTimestamp = disabledTimeStampVal;
                                        }
                                        indexesToPartiallyRebuild.add(index);
                                        maintainers.add(index.getIndexMaintainer(dataPTable, conn));
                                    }
                                    if (upperBoundTimestamp <= latestUpperBoundTimestamp) continue;
                                    latestUpperBoundTimestamp = upperBoundTimestamp;
                                }
                                if (earliestDisableTimestamp == Long.MAX_VALUE) {
                                    LOGGER.debug("No indexes are disabled so continuing");
                                    continue;
                                }
                                long scanBeginTime = Math.max(0L, earliestDisableTimestamp - backwardOverlapDurationMs);
                                long scanEndTime = Math.min(latestUpperBoundTimestamp, this.getTimestampForBatch(scanBeginTime, (Long)batchExecutedPerTableMap.get(dataPTable.getName())));
                                LOGGER.info("Starting to build " + dataPTable + " indexes " + indexesToPartiallyRebuild + " from timestamp=" + scanBeginTime + " until " + scanEndTime);
                                TableRef tableRef = new TableRef(null, dataPTable, Long.MAX_VALUE, false);
                                PostDDLCompiler compiler = new PostDDLCompiler(conn);
                                MutationPlan plan = compiler.compile(Collections.singletonList(tableRef), null, null, null, scanEndTime);
                                Scan dataTableScan = IndexManagementUtil.newLocalStateScan(plan.getContext().getScan(), maintainers);
                                dataTableScan.setTimeRange(scanBeginTime, scanEndTime);
                                dataTableScan.setCacheBlocks(false);
                                dataTableScan.setAttribute("_RebuildIndexes", PDataType.TRUE_BYTES);
                                ImmutableBytesWritable indexMetaDataPtr = new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY);
                                IndexMaintainer.serializeAdditional(dataPTable, indexMetaDataPtr, indexesToPartiallyRebuild, conn);
                                byte[] attribValue = ByteUtil.copyKeyBytesIfNecessary(indexMetaDataPtr);
                                dataTableScan.setAttribute("IdxProtoMD", attribValue);
                                ScanUtil.setClientVersion(dataTableScan, MetaDataProtocol.PHOENIX_VERSION);
                                LOGGER.info("Starting to partially build indexes:" + indexesToPartiallyRebuild + " on data table:" + dataPTable.getName() + " with the earliest disable timestamp:" + earliestDisableTimestamp + " till " + (scanEndTime == Long.MAX_VALUE ? "LATEST_TIMESTAMP" : Long.valueOf(scanEndTime)));
                                MutationState mutationState = plan.execute();
                                long rowCount = mutationState.getUpdateCount();
                                this.decrementIndexesPendingDisableCount(conn, dataPTable, indexesToPartiallyRebuild);
                                if (scanEndTime == latestUpperBoundTimestamp) {
                                    LOGGER.info("Rebuild completed for all inactive/disabled indexes in data table:" + dataPTable.getName());
                                }
                                LOGGER.info(" no. of datatable rows read in rebuilding process is " + rowCount);
                                for (PTable indexPTable : indexesToPartiallyRebuild) {
                                    String indexTableFullName = SchemaUtil.getTableName(indexPTable.getSchemaName().getString(), indexPTable.getTableName().getString());
                                    try {
                                        if (scanEndTime == latestUpperBoundTimestamp) {
                                            IndexUtil.updateIndexState(conn, indexTableFullName, PIndexState.ACTIVE, 0L, latestUpperBoundTimestamp);
                                            batchExecutedPerTableMap.remove(dataPTable.getName());
                                            LOGGER.info("Making Index:" + indexPTable.getTableName() + " active after rebuilding");
                                            continue;
                                        }
                                        IndexUtil.updateIndexState(conn, indexTableFullName, indexPTable.getIndexState(), scanEndTime * (long)signOfDisableTimeStamp, latestUpperBoundTimestamp);
                                        Long noOfBatches = (Long)batchExecutedPerTableMap.get(dataPTable.getName());
                                        if (noOfBatches == null) {
                                            noOfBatches = 0L;
                                        }
                                        noOfBatches = noOfBatches + 1L;
                                        batchExecutedPerTableMap.put(dataPTable.getName(), noOfBatches);
                                        LOGGER.info("During Round-robin build: Successfully updated index disabled timestamp  for " + indexTableFullName + " to " + scanEndTime);
                                    }
                                    catch (SQLException e) {
                                        LOGGER.error("Unable to rebuild " + dataPTable + " index " + indexTableFullName, (Throwable)e);
                                    }
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (metaTable == null) continue;
                                if (throwable != null) {
                                    try {
                                        metaTable.close();
                                    }
                                    catch (Throwable elapsedSinceDisable) {
                                        throwable.addSuppressed(elapsedSinceDisable);
                                    }
                                    continue;
                                }
                                metaTable.close();
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Unable to rebuild " + dataPTable + " indexes " + indexesToPartiallyRebuild, (Throwable)e);
                        }
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn("ScheduledBuildIndexTask failed!", t);
                }
                finally {
                    if (scanner != null) {
                        try {
                            scanner.close();
                        }
                        catch (IOException ignored) {
                            LOGGER.debug("ScheduledBuildIndexTask can't close scanner.", (Throwable)ignored);
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException ignored) {
                            LOGGER.debug("ScheduledBuildIndexTask can't close connection", (Throwable)ignored);
                        }
                    }
                }
            }
        }

        private long getTimestampForBatch(long disabledTimeStamp, Long noOfBatches) {
            if (disabledTimeStamp < 0L || this.rebuildIndexBatchSize > Long.MAX_VALUE - disabledTimeStamp) {
                return Long.MAX_VALUE;
            }
            long timestampForNextBatch = disabledTimeStamp + this.rebuildIndexBatchSize;
            if (timestampForNextBatch < 0L || timestampForNextBatch > EnvironmentEdgeManager.currentTimeMillis() || noOfBatches != null && noOfBatches > this.configuredBatches) {
                timestampForNextBatch = Long.MAX_VALUE;
            }
            return timestampForNextBatch;
        }
    }
}

