/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.GlobalIndexRegionScanner;
import org.apache.phoenix.coprocessor.IndexToolVerificationResult;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.hbase.index.parallel.Task;
import org.apache.phoenix.hbase.index.parallel.TaskBatch;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.GlobalIndexChecker;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRebuildRegionScanner
extends GlobalIndexRegionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexRebuildRegionScanner.class);
    private static boolean ignoreIndexRebuildForTesting = false;
    private int singleRowRebuildReturnCode;

    public static void setIgnoreIndexRebuildForTesting(boolean ignore) {
        ignoreIndexRebuildForTesting = ignore;
    }

    @VisibleForTesting
    public IndexRebuildRegionScanner(RegionScanner innerScanner, Region region, Scan scan, RegionCoprocessorEnvironment env, UngroupedAggregateRegionObserver ungroupedAggregateRegionObserver) throws IOException {
        super(innerScanner, region, scan, env, ungroupedAggregateRegionObserver);
        this.indexHTable = this.hTableFactory.getTable(new ImmutableBytesPtr(this.indexMaintainer.getIndexTableName()));
        this.indexTableTTL = this.indexHTable.getTableDescriptor().getColumnFamilies()[0].getTimeToLive();
        this.indexRowKeyforReadRepair = scan.getAttribute("_IndexRowKey");
        if (this.indexRowKeyforReadRepair != null) {
            this.setReturnCodeForSingleRowRebuild();
            this.pageSizeInRows = 1L;
            return;
        }
        try (Connection connection = HBaseFactoryProvider.getHConnectionFactory().createConnection(env.getConfiguration());){
            this.regionEndKeys = connection.getRegionLocator(this.indexHTable.getName()).getEndKeys();
        }
    }

    private void setReturnCodeForSingleRowRebuild() throws IOException {
        try (RegionScanner scanner = this.region.getScanner(this.scan);){
            ArrayList row = new ArrayList();
            scanner.next(row);
            if (row.isEmpty()) {
                this.singleRowRebuildReturnCode = GlobalIndexChecker.RebuildReturnCode.NO_DATA_ROW.getValue();
            } else {
                Put put = new Put(CellUtil.cloneRow((Cell)((Cell)row.get(0))));
                for (Cell cell : row) {
                    put.add(cell);
                }
                this.singleRowRebuildReturnCode = this.checkIndexRow(this.indexRowKeyforReadRepair, put) ? GlobalIndexChecker.RebuildReturnCode.INDEX_ROW_EXISTS.getValue() : GlobalIndexChecker.RebuildReturnCode.NO_INDEX_ROW.getValue();
            }
        }
    }

    private boolean checkIndexRow(byte[] indexRowKey, Put put) throws IOException {
        byte[] builtIndexRowKey = IndexRebuildRegionScanner.getIndexRowKey(this.indexMaintainer, put);
        return Bytes.compareTo((byte[])builtIndexRowKey, (int)0, (int)builtIndexRowKey.length, (byte[])indexRowKey, (int)0, (int)indexRowKey.length) == 0;
    }

    @Override
    protected void commitBatch(List<Mutation> indexUpdates) throws IOException, InterruptedException {
        this.ungroupedAggregateRegionObserver.checkForRegionClosingOrSplitting();
        this.indexHTable.batch(indexUpdates, null);
    }

    protected void rebuildIndexRows(Map<byte[], List<Mutation>> indexMutationMap, List<Mutation> indexRowsToBeDeleted, IndexToolVerificationResult verificationResult) throws IOException {
        if (ignoreIndexRebuildForTesting) {
            return;
        }
        this.updateIndexRows(indexMutationMap, indexRowsToBeDeleted, verificationResult);
    }

    private Map<byte[], List<Mutation>> populateActualIndexMutationMap(Map<byte[], List<Mutation>> expectedIndexMutationMap) throws IOException {
        TreeMap actualIndexMutationMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        Scan indexScan = this.prepareIndexScan(expectedIndexMutationMap);
        try (ResultScanner resultScanner = this.indexHTable.getScanner(indexScan);){
            Result result = resultScanner.next();
            while (result != null) {
                if (this.isRawFilterSupported || expectedIndexMutationMap.containsKey(result.getRow())) {
                    this.ungroupedAggregateRegionObserver.checkForRegionClosingOrSplitting();
                    List<Mutation> mutationList = this.prepareActualIndexMutations(result);
                    actualIndexMutationMap.put(result.getRow(), mutationList);
                }
                result = resultScanner.next();
            }
        }
        catch (Throwable t) {
            ServerUtil.throwIOException(this.indexHTable.getName().toString(), t);
        }
        return actualIndexMutationMap;
    }

    private void rebuildAndOrVerifyIndexRows(Map<byte[], List<Mutation>> expectedIndexMutationMap, Set<byte[]> mostRecentIndexRowKeys, IndexToolVerificationResult verificationResult) throws IOException {
        ArrayList<Mutation> indexRowsToBeDeleted = new ArrayList<Mutation>();
        if (this.verifyType == IndexTool.IndexVerifyType.NONE) {
            this.rebuildIndexRows(expectedIndexMutationMap, indexRowsToBeDeleted, verificationResult);
            return;
        }
        if (this.verifyType == IndexTool.IndexVerifyType.ONLY) {
            Map<byte[], List<Mutation>> actualIndexMutationMap = this.populateActualIndexMutationMap(expectedIndexMutationMap);
            this.verifyIndexRows(actualIndexMutationMap, expectedIndexMutationMap, mostRecentIndexRowKeys, Collections.EMPTY_LIST, verificationResult.getBefore(), true);
            return;
        }
        if (this.verifyType == IndexTool.IndexVerifyType.BEFORE) {
            Map<byte[], List<Mutation>> actualIndexMutationMap = this.populateActualIndexMutationMap(expectedIndexMutationMap);
            this.verifyIndexRows(actualIndexMutationMap, expectedIndexMutationMap, mostRecentIndexRowKeys, indexRowsToBeDeleted, verificationResult.getBefore(), true);
            if (!expectedIndexMutationMap.isEmpty() || !indexRowsToBeDeleted.isEmpty()) {
                this.rebuildIndexRows(expectedIndexMutationMap, indexRowsToBeDeleted, verificationResult);
            }
            return;
        }
        if (this.verifyType == IndexTool.IndexVerifyType.AFTER) {
            this.rebuildIndexRows(expectedIndexMutationMap, Collections.EMPTY_LIST, verificationResult);
            Map<byte[], List<Mutation>> actualIndexMutationMap = this.populateActualIndexMutationMap(expectedIndexMutationMap);
            this.verifyIndexRows(actualIndexMutationMap, expectedIndexMutationMap, mostRecentIndexRowKeys, Collections.EMPTY_LIST, verificationResult.getAfter(), false);
            return;
        }
        if (this.verifyType == IndexTool.IndexVerifyType.BOTH) {
            Map<byte[], List<Mutation>> actualIndexMutationMap = this.populateActualIndexMutationMap(expectedIndexMutationMap);
            this.verifyIndexRows(actualIndexMutationMap, expectedIndexMutationMap, mostRecentIndexRowKeys, indexRowsToBeDeleted, verificationResult.getBefore(), true);
            if (!expectedIndexMutationMap.isEmpty() || !indexRowsToBeDeleted.isEmpty()) {
                this.rebuildIndexRows(expectedIndexMutationMap, indexRowsToBeDeleted, verificationResult);
            }
            if (!expectedIndexMutationMap.isEmpty()) {
                actualIndexMutationMap = this.populateActualIndexMutationMap(expectedIndexMutationMap);
                this.verifyIndexRows(actualIndexMutationMap, expectedIndexMutationMap, mostRecentIndexRowKeys, Collections.EMPTY_LIST, verificationResult.getAfter(), false);
            }
        }
    }

    private void addRebuildAndOrVerifyTask(TaskBatch<Boolean> tasks, final Map<byte[], List<Mutation>> indexMutationMap, final Set<byte[]> mostRecentIndexRowKeys, final IndexToolVerificationResult verificationResult) {
        tasks.add(new Task<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (Thread.currentThread().isInterrupted()) {
                    IndexRebuildRegionScanner.this.exceptionMessage = "Pool closed, not attempting to rebuild and/or verify index rows! " + IndexRebuildRegionScanner.this.indexHTable.getName();
                    throw new IOException(IndexRebuildRegionScanner.this.exceptionMessage);
                }
                IndexRebuildRegionScanner.this.rebuildAndOrVerifyIndexRows(indexMutationMap, mostRecentIndexRowKeys, verificationResult);
                return Boolean.TRUE;
            }
        });
    }

    public static List<Map<byte[], List<Mutation>>> getPerTaskIndexMutationMaps(TreeMap<byte[], List<Mutation>> indexMutationMap, byte[][] endKeys, int maxMapSize) {
        int regionIndex;
        ArrayList<Map<byte[], List<Mutation>>> mapList = new ArrayList<Map<byte[], List<Mutation>>>();
        int regionCount = endKeys.length;
        byte[] indexKey = indexMutationMap.firstKey();
        TreeMap perTaskIndexMutationMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        mapList.add(perTaskIndexMutationMap);
        for (regionIndex = 0; regionIndex < regionCount - 1 && Bytes.BYTES_COMPARATOR.compare(indexKey, endKeys[regionIndex]) > 0; ++regionIndex) {
        }
        for (Map.Entry<byte[], List<Mutation>> entry : indexMutationMap.entrySet()) {
            indexKey = entry.getKey();
            if (perTaskIndexMutationMap.size() == maxMapSize || regionIndex < regionCount - 1 && Bytes.BYTES_COMPARATOR.compare(indexKey, endKeys[regionIndex]) > 0) {
                perTaskIndexMutationMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
                mapList.add(perTaskIndexMutationMap);
                while (regionIndex < regionCount - 1 && Bytes.BYTES_COMPARATOR.compare(indexKey, endKeys[regionIndex]) > 0) {
                    ++regionIndex;
                }
            }
            perTaskIndexMutationMap.put(indexKey, entry.getValue());
        }
        return mapList;
    }

    private void verifyAndOrRebuildIndex(Map<byte[], List<Mutation>> indexMutationMap, Set<byte[]> mostRecentIndexRowKeys) throws IOException {
        if (indexMutationMap.size() == 0) {
            return;
        }
        List<Map<byte[], List<Mutation>>> mapList = IndexRebuildRegionScanner.getPerTaskIndexMutationMaps((TreeMap)indexMutationMap, this.regionEndKeys, this.rowCountPerTask);
        int taskCount = mapList.size();
        TaskBatch<Boolean> tasks = new TaskBatch<Boolean>(taskCount);
        ArrayList<IndexToolVerificationResult> verificationResultList = new ArrayList<IndexToolVerificationResult>(taskCount);
        for (int i = 0; i < taskCount; ++i) {
            IndexToolVerificationResult perTaskVerificationResult = new IndexToolVerificationResult(this.scan);
            verificationResultList.add(perTaskVerificationResult);
            this.addRebuildAndOrVerifyTask(tasks, mapList.get(i), mostRecentIndexRowKeys, perTaskVerificationResult);
        }
        this.submitTasks(tasks);
        if (this.verify) {
            for (IndexToolVerificationResult result : verificationResultList) {
                this.verificationResult.add(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next(List<Cell> results) throws IOException {
        if (this.indexRowKeyforReadRepair != null && this.singleRowRebuildReturnCode == GlobalIndexChecker.RebuildReturnCode.NO_DATA_ROW.getValue()) {
            byte[] rowCountBytes = PLong.INSTANCE.toBytes(this.singleRowRebuildReturnCode);
            Cell aggKeyValue = PhoenixKeyValueUtil.newKeyValue(QueryConstants.UNGROUPED_AGG_ROW_KEY, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, rowCountBytes, 0, rowCountBytes.length);
            results.add(aggKeyValue);
            return false;
        }
        TreeMap indexMutationMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        TreeSet<byte[]> mostRecentIndexRowKeys = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        Cell lastCell = null;
        int dataRowCount = 0;
        int indexMutationCount = 0;
        this.region.startRegionOperation();
        RegionScanner localScanner = null;
        try {
            localScanner = this.getLocalScanner();
            if (localScanner == null) {
                boolean bl = false;
                return bl;
            }
            RegionScanner regionScanner = localScanner;
            synchronized (regionScanner) {
                block25: {
                    if (this.shouldVerify()) break block25;
                    this.skipped = true;
                    boolean bl = false;
                    return bl;
                }
                do {
                    this.ungroupedAggregateRegionObserver.checkForRegionClosingOrSplitting();
                    ArrayList<Cell> row = new ArrayList<Cell>();
                    this.hasMore = localScanner.nextRaw(row);
                    if (row.isEmpty()) continue;
                    lastCell = (Cell)row.get(0);
                    if (ScanUtil.isDummy(row)) break;
                    Put put = null;
                    Delete del = null;
                    for (Cell cell : row) {
                        if (cell.getType().equals((Object)Cell.Type.Put)) {
                            if (this.familyMap != null && !this.isColumnIncluded(cell)) continue;
                            if (put == null) {
                                put = new Put(CellUtil.cloneRow((Cell)cell));
                            }
                            put.add(cell);
                            continue;
                        }
                        if (del == null) {
                            del = new Delete(CellUtil.cloneRow((Cell)cell));
                        }
                        del.add(cell);
                    }
                    if (put == null && del == null) continue;
                    indexMutationCount += this.prepareIndexMutations(put, del, indexMutationMap, mostRecentIndexRowKeys);
                    ++dataRowCount;
                } while (this.hasMore && (long)indexMutationCount < this.pageSizeInRows && (long)dataRowCount < this.pageSizeInRows);
                if (!indexMutationMap.isEmpty()) {
                    if (this.indexRowKeyforReadRepair != null) {
                        this.rebuildIndexRows(indexMutationMap, Collections.EMPTY_LIST, this.verificationResult);
                    } else {
                        this.verifyAndOrRebuildIndex(indexMutationMap, mostRecentIndexRowKeys);
                    }
                }
                if (this.verify) {
                    this.verificationResult.setScannedDataRowCount(this.verificationResult.getScannedDataRowCount() + (long)dataRowCount);
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Exception in IndexRebuildRegionScanner for region " + this.region.getRegionInfo().getRegionNameAsString(), e);
            throw e;
        }
        finally {
            this.region.closeRegionOperation();
            if (localScanner != null && localScanner != this.innerScanner) {
                localScanner.close();
            }
        }
        if (this.indexRowKeyforReadRepair != null) {
            dataRowCount = this.singleRowRebuildReturnCode;
        }
        if (this.minTimestamp != 0L) {
            this.nextStartKey = ByteUtil.calculateTheClosestNextRowKeyForPrefix(CellUtil.cloneRow((Cell)lastCell));
        }
        byte[] rowCountBytes = PLong.INSTANCE.toBytes(dataRowCount);
        Cell aggKeyValue = lastCell == null ? PhoenixKeyValueUtil.newKeyValue(QueryConstants.UNGROUPED_AGG_ROW_KEY, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, rowCountBytes, 0, rowCountBytes.length) : PhoenixKeyValueUtil.newKeyValue(CellUtil.cloneRow((Cell)lastCell), QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, rowCountBytes, 0, rowCountBytes.length);
        results.add(aggKeyValue);
        return this.hasMore || this.hasMoreIncr;
    }
}

