/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.phoenix.compile.CompiledOffset;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.compile.WhereOptimizer;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.ComparisonExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.IsNullExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.parse.CastParseNode;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.EqualParseNode;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.OffsetNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.RowValueConstructorParseNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.RowValueConstructorOffsetInternalErrorException;
import org.apache.phoenix.schema.RowValueConstructorOffsetNotAllowedInQueryException;
import org.apache.phoenix.schema.RowValueConstructorOffsetNotCoercibleException;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RVCOffsetCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RVCOffsetCompiler.class);
    private static final RVCOffsetCompiler INSTANCE = new RVCOffsetCompiler();

    private RVCOffsetCompiler() {
    }

    public static RVCOffsetCompiler getInstance() {
        return INSTANCE;
    }

    public CompiledOffset getRVCOffset(StatementContext context, FilterableStatement statement, boolean inJoin, boolean inUnion, OffsetNode offsetNode) throws SQLException {
        byte[] key;
        Expression expression;
        Expression whereExpression;
        EqualParseNode equalParseNode = (EqualParseNode)offsetNode.getOffsetParseNode();
        RowValueConstructorParseNode rvcColumnsParseNode = (RowValueConstructorParseNode)equalParseNode.getLHS();
        RowValueConstructorParseNode rvcConstantParseNode = (RowValueConstructorParseNode)equalParseNode.getRHS();
        if (statement.isAggregate()) {
            throw new RowValueConstructorOffsetNotAllowedInQueryException("RVC Offset not allowed in Aggregates");
        }
        if (inJoin || inUnion) {
            throw new RowValueConstructorOffsetNotAllowedInQueryException("RVC Offset not allowed in Joins or Unions");
        }
        if (context.getResolver().getTables().size() != 1) {
            throw new RowValueConstructorOffsetNotAllowedInQueryException("RVC Offset not allowed with zero or multiple tables");
        }
        PTable pTable = context.getCurrentTable().getTable();
        List<PColumn> columns = pTable.getPKColumns();
        int numUserColumns = columns.size();
        int userColumnIndex = 0;
        Integer buckets = pTable.getBucketNum();
        if (buckets != null && buckets > 0) {
            --numUserColumns;
            ++userColumnIndex;
        }
        if (pTable.isMultiTenant() && context.getConnection().getTenantId() != null) {
            --numUserColumns;
            ++userColumnIndex;
        }
        boolean isIndex = false;
        if (PTableType.INDEX.equals((Object)pTable.getType())) {
            isIndex = true;
            if (pTable.getViewIndexId() != null) {
                --numUserColumns;
                ++userColumnIndex;
            }
        }
        if (numUserColumns != rvcConstantParseNode.getChildren().size()) {
            throw new RowValueConstructorOffsetNotCoercibleException("RVC Offset must exactly cover the tables PK.");
        }
        if (numUserColumns != rvcColumnsParseNode.getChildren().size()) {
            throw new RowValueConstructorOffsetNotCoercibleException("RVC Offset must specify the tables PKs.");
        }
        List<ColumnParseNode> rvcColumnParseNodeList = this.buildListOfColumnParseNodes(rvcColumnsParseNode, isIndex);
        if (rvcColumnParseNodeList.size() != numUserColumns) {
            throw new RowValueConstructorOffsetNotCoercibleException("RVC Offset must specify the tables PKs.");
        }
        EqualParseNode miniWhere = equalParseNode;
        Set<HintNode.Hint> originalHints = statement.getHint().getHints();
        WhereCompiler.WhereExpressionCompiler whereCompiler = new WhereCompiler.WhereExpressionCompiler(context);
        try {
            whereExpression = ((ParseNode)miniWhere).accept(whereCompiler);
        }
        catch (TypeMismatchException e) {
            throw new RowValueConstructorOffsetNotCoercibleException("RVC Offset could not be coerced to the tables PKs. " + e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error while compiling RVC Offset, got null expression.", (Throwable)e);
            throw new RowValueConstructorOffsetInternalErrorException("RVC Offset unexpected failure.");
        }
        if (whereExpression == null) {
            LOGGER.error("Unexpected error while compiling RVC Offset, got null expression.");
            throw new RowValueConstructorOffsetInternalErrorException("RVC Offset unexpected failure.");
        }
        try {
            expression = WhereOptimizer.pushKeyExpressionsToScan(context, originalHints, whereExpression, null, (Optional<byte[]>)Optional.absent());
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error while compiling RVC Offset, got null expression.");
            throw new RowValueConstructorOffsetInternalErrorException("RVC Offset unexpected failure.");
        }
        if (expression == null && whereExpression instanceof AndExpression) {
            LOGGER.error("Unexpected error while compiling RVC Offset, got null expression.");
            throw new RowValueConstructorOffsetInternalErrorException("RVC Offset unexpected failure.");
        }
        RowKeyColumnExpressionOutput rowKeyColumnExpressionOutput = this.buildListOfRowKeyColumnExpressions(whereExpression, isIndex);
        List<RowKeyColumnExpression> rowKeyColumnExpressionList = rowKeyColumnExpressionOutput.getRowKeyColumnExpressions();
        if (rowKeyColumnExpressionList.size() != numUserColumns) {
            LOGGER.warn("Unexpected error while compiling RVC Offset, expected " + numUserColumns + " found " + rowKeyColumnExpressionList.size());
            throw new RowValueConstructorOffsetInternalErrorException("RVC Offset must specify the table's PKs.");
        }
        for (int i = 0; i < numUserColumns; ++i) {
            PColumn column = columns.get(i + userColumnIndex);
            ColumnParseNode columnParseNode = rvcColumnParseNodeList.get(i);
            Object columnParseNodeString = columnParseNode.getFullName();
            if (isIndex) {
                columnParseNodeString = IndexUtil.getDataColumnName((String)columnParseNodeString);
            }
            RowKeyColumnExpression rowKeyColumnExpression = rowKeyColumnExpressionList.get(i);
            String expressionName = rowKeyColumnExpression.getName();
            expressionName = expressionName.replace("\"", "");
            if (isIndex) {
                expressionName = IndexUtil.getDataColumnName(expressionName);
            }
            if (!StringUtils.equals((CharSequence)expressionName, (CharSequence)columnParseNodeString)) {
                throw new RowValueConstructorOffsetNotCoercibleException("RVC Offset must specify the table's PKs.");
            }
            String columnString = column.getName().getString();
            if (isIndex) {
                columnString = IndexUtil.getDataColumnName(columnString);
            }
            if (StringUtils.equals((CharSequence)expressionName, (CharSequence)columnString)) continue;
            throw new RowValueConstructorOffsetNotCoercibleException("RVC Offset must specify the table's PKs.");
        }
        ScanRanges scanRanges = context.getScanRanges();
        if (!scanRanges.isPointLookup()) {
            if (!rowKeyColumnExpressionOutput.isTrailingNull()) {
                throw new RowValueConstructorOffsetNotCoercibleException("RVC Offset must be a point lookup.");
            }
            key = scanRanges.getScanRange().getUpperRange();
        } else {
            RowKeySchema.RowKeySchemaBuilder builder = new RowKeySchema.RowKeySchemaBuilder(columns.size());
            for (PColumn column : columns) {
                builder.addField(column, column.isNullable(), column.getSortOrder());
            }
            RowKeySchema rowKeySchema = builder.build();
            KeyRange pointKeyRange = scanRanges.getScanRange();
            KeyRange keyRange = KeyRange.getKeyRange(pointKeyRange.getLowerRange(), false, KeyRange.UNBOUND, true);
            ArrayList myRangeList = Lists.newArrayList((Object[])new KeyRange[]{keyRange});
            ArrayList<List<KeyRange>> slots = new ArrayList<List<KeyRange>>();
            slots.add(myRangeList);
            int[] slotSpan = new int[]{columns.size() - 1};
            key = ScanUtil.getMinKey(rowKeySchema, slots, slotSpan);
        }
        CompiledOffset compiledOffset = new CompiledOffset((Optional<Integer>)Optional.absent(), (Optional<byte[]>)Optional.of((Object)key));
        return compiledOffset;
    }

    @VisibleForTesting
    RowKeyColumnExpressionOutput buildListOfRowKeyColumnExpressions(Expression whereExpression, boolean isIndex) throws RowValueConstructorOffsetNotCoercibleException, RowValueConstructorOffsetInternalErrorException {
        ArrayList expressions;
        boolean trailingNull = false;
        if (whereExpression instanceof AndExpression) {
            expressions = whereExpression.getChildren();
        } else if (whereExpression instanceof ComparisonExpression || whereExpression instanceof IsNullExpression) {
            expressions = Lists.newArrayList((Object[])new Expression[]{whereExpression});
        } else {
            LOGGER.warn("Unexpected error while compiling RVC Offset, expected either a Comparison/IsNull Expression of a AndExpression got " + whereExpression.getClass().getName());
            throw new RowValueConstructorOffsetInternalErrorException("RVC Offset must specify the tables PKs.");
        }
        ArrayList<RowKeyColumnExpression> rowKeyColumnExpressionList = new ArrayList<RowKeyColumnExpression>();
        for (int i = 0; i < expressions.size(); ++i) {
            Expression child = (Expression)expressions.get(i);
            if (!(child instanceof ComparisonExpression) && !(child instanceof IsNullExpression)) {
                LOGGER.warn("Unexpected error while compiling RVC Offset");
                throw new RowValueConstructorOffsetNotCoercibleException("RVC Offset must specify the tables PKs.");
            }
            if (i == expressions.size() - 1 && child instanceof IsNullExpression) {
                trailingNull = true;
            }
            Expression possibleRowKeyColumnExpression = child.getChildren().get(0);
            if (isIndex && possibleRowKeyColumnExpression instanceof CoerceExpression) {
                possibleRowKeyColumnExpression = ((CoerceExpression)possibleRowKeyColumnExpression).getChild();
            }
            if (!(possibleRowKeyColumnExpression instanceof RowKeyColumnExpression)) {
                LOGGER.warn("Unexpected error while compiling RVC Offset");
                throw new RowValueConstructorOffsetNotCoercibleException("RVC Offset must specify the tables PKs.");
            }
            rowKeyColumnExpressionList.add((RowKeyColumnExpression)possibleRowKeyColumnExpression);
        }
        return new RowKeyColumnExpressionOutput(rowKeyColumnExpressionList, trailingNull);
    }

    @VisibleForTesting
    List<ColumnParseNode> buildListOfColumnParseNodes(RowValueConstructorParseNode rvcColumnsParseNode, boolean isIndex) throws RowValueConstructorOffsetNotCoercibleException {
        ArrayList<ColumnParseNode> nodes = new ArrayList<ColumnParseNode>();
        for (ParseNode node : rvcColumnsParseNode.getChildren()) {
            if (isIndex && node instanceof CastParseNode) {
                node = node.getChildren().get(0);
            }
            if (!(node instanceof ColumnParseNode)) {
                throw new RowValueConstructorOffsetNotCoercibleException("RVC Offset must specify the tables PKs.");
            }
            nodes.add((ColumnParseNode)node);
        }
        return nodes;
    }

    @VisibleForTesting
    static class RowKeyColumnExpressionOutput {
        private final List<RowKeyColumnExpression> rowKeyColumnExpressions;
        private final boolean trailingNull;

        public RowKeyColumnExpressionOutput(List<RowKeyColumnExpression> rowKeyColumnExpressions, boolean trailingNull) {
            this.rowKeyColumnExpressions = rowKeyColumnExpressions;
            this.trailingNull = trailingNull;
        }

        public List<RowKeyColumnExpression> getRowKeyColumnExpressions() {
            return this.rowKeyColumnExpressions;
        }

        public boolean isTrailingNull() {
            return this.trailingNull;
        }
    }
}

