/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.Collections;
import org.apache.phoenix.compile.BaseMutationPlan;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.CreateFunctionStatement;
import org.apache.phoenix.schema.MetaDataClient;

public class CreateFunctionCompiler {
    private final PhoenixStatement statement;

    public CreateFunctionCompiler(PhoenixStatement statement) {
        this.statement = statement;
    }

    public MutationPlan compile(CreateFunctionStatement create) throws SQLException {
        PhoenixConnection connection;
        PhoenixConnection connectionToBe = connection = this.statement.getConnection();
        StatementContext context = new StatementContext(this.statement);
        MetaDataClient client = new MetaDataClient(connectionToBe);
        return new CreateFunctionMutationPlan(context, create, client, connection);
    }

    private static class CreateFunctionMutationPlan
    extends BaseMutationPlan {
        private final StatementContext context;
        private final CreateFunctionStatement create;
        private final MetaDataClient client;
        private final PhoenixConnection connection;

        private CreateFunctionMutationPlan(StatementContext context, CreateFunctionStatement create, MetaDataClient client, PhoenixConnection connection) {
            super(context, create.getOperation());
            this.context = context;
            this.create = create;
            this.client = client;
            this.connection = connection;
        }

        @Override
        public MutationState execute() throws SQLException {
            try {
                MutationState mutationState = this.client.createFunction(this.create);
                return mutationState;
            }
            finally {
                if (this.client.getConnection() != this.connection) {
                    this.client.getConnection().close();
                }
            }
        }

        @Override
        public ExplainPlan getExplainPlan() throws SQLException {
            return new ExplainPlan(Collections.singletonList("CREATE" + (this.create.getFunctionInfo().isReplace() ? " OR REPLACE" : "") + " FUNCTION"));
        }

        @Override
        public StatementContext getContext() {
            return this.context;
        }
    }
}

