/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.PhoenixParameterMetaData;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.schema.PDatum;

public class BindManager {
    public static final Object UNBOUND_PARAMETER = new Object();
    private final List<Object> binds;
    private final PhoenixParameterMetaData bindMetaData;

    public BindManager(List<Object> binds) {
        this.binds = binds;
        this.bindMetaData = new PhoenixParameterMetaData(binds.size());
    }

    public ParameterMetaData getParameterMetaData() {
        return this.bindMetaData;
    }

    public Object getBindValue(BindParseNode node) throws SQLException {
        int index = node.getIndex();
        if (index < 0 || index >= this.binds.size()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.PARAM_INDEX_OUT_OF_BOUND).setMessage("binds size: " + this.binds.size() + "; index: " + index).build().buildException();
        }
        Object value = this.binds.get(index);
        if (value == UNBOUND_PARAMETER) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.PARAM_VALUE_UNBOUND).setMessage(node.toString()).build().buildException();
        }
        return value;
    }

    public void addParamMetaData(BindParseNode bind, PDatum column) throws SQLException {
        this.bindMetaData.addParam(bind, column);
    }
}

