/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.modularinput;

import com.splunk.modularinput.MalformedDataException;
import com.splunk.modularinput.Parameter;
import com.splunk.modularinput.XmlUtil;

public class SingleValueParameter
extends Parameter {
    private final String name;
    private final String value;

    SingleValueParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getBoolean() throws MalformedDataException {
        return XmlUtil.normalizeBoolean(this.getValue());
    }

    public int getInt() {
        return Integer.parseInt(this.getValue());
    }

    public long getLong() {
        return Long.parseLong(this.getValue());
    }

    public float getFloat() {
        return Float.parseFloat(this.getValue());
    }

    public double getDouble() {
        return Double.parseDouble(this.getValue());
    }

    public boolean equals(Object other) {
        if (!(other instanceof SingleValueParameter)) {
            return false;
        }
        SingleValueParameter that = (SingleValueParameter)other;
        return this.getValue().equals(that.getValue()) && this.getName().equals(that.getName());
    }

    public int hashCode() {
        return (this.name == null ? 0 : this.name.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
    }
}

