/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.modularinput;

import com.splunk.modularinput.Event;
import com.splunk.modularinput.MalformedDataException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class EventWriter {
    private XMLStreamWriter outputStreamWriter;
    private Writer rawOutputStreamWriter;
    private Writer errorStreamWriter;
    private boolean headerWritten = false;
    private boolean hadIOException = false;
    public static String DEBUG = "DEBUG";
    public static String INFO = "INFO";
    public static String WARN = "WARN";
    public static String ERROR = "ERROR";
    public static String FATAL = "FATAL";

    private static Writer wrapWriter(OutputStream stream) {
        try {
            return new OutputStreamWriter(stream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"Somehow your system doesn't support UTF-8");
        }
    }

    public EventWriter() throws XMLStreamException {
        this(EventWriter.wrapWriter(System.out), EventWriter.wrapWriter(System.err));
    }

    public EventWriter(Writer outputWriter, Writer errorWriter) throws XMLStreamException {
        this.rawOutputStreamWriter = outputWriter;
        this.outputStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(outputWriter);
        this.errorStreamWriter = errorWriter;
    }

    protected void clearError() {
        this.hadIOException = false;
    }

    protected void setError() {
        this.hadIOException = true;
    }

    public boolean checkError() {
        return this.hadIOException;
    }

    public synchronized void synchronizedWriteEvent(Event event) throws MalformedDataException {
        this.writeEvent(event);
    }

    public void writeEvent(Event event) throws MalformedDataException {
        try {
            if (!this.headerWritten) {
                this.outputStreamWriter.writeStartElement("stream");
                this.headerWritten = true;
            }
            event.writeTo(this.outputStreamWriter);
            this.outputStreamWriter.flush();
        }
        catch (MalformedDataException e) {
            this.log(WARN, e.toString());
            throw e;
        }
        catch (XMLStreamException e) {
            this.log(ERROR, e.toString());
        }
    }

    public synchronized void synchronizedLog(String severity, String errorMessage) {
        this.log(severity, errorMessage);
    }

    public void log(String severity, String errorMessage) {
        try {
            this.errorStreamWriter.write(severity + " " + errorMessage + "\n");
            this.errorStreamWriter.flush();
        }
        catch (IOException e) {
            this.setError();
        }
    }

    public void close() {
        try {
            this.outputStreamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            this.log(ERROR, e.toString());
        }
    }

    void writeXmlDocument(Document document) throws TransformerException, XMLStreamException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("version", "1.0");
        transformer.setOutputProperty("standalone", "yes");
        DOMSource source = new DOMSource(document);
        StringWriter buffer = new StringWriter();
        StreamResult result = new StreamResult(buffer);
        transformer.transform(source, result);
        this.rawOutputStreamWriter.write(result.getWriter().toString());
        this.rawOutputStreamWriter.flush();
    }
}

