/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import java.net.HttpCookie;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SimpleCookieStore {
    public static final String SPLUNK_AUTH_COOKIE = "splunkd_";
    private Map<String, String> cookieJar = new HashMap<String, String>();

    SimpleCookieStore() {
    }

    public void add(String setCookieHeader) {
        if (setCookieHeader != null) {
            List<HttpCookie> cookies = HttpCookie.parse(setCookieHeader);
            for (HttpCookie cookie : cookies) {
                this.cookieJar.put(cookie.getName(), cookie.getValue());
            }
        }
    }

    public String getCookies() {
        StringBuilder cookieStringBuilder = new StringBuilder();
        for (Map.Entry<String, String> cookie : this.cookieJar.entrySet()) {
            cookieStringBuilder.append(cookie.getKey());
            cookieStringBuilder.append("=");
            cookieStringBuilder.append(cookie.getValue());
            cookieStringBuilder.append("; ");
        }
        return cookieStringBuilder.toString();
    }

    public Boolean isEmpty() {
        return this.cookieJar.isEmpty();
    }

    public boolean hasSplunkAuthCookie() {
        if (this.cookieJar.isEmpty()) {
            return false;
        }
        for (String cookie : this.cookieJar.keySet()) {
            if (!cookie.startsWith(SPLUNK_AUTH_COOKIE)) continue;
            return true;
        }
        return false;
    }

    public void removeAll() {
        this.cookieJar.clear();
    }
}

