/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Entity;
import com.splunk.Service;
import java.util.HashMap;
import java.util.Map;

public class Settings
extends Entity {
    Settings(Service service) {
        super(service, "server/settings");
    }

    public String getSplunkDB() {
        return this.getString("SPLUNK_DB");
    }

    public String getSplunkHome() {
        return this.getString("SPLUNK_HOME");
    }

    public boolean getEnableSplunkWebSSL() {
        return this.getBoolean("enableSplunkWebSSL");
    }

    public String getHost() {
        return this.getString("host", null);
    }

    public int getHttpPort() {
        return this.getInteger("httpport");
    }

    public int getMgmtPort() {
        return this.getInteger("mgmtHostPort");
    }

    public int getMinFreeSpace() {
        return this.getInteger("minFreeSpace");
    }

    public String getPass4SymmKey() {
        return this.getString("pass4SymmKey");
    }

    public String getServerName() {
        return this.getString("serverName");
    }

    public String getSessionTimeout() {
        return this.getString("sessionTimeout");
    }

    public boolean getStartWebServer() {
        return this.getBoolean("startwebserver");
    }

    public String getTrustedIP() {
        return this.getString("trustedIP", null);
    }

    public void setSplunkDBPath(String path) {
        this.setCacheValue("SPLUNK_DB", path);
    }

    public void setEnableSplunkWebSSL(boolean useHttps) {
        this.setCacheValue("enableSplunkWebSSL", useHttps);
    }

    public void setHost(String host) {
        this.setCacheValue("host", host);
    }

    public void setHttpPort(int port) {
        this.setCacheValue("httpport", port);
    }

    public void setMgmtPort(int port) {
        this.setCacheValue("mgmtHostPort", port);
    }

    public void setMinimumFreeSpace(int minFreeSpace) {
        this.setCacheValue("minFreeSpace", minFreeSpace);
    }

    public void setPasswordSymmKey(String pass4SymmKey) {
        this.setCacheValue("pass4SymmKey", pass4SymmKey);
    }

    public void setServerName(String serverName) {
        this.setCacheValue("serverName", serverName);
    }

    public void setSessionTimeout(String sessionTimeout) {
        this.setCacheValue("sessionTimeout", sessionTimeout);
    }

    public void setStartWebServer(boolean startwebserver) {
        this.setCacheValue("startwebserver", startwebserver);
    }

    public void setTrustedIP(String trustedIP) {
        this.setCacheValue("trustedIP", trustedIP);
    }

    @Override
    public void update(Map<String, Object> args) {
        HashMap<String, Object> mergedArgs = new HashMap<String, Object>();
        mergedArgs.putAll(this.toUpdate);
        mergedArgs.putAll(args);
        this.service.post(this.path + "/settings", mergedArgs);
        this.toUpdate.clear();
        this.invalidate();
    }

    @Override
    public void update() {
        this.service.post(this.path + "/settings", this.toUpdate);
        this.invalidate();
    }
}

