/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.splunk.Args;
import com.splunk.BooleanComparison;
import com.splunk.BooleanPivotColumnSplit;
import com.splunk.BooleanPivotFilter;
import com.splunk.BooleanPivotRowSplit;
import com.splunk.DataModelField;
import com.splunk.DataModelObject;
import com.splunk.FieldType;
import com.splunk.HttpException;
import com.splunk.IPv4Comparison;
import com.splunk.IPv4PivotFilter;
import com.splunk.Job;
import com.splunk.LimitPivotFilter;
import com.splunk.NumberComparison;
import com.splunk.NumberPivotFilter;
import com.splunk.NumberPivotRowSplit;
import com.splunk.NumericPivotColumnSplit;
import com.splunk.Pivot;
import com.splunk.PivotCellValue;
import com.splunk.PivotColumnSplit;
import com.splunk.PivotFilter;
import com.splunk.PivotRowSplit;
import com.splunk.RangePivotColumnSplit;
import com.splunk.RangePivotRowSplit;
import com.splunk.ResponseMessage;
import com.splunk.Service;
import com.splunk.SortDirection;
import com.splunk.StatsFunction;
import com.splunk.StringComparison;
import com.splunk.StringPivotColumnSplit;
import com.splunk.StringPivotFilter;
import com.splunk.StringPivotRowSplit;
import com.splunk.TimestampBinning;
import com.splunk.TimestampPivotColumnSplit;
import com.splunk.TimestampPivotRowSplit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PivotSpecification {
    private static GsonBuilder gson = new GsonBuilder();
    private DataModelObject dataModelObject;
    private String accelerationNamespace = null;
    private List<PivotColumnSplit> columns = new ArrayList<PivotColumnSplit>();
    private List<PivotFilter> filters = new ArrayList<PivotFilter>();
    private List<PivotCellValue> cells = new ArrayList<PivotCellValue>();
    private List<PivotRowSplit> rows = new ArrayList<PivotRowSplit>();

    PivotSpecification(DataModelObject dataModelObject) {
        this.dataModelObject = dataModelObject;
        this.accelerationNamespace = dataModelObject.getDataModel().isAccelerated() ? dataModelObject.getDataModel().getName() : null;
    }

    public PivotSpecification setAccelerationNamespace(String namespace) {
        this.accelerationNamespace = namespace;
        return this;
    }

    public PivotSpecification setAccelerationJob(String sid) {
        if (sid == null) {
            throw new IllegalArgumentException("Sid to use for acceleration must not be null.");
        }
        this.accelerationNamespace = "sid=" + sid;
        return this;
    }

    public PivotSpecification setAccelerationJob(Job job) {
        this.setAccelerationJob(job.getSid());
        return this;
    }

    public String getAccelerationNamespace() {
        return this.accelerationNamespace;
    }

    private void assertCorrectlyTypedField(String fieldName, FieldType[] acceptableTypes) {
        DataModelField field = this.dataModelObject.getField(fieldName);
        if (field == null) {
            throw new IllegalArgumentException("No such field named " + fieldName);
        }
        if (!Arrays.asList(acceptableTypes).contains((Object)field.getType())) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Expected a field of one of the following types: ");
            boolean first = true;
            for (FieldType t : acceptableTypes) {
                if (!first) {
                    errorMessage.append(", ");
                }
                errorMessage.append(t.toString());
                first = false;
            }
            errorMessage.append("; found type " + field.getType().toString());
            throw new IllegalArgumentException(errorMessage.toString());
        }
    }

    private void assertCorrectlyTypedField(String field, FieldType acceptableType) {
        this.assertCorrectlyTypedField(field, new FieldType[]{acceptableType});
    }

    public PivotSpecification addFilter(String field, BooleanComparison comparison, boolean compareTo) {
        this.assertCorrectlyTypedField(field, FieldType.BOOLEAN);
        BooleanPivotFilter filter = new BooleanPivotFilter(this.dataModelObject, field, comparison, compareTo);
        this.filters.add(filter);
        return this;
    }

    public PivotSpecification addFilter(String field, StringComparison comparison, String comparisonValue) {
        this.assertCorrectlyTypedField(field, FieldType.STRING);
        StringPivotFilter filter = new StringPivotFilter(this.dataModelObject, field, comparison, comparisonValue);
        this.filters.add(filter);
        return this;
    }

    public PivotSpecification addFilter(String field, IPv4Comparison comparison, String comparisonValue) {
        this.assertCorrectlyTypedField(field, FieldType.IPV4);
        IPv4PivotFilter filter = new IPv4PivotFilter(this.dataModelObject, field, comparison, comparisonValue);
        this.filters.add(filter);
        return this;
    }

    public PivotSpecification addFilter(String field, NumberComparison comparison, double comparisonValue) {
        this.assertCorrectlyTypedField(field, FieldType.NUMBER);
        NumberPivotFilter filter = new NumberPivotFilter(this.dataModelObject, field, comparison, comparisonValue);
        this.filters.add(filter);
        return this;
    }

    public PivotSpecification addFilter(String field, String sortAttribute, SortDirection sortDirection, int limit, StatsFunction statsFunction) {
        if (!this.dataModelObject.containsField(field)) {
            throw new IllegalArgumentException("No such field " + sortAttribute);
        }
        this.assertCorrectlyTypedField(sortAttribute, new FieldType[]{FieldType.STRING, FieldType.NUMBER, FieldType.OBJECTCOUNT});
        LimitPivotFilter filter = new LimitPivotFilter(this.dataModelObject, field, sortAttribute, sortDirection, limit, statsFunction);
        this.filters.add(filter);
        return this;
    }

    public PivotSpecification addRowSplit(String field, String label) {
        this.assertCorrectlyTypedField(field, new FieldType[]{FieldType.NUMBER, FieldType.STRING});
        FieldType t = this.dataModelObject.getField(field).getType();
        if (t == FieldType.NUMBER) {
            this.rows.add(new NumberPivotRowSplit(this.dataModelObject, field, label));
        } else if (t == FieldType.STRING) {
            this.rows.add(new StringPivotRowSplit(this.dataModelObject, field, label));
        } else {
            throw new IllegalArgumentException("Field not of type number or string despite precondition asserting so.");
        }
        return this;
    }

    public PivotSpecification addRowSplit(String field, String label, Integer start, Integer end, Integer step, Integer limit) {
        this.assertCorrectlyTypedField(field, FieldType.NUMBER);
        RangePivotRowSplit split = new RangePivotRowSplit(this.dataModelObject, field, label, start, end, step, limit);
        this.rows.add(split);
        return this;
    }

    public PivotSpecification addRowSplit(String field, String label, String trueDisplayValue, String falseDisplayValue) {
        this.assertCorrectlyTypedField(field, FieldType.BOOLEAN);
        BooleanPivotRowSplit split = new BooleanPivotRowSplit(this.dataModelObject, field, label, trueDisplayValue, falseDisplayValue);
        this.rows.add(split);
        return this;
    }

    public PivotSpecification addRowSplit(String field, String label, TimestampBinning binning) {
        this.assertCorrectlyTypedField(field, FieldType.TIMESTAMP);
        TimestampPivotRowSplit split = new TimestampPivotRowSplit(this.dataModelObject, field, label, binning);
        this.rows.add(split);
        return this;
    }

    public PivotSpecification addColumnSplit(String field) {
        this.assertCorrectlyTypedField(field, new FieldType[]{FieldType.NUMBER, FieldType.STRING});
        FieldType t = this.dataModelObject.getField(field).getType();
        if (t == FieldType.NUMBER) {
            this.columns.add(new NumericPivotColumnSplit(this.dataModelObject, field));
        } else if (t == FieldType.STRING) {
            this.columns.add(new StringPivotColumnSplit(this.dataModelObject, field));
        }
        return this;
    }

    public PivotSpecification addColumnSplit(String field, Integer start, Integer end, Integer step, Integer limit) {
        this.assertCorrectlyTypedField(field, FieldType.NUMBER);
        RangePivotColumnSplit split = new RangePivotColumnSplit(this.dataModelObject, field, start, end, step, limit);
        this.columns.add(split);
        return this;
    }

    public PivotSpecification addColumnSplit(String field, String trueDisplayValue, String falseDisplayValue) {
        this.assertCorrectlyTypedField(field, FieldType.BOOLEAN);
        BooleanPivotColumnSplit split = new BooleanPivotColumnSplit(this.dataModelObject, field, trueDisplayValue, falseDisplayValue);
        this.columns.add(split);
        return this;
    }

    public PivotSpecification addColumnSplit(String field, TimestampBinning binning) {
        this.assertCorrectlyTypedField(field, FieldType.TIMESTAMP);
        TimestampPivotColumnSplit split = new TimestampPivotColumnSplit(this.dataModelObject, field, binning);
        this.columns.add(split);
        return this;
    }

    public PivotSpecification addCellValue(String field, String label, StatsFunction statsFunction) {
        this.cells.add(new PivotCellValue(this.dataModelObject, field, label, statsFunction));
        return this;
    }

    JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.addProperty("dataModel", this.dataModelObject.getDataModel().getName());
        root.addProperty("baseClass", this.dataModelObject.getName());
        JsonArray filterArray = new JsonArray();
        for (PivotFilter pivotFilter : this.filters) {
            filterArray.add(pivotFilter.toJson());
        }
        root.add("filters", (JsonElement)filterArray);
        JsonArray rowsplitArray = new JsonArray();
        for (PivotRowSplit pivotRowSplit : this.rows) {
            rowsplitArray.add(pivotRowSplit.toJson());
        }
        root.add("rows", (JsonElement)rowsplitArray);
        JsonArray jsonArray = new JsonArray();
        for (PivotCellValue p : this.cells) {
            jsonArray.add((JsonElement)p.toJson());
        }
        root.add("cells", (JsonElement)jsonArray);
        JsonArray jsonArray2 = new JsonArray();
        for (PivotColumnSplit p : this.columns) {
            jsonArray2.add((JsonElement)p.toJson());
        }
        root.add("columns", (JsonElement)jsonArray2);
        return root;
    }

    public Collection<PivotFilter> getFilters() {
        return Collections.unmodifiableCollection(this.filters);
    }

    public Collection<PivotRowSplit> getRowSplits() {
        return Collections.unmodifiableCollection(this.rows);
    }

    public Collection<PivotColumnSplit> getColumnSplits() {
        return Collections.unmodifiableCollection(this.columns);
    }

    public Collection<PivotCellValue> getCellValues() {
        return Collections.unmodifiableCollection(this.cells);
    }

    public Pivot pivot() {
        ResponseMessage response;
        Service service = this.dataModelObject.getDataModel().getService();
        Args args = new Args();
        args.put("pivot_json", this.toJson());
        if (this.accelerationNamespace != null) {
            args.put("namespace", this.accelerationNamespace);
        }
        if ((response = service.get("datamodel/pivot/" + this.dataModelObject.getDataModel().getName(), args)).getStatus() != 200) {
            throw HttpException.create(response);
        }
        return Pivot.parseStream(service, response.getContent());
    }
}

