/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.splunk.DataModelObject;
import com.splunk.FieldType;
import com.splunk.Util;

public abstract class PivotFilter {
    protected final DataModelObject dataModelObject;
    protected final String fieldName;

    PivotFilter(DataModelObject dataModelObject, String fieldName) {
        this.dataModelObject = dataModelObject;
        if (!dataModelObject.containsField(fieldName)) {
            throw new IllegalArgumentException("No such field " + fieldName + " on specified data model object.");
        }
        this.fieldName = fieldName;
    }

    public String getOwnerName() {
        return this.dataModelObject.getField(this.fieldName).getOwnerName();
    }

    public String[] getOwnerLineage() {
        return this.dataModelObject.getField(this.fieldName).getOwnerLineage();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public FieldType getType() {
        return this.dataModelObject.getField(this.fieldName).getType();
    }

    abstract JsonElement toJson();

    protected void addCommonFields(JsonObject root) {
        root.addProperty("fieldName", this.fieldName);
        root.addProperty("owner", Util.join(".", this.dataModelObject.getField(this.fieldName).getOwnerLineage()));
        root.addProperty("type", this.getType().toString());
    }
}

