/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.AtomEntry;
import com.splunk.AtomFeed;
import com.splunk.Job;
import com.splunk.JobArgs;
import com.splunk.Service;
import java.io.InputStream;

public class Pivot {
    private final String openInSearch;
    private final String drilldownSearch;
    private final String pivotSearch;
    private final String tstatsSearch;
    private final Service service;
    private final String search;

    private Pivot(Service service, AtomEntry entry) {
        this.service = service;
        this.openInSearch = entry.content.getString("open_in_search");
        this.drilldownSearch = entry.content.getString("drilldown_search");
        this.pivotSearch = entry.content.getString("pivot_search");
        this.search = entry.content.getString("search");
        this.tstatsSearch = entry.content.getString("tstats_search", null);
    }

    public String getPivotQuery() {
        return this.pivotSearch;
    }

    public String getAcceleratedQuery() {
        return this.tstatsSearch;
    }

    public String getQueryForDrilldown() {
        return this.drilldownSearch;
    }

    public String getPrettyQuery() {
        return this.openInSearch;
    }

    public String getRawQuery() {
        return this.search;
    }

    public Job run() {
        return this.run(new JobArgs());
    }

    public Job run(JobArgs args) {
        if (this.getAcceleratedQuery() == null) {
            return this.service.search(this.getPivotQuery(), args);
        }
        return this.service.search(this.getAcceleratedQuery(), args);
    }

    static Pivot parseStream(Service service, InputStream content) {
        AtomFeed feed = AtomFeed.parseStream(content);
        if (feed.entries.size() != 1) {
            throw new IllegalStateException("Expected one Atom entry; found " + feed.entries.size());
        }
        AtomEntry entry = feed.entries.get(0);
        return new Pivot(service, entry);
    }
}

