/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.AtomObject;
import com.splunk.Record;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class AtomEntry
extends AtomObject {
    public String published;
    public Record content;

    static AtomEntry create() {
        return new AtomEntry();
    }

    public static AtomEntry parseStream(InputStream input) {
        XMLStreamReader reader = AtomEntry.createReader(input);
        AtomEntry result = AtomEntry.parse(reader);
        try {
            reader.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result;
    }

    static AtomEntry parse(XMLStreamReader reader) {
        AtomEntry entry = AtomEntry.create();
        entry.load(reader, "entry");
        return entry;
    }

    @Override
    void init(XMLStreamReader reader) {
        assert (reader.isStartElement());
        String name = reader.getLocalName();
        if (name.equals("published")) {
            this.published = this.parseText(reader);
        } else if (name.equals("content")) {
            this.content = this.parseContent(reader);
        } else {
            super.init(reader);
        }
    }

    private Record parseContent(XMLStreamReader reader) {
        assert (AtomEntry.isStartElement(reader, "content"));
        AtomEntry.scan(reader);
        if (!AtomEntry.isStartElement(reader, "dict")) {
            AtomEntry.syntaxError(reader);
        }
        this.content = this.parseDict(reader);
        if (!AtomEntry.isEndElement(reader, "content")) {
            AtomEntry.syntaxError(reader);
        }
        AtomEntry.scan(reader);
        return this.content;
    }

    private Record parseDict(XMLStreamReader reader) {
        assert (AtomEntry.isStartElement(reader, "dict"));
        Record result = new Record();
        AtomEntry.scan(reader);
        while (AtomEntry.isStartElement(reader, "key")) {
            String key = reader.getAttributeValue(null, "name");
            Object value = this.parseValue(reader);
            if (value == null) continue;
            result.put(key, value);
        }
        if (!AtomEntry.isEndElement(reader, "dict")) {
            AtomEntry.syntaxError(reader);
        }
        AtomEntry.scan(reader);
        return result;
    }

    private List parseList(XMLStreamReader reader) {
        assert (AtomEntry.isStartElement(reader, "list"));
        ArrayList<Object> result = new ArrayList<Object>();
        AtomEntry.scan(reader);
        while (AtomEntry.isStartElement(reader, "item")) {
            Object value = this.parseValue(reader);
            result.add(value);
        }
        if (!AtomEntry.isEndElement(reader, "list")) {
            AtomEntry.syntaxError(reader);
        }
        AtomEntry.scan(reader);
        return result;
    }

    private Object parseStructure(XMLStreamReader reader) {
        String name = reader.getLocalName();
        if (name.equals("dict")) {
            return this.parseDict(reader);
        }
        if (name.equals("list")) {
            return this.parseList(reader);
        }
        AtomEntry.syntaxError(reader);
        return null;
    }

    Object parseValue(XMLStreamReader reader) {
        Object value;
        assert (reader.isStartElement());
        String name = reader.getLocalName();
        AtomEntry.scan(reader);
        switch (reader.getEventType()) {
            case 4: {
                value = reader.getText();
                AtomEntry.scan(reader);
                break;
            }
            case 1: {
                value = this.parseStructure(reader);
                break;
            }
            case 2: {
                value = null;
                break;
            }
            default: {
                value = null;
                AtomEntry.syntaxError(reader);
            }
        }
        if (!AtomEntry.isEndElement(reader, name)) {
            AtomEntry.syntaxError(reader);
        }
        AtomEntry.scan(reader);
        return value;
    }
}

