/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.metastore.metadata.BaseMetadata;
import org.apache.drill.metastore.metadata.Metadata;
import org.apache.drill.metastore.metadata.TableMetadata;
import org.apache.drill.metastore.statistics.BaseStatisticsKind;
import org.apache.drill.metastore.statistics.CollectableColumnStatisticsKind;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.ColumnStatisticsKind;
import org.apache.drill.metastore.statistics.StatisticsHolder;
import org.apache.drill.metastore.statistics.TableStatisticsKind;
import org.apache.drill.shaded.guava.com.google.common.primitives.UnsignedBytes;

public class TableMetadataUtils {
    public static <T> Comparator<T> getComparator(TypeProtos.MinorType type) {
        switch (type) {
            case INTERVALDAY: 
            case INTERVAL: 
            case INTERVALYEAR: {
                return Comparator.nullsFirst(UnsignedBytes.lexicographicalComparator());
            }
            case UINT1: {
                return Comparator.nullsFirst(UnsignedBytes::compare);
            }
            case UINT2: 
            case UINT4: {
                return Comparator.nullsFirst(Integer::compareUnsigned);
            }
            case UINT8: {
                return Comparator.nullsFirst(Long::compareUnsigned);
            }
        }
        return TableMetadataUtils.getNaturalNullsFirstComparator();
    }

    public static <T extends Comparable<T>> Comparator<T> getNaturalNullsFirstComparator() {
        return Comparator.nullsFirst(Comparator.naturalOrder());
    }

    public static <T extends BaseMetadata> Map<SchemaPath, ColumnStatistics<?>> mergeColumnsStatistics(Collection<T> metadataList, Set<SchemaPath> columns, List<CollectableColumnStatisticsKind<?>> statisticsToCollect) {
        HashMap columnsStatistics = new HashMap();
        for (SchemaPath column : columns) {
            Object metadata2;
            ArrayList statisticsList = new ArrayList();
            for (Object metadata2 : metadataList) {
                ColumnStatistics<Object> statistics = ((BaseMetadata)metadata2).getColumnsStatistics().get(column);
                if (statistics == null) {
                    statistics = new ColumnStatistics(Collections.singletonList(new StatisticsHolder<Long>(TableStatisticsKind.ROW_COUNT.getValue((Metadata)metadata2), (BaseStatisticsKind<?>)ColumnStatisticsKind.NULLS_COUNT)));
                }
                statisticsList.add(statistics);
            }
            ArrayList statisticsHolders = new ArrayList();
            metadata2 = statisticsToCollect.iterator();
            while (metadata2.hasNext()) {
                CollectableColumnStatisticsKind statisticsKind = (CollectableColumnStatisticsKind)metadata2.next();
                Object mergedStatistic = statisticsKind.mergeStatistics(statisticsList);
                statisticsHolders.add(new StatisticsHolder<Object>(mergedStatistic, statisticsKind));
            }
            Iterator iterator = statisticsList.iterator();
            TypeProtos.MinorType comparatorType = iterator.hasNext() ? ((ColumnStatistics)iterator.next()).getComparatorType() : TypeProtos.MinorType.INT;
            columnsStatistics.put(column, new ColumnStatistics(statisticsHolders, comparatorType));
        }
        return columnsStatistics;
    }

    public static TableMetadata updateRowCount(TableMetadata tableMetadata, Collection<? extends BaseMetadata> statistics) {
        ArrayList newStats = new ArrayList();
        newStats.add(new StatisticsHolder<Long>(TableStatisticsKind.ROW_COUNT.mergeStatistics(statistics), (BaseStatisticsKind<?>)TableStatisticsKind.ROW_COUNT));
        Set<SchemaPath> columns = tableMetadata.getColumnsStatistics().keySet();
        Map<SchemaPath, ColumnStatistics<?>> columnsStatistics = TableMetadataUtils.mergeColumnsStatistics(statistics, columns, Collections.singletonList(ColumnStatisticsKind.NULLS_COUNT));
        return tableMetadata.cloneWithStats(columnsStatistics, newStats);
    }
}

