/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.statistics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.drill.metastore.statistics.StatisticsKind;

public class BaseStatisticsKind<T>
implements StatisticsKind<T> {
    protected final String statisticKey;
    protected final boolean exact;

    @JsonCreator
    public BaseStatisticsKind(@JsonProperty(value="name") String statisticKey, @JsonProperty(value="exact") boolean exact) {
        this.statisticKey = statisticKey;
        this.exact = exact;
    }

    @Override
    public String getName() {
        return this.statisticKey;
    }

    @Override
    public boolean isExact() {
        return this.exact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseStatisticsKind)) {
            return false;
        }
        BaseStatisticsKind that = (BaseStatisticsKind)o;
        return this.exact == that.exact && Objects.equals(this.statisticKey, that.statisticKey);
    }

    public int hashCode() {
        return Objects.hash(this.statisticKey, this.exact);
    }

    public String toString() {
        return new StringJoiner(", ", BaseStatisticsKind.class.getSimpleName() + "[", "]").add("statisticKey='" + this.statisticKey + "'").add("exact=" + this.exact).toString();
    }
}

