/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.metadata.MetadataType;

@JsonTypeName(value="metadataInfo")
@JsonDeserialize(builder=MetadataInfoBuilder.class)
public class MetadataInfo {
    public static final String GENERAL_INFO_KEY = "GENERAL_INFO";
    public static final String DEFAULT_SEGMENT_KEY = "DEFAULT_SEGMENT";
    public static final String DEFAULT_COLUMN_PREFIX = "_$SEGMENT_";
    private static final String UNDEFINED_KEY = "UNDEFINED_KEY";
    private final MetadataType type;
    private final String key;
    private final String identifier;

    private MetadataInfo(MetadataInfoBuilder builder) {
        this.type = builder.type;
        this.key = builder.key;
        this.identifier = builder.identifier;
    }

    @JsonProperty
    public MetadataType type() {
        return this.type;
    }

    @JsonProperty
    public String key() {
        return this.key;
    }

    @JsonProperty
    public String identifier() {
        return this.identifier;
    }

    public void toMetadataUnitBuilder(TableMetadataUnit.Builder builder) {
        builder.metadataType(this.type.name());
        builder.metadataKey(this.key);
        builder.metadataIdentifier(this.identifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.key, this.identifier});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataInfo that = (MetadataInfo)o;
        return this.type == that.type && Objects.equals(this.key, that.key) && Objects.equals(this.identifier, that.identifier);
    }

    public String toString() {
        return new StringJoiner(", ", MetadataInfo.class.getSimpleName() + "[", "]").add("type=" + (Object)((Object)this.type)).add("key=" + this.key).add("identifier=" + this.identifier).toString();
    }

    public static MetadataInfoBuilder builder() {
        return new MetadataInfoBuilder();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class MetadataInfoBuilder {
        private MetadataType type;
        private String key;
        private String identifier;

        public MetadataInfoBuilder type(MetadataType type) {
            this.type = type;
            return this;
        }

        public MetadataInfoBuilder key(String key) {
            this.key = key;
            return this;
        }

        public MetadataInfoBuilder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public MetadataInfoBuilder metadataUnit(TableMetadataUnit unit) {
            this.type(MetadataType.fromValue(unit.metadataType()));
            this.key(unit.metadataKey());
            this.identifier(unit.metadataIdentifier());
            return this;
        }

        public MetadataInfo build() {
            Objects.requireNonNull(this.type, "type was not set");
            this.key = this.key == null ? MetadataInfo.UNDEFINED_KEY : this.key;
            this.identifier = this.identifier == null ? this.key : this.identifier;
            return new MetadataInfo(this);
        }
    }
}

