/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore;

import java.util.stream.Stream;
import org.apache.drill.metastore.exceptions.MetastoreException;

public enum MetastoreColumn {
    STORAGE_PLUGIN("storagePlugin"),
    WORKSPACE("workspace"),
    TABLE_NAME("tableName"),
    OWNER("owner"),
    TABLE_TYPE("tableType"),
    METADATA_TYPE("metadataType"),
    METADATA_KEY("metadataKey"),
    LOCATION("location"),
    INTERESTING_COLUMNS("interestingColumns"),
    SCHEMA("schema"),
    COLUMNS_STATISTICS("columnsStatistics"),
    METADATA_STATISTICS("metadataStatistics"),
    LAST_MODIFIED_TIME("lastModifiedTime"),
    PARTITION_KEYS("partitionKeys"),
    ADDITIONAL_METADATA("additionalMetadata"),
    METADATA_IDENTIFIER("metadataIdentifier"),
    COLUMN("column"),
    LOCATIONS("locations"),
    PARTITION_VALUES("partitionValues"),
    PATH("path"),
    ROW_GROUP_INDEX("rowGroupIndex"),
    HOST_AFFINITY("hostAffinity");

    private final String columnName;

    private MetastoreColumn(String columnName) {
        this.columnName = columnName;
    }

    public String columnName() {
        return this.columnName;
    }

    public static MetastoreColumn of(String columnName) {
        return Stream.of(MetastoreColumn.values()).filter(column -> column.columnName.equals(columnName)).findAny().orElseThrow(() -> new MetastoreException(String.format("Column with name [%s] is absent.", columnName)));
    }
}

