/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.drill.plugin.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.drill.plugin.DrillScanSpec;
import org.apache.drill.exec.store.drill.plugin.DrillStoragePlugin;
import org.apache.drill.exec.store.plan.rel.PluginDrillTable;
import org.apache.drill.exec.util.ImpersonationUtil;

public class DrillPluginSchema
extends AbstractSchema {
    private final DrillStoragePlugin plugin;
    private final Map<String, DrillPluginSchema> schemaMap = new HashMap<String, DrillPluginSchema>();
    private final Map<String, DrillTable> drillTables = new HashMap<String, DrillTable>();
    private final String userName;

    public DrillPluginSchema(DrillStoragePlugin plugin, String name, String userName) {
        super(Collections.emptyList(), name);
        this.plugin = plugin;
        this.userName = Optional.ofNullable(userName).orElse(ImpersonationUtil.getProcessUserName());
        this.getSchemasList().stream().map(UserProtos.SchemaMetadata::getSchemaName).map(String::toLowerCase).map(SchemaPath::parseFromString).forEach(this::addSubSchema);
    }

    private DrillPluginSchema(DrillStoragePlugin plugin, List<String> parentSchemaPath, String name, String userName) {
        super(parentSchemaPath, name);
        this.plugin = plugin;
        this.userName = userName;
    }

    private void addSubSchema(SchemaPath path) {
        DrillPluginSchema drillSchema = new DrillPluginSchema(this.plugin, this.getSchemaPath(), path.getRootSegmentPath(), this.userName);
        this.schemaMap.put(path.getRootSegmentPath(), drillSchema);
        while (!path.isLeaf()) {
            path = new SchemaPath(path.getRootSegment().getChild().getNameSegment());
            DrillPluginSchema child = new DrillPluginSchema(this.plugin, drillSchema.getSchemaPath(), path.getRootSegmentPath(), this.userName);
            drillSchema.schemaMap.put(path.getRootSegmentPath(), child);
            drillSchema = child;
        }
    }

    private List<UserProtos.SchemaMetadata> getSchemasList() {
        try {
            return ((UserProtos.GetSchemasResp)this.plugin.getClient(this.userName).getSchemas(null, null).get()).getSchemasList();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }

    public AbstractSchema getSubSchema(String name) {
        return this.schemaMap.get(name);
    }

    void setHolder(SchemaPlus plusOfThis) {
        this.getSubSchemaNames().forEach(s -> plusOfThis.add(s, (Schema)this.getSubSchema((String)s)));
    }

    public boolean showInInformationSchema() {
        return true;
    }

    public Set<String> getSubSchemaNames() {
        return this.schemaMap.keySet();
    }

    public Table getTable(String name) {
        return (Table)this.drillTables.computeIfAbsent(name, key -> {
            DrillScanSpec drillScanSpec = new DrillScanSpec(this.getSchemaPath(), (String)key);
            return new PluginDrillTable((StoragePlugin)this.plugin, this.getName(), null, (DrillTableSelection)drillScanSpec, this.plugin.convention());
        });
    }

    public String getTypeName() {
        return "drill";
    }

    public Set<String> getTableNames() {
        try {
            List schemaPaths = this.getSchemaPath();
            String schemaPath = SchemaPath.getCompoundPath((String[])schemaPaths.subList(1, schemaPaths.size()).toArray(new String[0])).getAsUnescapedPath();
            UserProtos.LikeFilter schemaNameFilter = UserProtos.LikeFilter.newBuilder().setPattern(schemaPath).build();
            return ((UserProtos.GetTablesResp)this.plugin.getClient(this.userName).getTables(null, schemaNameFilter, null, null).get()).getTablesList().stream().map(UserProtos.TableMetadata::getTableName).collect(Collectors.toSet());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }
}

