/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.drill.plugin;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.store.drill.plugin.DrillStoragePluginConfig;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

@JsonTypeName(value="drill-read")
public class DrillSubScan
extends AbstractBase
implements SubScan {
    public static final String OPERATOR_TYPE = "DRILL_SUB_SCAN";
    private final String query;
    @JsonProperty
    private final DrillStoragePluginConfig pluginConfig;

    @JsonCreator
    public DrillSubScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="pluginConfig") StoragePluginConfig pluginConfig, @JsonProperty(value="query") String query) {
        super(userName);
        this.pluginConfig = (DrillStoragePluginConfig)pluginConfig;
        this.query = query;
    }

    public DrillSubScan(String userName, DrillStoragePluginConfig storagePluginConfig, String query) {
        super(userName);
        this.pluginConfig = storagePluginConfig;
        this.query = query;
    }

    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return (T)physicalVisitor.visitSubScan((SubScan)this, value);
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new DrillSubScan(this.getUserName(), this.pluginConfig, this.query);
    }

    public DrillStoragePluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    public String getQuery() {
        return this.query;
    }

    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    public Iterator<PhysicalOperator> iterator() {
        return Collections.emptyIterator();
    }
}

