/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.drill.plugin;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.calcite.avatica.ConnectStringParser;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="drill")
public class DrillStoragePluginConfig
extends StoragePluginConfig {
    private static final Logger logger = LoggerFactory.getLogger(DrillStoragePluginConfig.class);
    public static final String NAME = "drill";
    public static final String CONNECTION_STRING_PREFIX = "jdbc:drill:";
    private static final String DEFAULT_QUOTING_IDENTIFIER = "`";
    private final String connection;
    private final Properties properties;

    @JsonCreator
    public DrillStoragePluginConfig(@JsonProperty(value="connection") String connection, @JsonProperty(value="properties") Properties properties, @JsonProperty(value="credentialsProvider") CredentialsProvider credentialsProvider, @JsonProperty(value="authMode") String authMode) {
        super(DrillStoragePluginConfig.getCredentialsProvider(credentialsProvider), credentialsProvider == null, StoragePluginConfig.AuthMode.parseOrDefault((String)authMode, (StoragePluginConfig.AuthMode)StoragePluginConfig.AuthMode.SHARED_USER));
        this.connection = connection;
        this.properties = Optional.ofNullable(properties).orElse(new Properties());
    }

    private DrillStoragePluginConfig(DrillStoragePluginConfig that, CredentialsProvider credentialsProvider) {
        super(DrillStoragePluginConfig.getCredentialsProvider(credentialsProvider), credentialsProvider == null, that.authMode);
        this.connection = that.connection;
        this.properties = that.properties;
    }

    @JsonProperty(value="connection")
    public String getConnection() {
        return this.connection;
    }

    @JsonProperty(value="properties")
    public Properties getProperties() {
        return this.properties;
    }

    private static CredentialsProvider getCredentialsProvider(CredentialsProvider credentialsProvider) {
        return credentialsProvider != null ? credentialsProvider : PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER;
    }

    @JsonIgnore
    public String getIdentifierQuoteString() {
        return this.properties.getProperty("quoting_identifiers", DEFAULT_QUOTING_IDENTIFIER);
    }

    public DrillStoragePluginConfig updateCredentialProvider(CredentialsProvider credentialsProvider) {
        return new DrillStoragePluginConfig(this, credentialsProvider);
    }

    private Optional<UsernamePasswordCredentials> getUsernamePasswordCredentials(UserBitShared.UserCredentials userCredentials) {
        switch (this.authMode) {
            case SHARED_USER: {
                return new UsernamePasswordCredentials.Builder().setCredentialsProvider(this.credentialsProvider).build();
            }
            case USER_TRANSLATION: {
                Preconditions.checkNotNull((Object)userCredentials, (Object)"A drill query user is required for user translation auth mode.");
                return new UsernamePasswordCredentials.Builder().setCredentialsProvider(this.credentialsProvider).setQueryUser(userCredentials.getUserName()).build();
            }
        }
        throw UserException.validationError().message("This storage plugin does not support auth mode: %s", new Object[]{this.authMode}).build(logger);
    }

    private Map<String, String> getCredentials(UserBitShared.UserCredentials userCredentials) {
        return this.getUsernamePasswordCredentials(userCredentials).map(creds -> ImmutableMap.of((Object)"user", (Object)creds.getUsername(), (Object)"password", (Object)creds.getPassword())).orElse(Collections.emptyMap());
    }

    @JsonIgnore
    public DrillClient getDrillClient(String userName, BufferAllocator allocator) {
        try {
            String urlSuffix = this.connection.substring(CONNECTION_STRING_PREFIX.length());
            Properties props = ConnectStringParser.parse((String)urlSuffix, (Properties)this.properties);
            props.putAll(this.getCredentials(UserBitShared.UserCredentials.newBuilder().setUserName(userName).build()));
            DrillConfig dConfig = DrillConfig.forClient();
            boolean isDirect = props.getProperty("drillbit") != null;
            DrillClient client = new DrillClient(dConfig, null, allocator, isDirect);
            String connect = props.getProperty("zk");
            client.connect(connect, props);
            return client;
        }
        catch (SQLException | RpcException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DrillStoragePluginConfig that = (DrillStoragePluginConfig)((Object)o);
        return Objects.equals(this.connection, that.connection);
    }

    public int hashCode() {
        return Objects.hash(this.connection);
    }
}

