/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetWorkRequestRequest
extends BmcRequest<Void> {
    private String workRequestId;
    private String opcClientRequestId;

    @ConstructorProperties(value={"workRequestId", "opcClientRequestId"})
    GetWorkRequestRequest(String workRequestId, String opcClientRequestId) {
        this.workRequestId = workRequestId;
        this.opcClientRequestId = opcClientRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().workRequestId(this.workRequestId).opcClientRequestId(this.opcClientRequestId);
    }

    public String toString() {
        return "GetWorkRequestRequest(super=" + super.toString() + ", workRequestId=" + this.getWorkRequestId() + ", opcClientRequestId=" + this.getOpcClientRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetWorkRequestRequest)) {
            return false;
        }
        GetWorkRequestRequest other = (GetWorkRequestRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$workRequestId = this.getWorkRequestId();
        String other$workRequestId = other.getWorkRequestId();
        if (this$workRequestId == null ? other$workRequestId != null : !this$workRequestId.equals(other$workRequestId)) {
            return false;
        }
        String this$opcClientRequestId = this.getOpcClientRequestId();
        String other$opcClientRequestId = other.getOpcClientRequestId();
        return !(this$opcClientRequestId == null ? other$opcClientRequestId != null : !this$opcClientRequestId.equals(other$opcClientRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetWorkRequestRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $workRequestId = this.getWorkRequestId();
        result = result * 59 + ($workRequestId == null ? 43 : $workRequestId.hashCode());
        String $opcClientRequestId = this.getOpcClientRequestId();
        result = result * 59 + ($opcClientRequestId == null ? 43 : $opcClientRequestId.hashCode());
        return result;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetWorkRequestRequest, Void> {
        private String workRequestId;
        private String opcClientRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetWorkRequestRequest o) {
            this.workRequestId(o.getWorkRequestId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetWorkRequestRequest build() {
            GetWorkRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public GetWorkRequestRequest buildWithoutInvocationCallback() {
            return new GetWorkRequestRequest(this.workRequestId, this.opcClientRequestId);
        }

        public String toString() {
            return "GetWorkRequestRequest.Builder(workRequestId=" + this.workRequestId + ", opcClientRequestId=" + this.opcClientRequestId + ")";
        }
    }
}

