/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.objectstorage.model.Bucket;
import com.oracle.bmc.objectstorage.requests.CreateBucketRequest;
import com.oracle.bmc.objectstorage.responses.CreateBucketResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBucketConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateBucketConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateBucketRequest interceptRequest(CreateBucketRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateBucketRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateBucketDetails(), (String)"createBucketDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("n").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("b");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcClientRequestId() != null) {
            ib.header("opc-client-request-id", (Object)request.getOpcClientRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, CreateBucketResponse> fromResponse() {
        Function<Response, CreateBucketResponse> transformer = new Function<Response, CreateBucketResponse>(){

            public CreateBucketResponse apply(Response rawResponse) {
                Optional locationHeader;
                Optional eTagHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.objectstorage.responses.CreateBucketResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Bucket.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                CreateBucketResponse.Builder builder = CreateBucketResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.bucket((Bucket)response.getItem());
                Optional opcClientRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-client-request-id");
                if (opcClientRequestIdHeader.isPresent()) {
                    builder.opcClientRequestId((String)HeaderUtils.toValue((String)"opc-client-request-id", (String)((String)((List)opcClientRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((eTagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"ETag")).isPresent()) {
                    builder.eTag((String)HeaderUtils.toValue((String)"ETag", (String)((String)((List)eTagHeader.get()).get(0)), String.class));
                }
                if ((locationHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"Location")).isPresent()) {
                    builder.location((String)HeaderUtils.toValue((String)"Location", (String)((String)((List)locationHeader.get()).get(0)), String.class));
                }
                CreateBucketResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

