/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage;

import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.DefaultConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.objectstorage.ObjectStorageAsync;
import com.oracle.bmc.objectstorage.internal.http.AbortMultipartUploadConverter;
import com.oracle.bmc.objectstorage.internal.http.CancelWorkRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.CommitMultipartUploadConverter;
import com.oracle.bmc.objectstorage.internal.http.CopyObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.CreateBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.CreateMultipartUploadConverter;
import com.oracle.bmc.objectstorage.internal.http.CreatePreauthenticatedRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.CreateReplicationPolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.CreateRetentionRuleConverter;
import com.oracle.bmc.objectstorage.internal.http.DeleteBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.DeleteObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.DeleteObjectLifecyclePolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.DeletePreauthenticatedRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.DeleteReplicationPolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.DeleteRetentionRuleConverter;
import com.oracle.bmc.objectstorage.internal.http.GetBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.GetNamespaceConverter;
import com.oracle.bmc.objectstorage.internal.http.GetNamespaceMetadataConverter;
import com.oracle.bmc.objectstorage.internal.http.GetObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.GetObjectLifecyclePolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.GetPreauthenticatedRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.GetReplicationPolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.GetRetentionRuleConverter;
import com.oracle.bmc.objectstorage.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.HeadBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.HeadObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.ListBucketsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListMultipartUploadPartsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListMultipartUploadsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListObjectVersionsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListObjectsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListPreauthenticatedRequestsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListReplicationPoliciesConverter;
import com.oracle.bmc.objectstorage.internal.http.ListReplicationSourcesConverter;
import com.oracle.bmc.objectstorage.internal.http.ListRetentionRulesConverter;
import com.oracle.bmc.objectstorage.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.objectstorage.internal.http.MakeBucketWritableConverter;
import com.oracle.bmc.objectstorage.internal.http.PutObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.PutObjectLifecyclePolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.ReencryptBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.ReencryptObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.RenameObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.RestoreObjectsConverter;
import com.oracle.bmc.objectstorage.internal.http.UpdateBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.UpdateNamespaceMetadataConverter;
import com.oracle.bmc.objectstorage.internal.http.UpdateObjectStorageTierConverter;
import com.oracle.bmc.objectstorage.internal.http.UpdateRetentionRuleConverter;
import com.oracle.bmc.objectstorage.internal.http.UploadPartConverter;
import com.oracle.bmc.objectstorage.requests.AbortMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CancelWorkRequestRequest;
import com.oracle.bmc.objectstorage.requests.CommitMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CopyObjectRequest;
import com.oracle.bmc.objectstorage.requests.CreateBucketRequest;
import com.oracle.bmc.objectstorage.requests.CreateMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CreatePreauthenticatedRequestRequest;
import com.oracle.bmc.objectstorage.requests.CreateReplicationPolicyRequest;
import com.oracle.bmc.objectstorage.requests.CreateRetentionRuleRequest;
import com.oracle.bmc.objectstorage.requests.DeleteBucketRequest;
import com.oracle.bmc.objectstorage.requests.DeleteObjectLifecyclePolicyRequest;
import com.oracle.bmc.objectstorage.requests.DeleteObjectRequest;
import com.oracle.bmc.objectstorage.requests.DeletePreauthenticatedRequestRequest;
import com.oracle.bmc.objectstorage.requests.DeleteReplicationPolicyRequest;
import com.oracle.bmc.objectstorage.requests.DeleteRetentionRuleRequest;
import com.oracle.bmc.objectstorage.requests.GetBucketRequest;
import com.oracle.bmc.objectstorage.requests.GetNamespaceMetadataRequest;
import com.oracle.bmc.objectstorage.requests.GetNamespaceRequest;
import com.oracle.bmc.objectstorage.requests.GetObjectLifecyclePolicyRequest;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.requests.GetPreauthenticatedRequestRequest;
import com.oracle.bmc.objectstorage.requests.GetReplicationPolicyRequest;
import com.oracle.bmc.objectstorage.requests.GetRetentionRuleRequest;
import com.oracle.bmc.objectstorage.requests.GetWorkRequestRequest;
import com.oracle.bmc.objectstorage.requests.HeadBucketRequest;
import com.oracle.bmc.objectstorage.requests.HeadObjectRequest;
import com.oracle.bmc.objectstorage.requests.ListBucketsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadPartsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadsRequest;
import com.oracle.bmc.objectstorage.requests.ListObjectVersionsRequest;
import com.oracle.bmc.objectstorage.requests.ListObjectsRequest;
import com.oracle.bmc.objectstorage.requests.ListPreauthenticatedRequestsRequest;
import com.oracle.bmc.objectstorage.requests.ListReplicationPoliciesRequest;
import com.oracle.bmc.objectstorage.requests.ListReplicationSourcesRequest;
import com.oracle.bmc.objectstorage.requests.ListRetentionRulesRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestsRequest;
import com.oracle.bmc.objectstorage.requests.MakeBucketWritableRequest;
import com.oracle.bmc.objectstorage.requests.PutObjectLifecyclePolicyRequest;
import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.requests.ReencryptBucketRequest;
import com.oracle.bmc.objectstorage.requests.ReencryptObjectRequest;
import com.oracle.bmc.objectstorage.requests.RenameObjectRequest;
import com.oracle.bmc.objectstorage.requests.RestoreObjectsRequest;
import com.oracle.bmc.objectstorage.requests.UpdateBucketRequest;
import com.oracle.bmc.objectstorage.requests.UpdateNamespaceMetadataRequest;
import com.oracle.bmc.objectstorage.requests.UpdateObjectStorageTierRequest;
import com.oracle.bmc.objectstorage.requests.UpdateRetentionRuleRequest;
import com.oracle.bmc.objectstorage.requests.UploadPartRequest;
import com.oracle.bmc.objectstorage.responses.AbortMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CancelWorkRequestResponse;
import com.oracle.bmc.objectstorage.responses.CommitMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CopyObjectResponse;
import com.oracle.bmc.objectstorage.responses.CreateBucketResponse;
import com.oracle.bmc.objectstorage.responses.CreateMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CreatePreauthenticatedRequestResponse;
import com.oracle.bmc.objectstorage.responses.CreateReplicationPolicyResponse;
import com.oracle.bmc.objectstorage.responses.CreateRetentionRuleResponse;
import com.oracle.bmc.objectstorage.responses.DeleteBucketResponse;
import com.oracle.bmc.objectstorage.responses.DeleteObjectLifecyclePolicyResponse;
import com.oracle.bmc.objectstorage.responses.DeleteObjectResponse;
import com.oracle.bmc.objectstorage.responses.DeletePreauthenticatedRequestResponse;
import com.oracle.bmc.objectstorage.responses.DeleteReplicationPolicyResponse;
import com.oracle.bmc.objectstorage.responses.DeleteRetentionRuleResponse;
import com.oracle.bmc.objectstorage.responses.GetBucketResponse;
import com.oracle.bmc.objectstorage.responses.GetNamespaceMetadataResponse;
import com.oracle.bmc.objectstorage.responses.GetNamespaceResponse;
import com.oracle.bmc.objectstorage.responses.GetObjectLifecyclePolicyResponse;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import com.oracle.bmc.objectstorage.responses.GetPreauthenticatedRequestResponse;
import com.oracle.bmc.objectstorage.responses.GetReplicationPolicyResponse;
import com.oracle.bmc.objectstorage.responses.GetRetentionRuleResponse;
import com.oracle.bmc.objectstorage.responses.GetWorkRequestResponse;
import com.oracle.bmc.objectstorage.responses.HeadBucketResponse;
import com.oracle.bmc.objectstorage.responses.HeadObjectResponse;
import com.oracle.bmc.objectstorage.responses.ListBucketsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadPartsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadsResponse;
import com.oracle.bmc.objectstorage.responses.ListObjectVersionsResponse;
import com.oracle.bmc.objectstorage.responses.ListObjectsResponse;
import com.oracle.bmc.objectstorage.responses.ListPreauthenticatedRequestsResponse;
import com.oracle.bmc.objectstorage.responses.ListReplicationPoliciesResponse;
import com.oracle.bmc.objectstorage.responses.ListReplicationSourcesResponse;
import com.oracle.bmc.objectstorage.responses.ListRetentionRulesResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestsResponse;
import com.oracle.bmc.objectstorage.responses.MakeBucketWritableResponse;
import com.oracle.bmc.objectstorage.responses.PutObjectLifecyclePolicyResponse;
import com.oracle.bmc.objectstorage.responses.PutObjectResponse;
import com.oracle.bmc.objectstorage.responses.ReencryptBucketResponse;
import com.oracle.bmc.objectstorage.responses.ReencryptObjectResponse;
import com.oracle.bmc.objectstorage.responses.RenameObjectResponse;
import com.oracle.bmc.objectstorage.responses.RestoreObjectsResponse;
import com.oracle.bmc.objectstorage.responses.UpdateBucketResponse;
import com.oracle.bmc.objectstorage.responses.UpdateNamespaceMetadataResponse;
import com.oracle.bmc.objectstorage.responses.UpdateObjectStorageTierResponse;
import com.oracle.bmc.objectstorage.responses.UpdateRetentionRuleResponse;
import com.oracle.bmc.objectstorage.responses.UploadPartResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.responses.internal.StreamClosingAsyncHandler;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStorageAsyncClient
implements ObjectStorageAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectStorageAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OBJECTSTORAGE").serviceEndpointPrefix("objectstorage").serviceEndpointTemplate("https://objectstorage.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;

    public ObjectStorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ObjectStorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ObjectStorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ObjectStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ObjectStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ObjectStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ObjectStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public ObjectStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.defaultConfigurator((ClientConfigurator)new DefaultConfigurator.NonBuffering()).clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        boolean isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)restClientFactory.getClientConfigurator());
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)restClientFactory.getClientConfigurator());
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration, isNonBufferingApacheClient);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AbortMultipartUploadResponse> abortMultipartUpload(AbortMultipartUploadRequest request, AsyncHandler<AbortMultipartUploadRequest, AbortMultipartUploadResponse> handler) {
        LOG.trace("Called async abortMultipartUpload");
        AbortMultipartUploadRequest interceptedRequest = AbortMultipartUploadConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AbortMultipartUploadConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, AbortMultipartUploadResponse> transformer = AbortMultipartUploadConverter.fromResponse();
        AsyncHandler<AbortMultipartUploadRequest, AbortMultipartUploadResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AbortMultipartUploadRequest, AbortMultipartUploadResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        LOG.trace("Called async cancelWorkRequest");
        CancelWorkRequestRequest interceptedRequest = CancelWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CancelWorkRequestResponse> transformer = CancelWorkRequestConverter.fromResponse();
        AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelWorkRequestRequest, CancelWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CommitMultipartUploadResponse> commitMultipartUpload(CommitMultipartUploadRequest request, AsyncHandler<CommitMultipartUploadRequest, CommitMultipartUploadResponse> handler) {
        LOG.trace("Called async commitMultipartUpload");
        CommitMultipartUploadRequest interceptedRequest = CommitMultipartUploadConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CommitMultipartUploadConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CommitMultipartUploadResponse> transformer = CommitMultipartUploadConverter.fromResponse();
        AsyncHandler<CommitMultipartUploadRequest, CommitMultipartUploadResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCommitMultipartUploadDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CommitMultipartUploadRequest, CommitMultipartUploadResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CopyObjectResponse> copyObject(CopyObjectRequest request, AsyncHandler<CopyObjectRequest, CopyObjectResponse> handler) {
        LOG.trace("Called async copyObject");
        CopyObjectRequest interceptedRequest = CopyObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CopyObjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CopyObjectResponse> transformer = CopyObjectConverter.fromResponse();
        AsyncHandler<CopyObjectRequest, CopyObjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCopyObjectDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CopyObjectRequest, CopyObjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateBucketResponse> createBucket(CreateBucketRequest request, AsyncHandler<CreateBucketRequest, CreateBucketResponse> handler) {
        LOG.trace("Called async createBucket");
        CreateBucketRequest interceptedRequest = CreateBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBucketConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateBucketResponse> transformer = CreateBucketConverter.fromResponse();
        AsyncHandler<CreateBucketRequest, CreateBucketResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateBucketDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateBucketRequest, CreateBucketResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateMultipartUploadResponse> createMultipartUpload(CreateMultipartUploadRequest request, AsyncHandler<CreateMultipartUploadRequest, CreateMultipartUploadResponse> handler) {
        LOG.trace("Called async createMultipartUpload");
        CreateMultipartUploadRequest interceptedRequest = CreateMultipartUploadConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateMultipartUploadConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateMultipartUploadResponse> transformer = CreateMultipartUploadConverter.fromResponse();
        AsyncHandler<CreateMultipartUploadRequest, CreateMultipartUploadResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateMultipartUploadDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateMultipartUploadRequest, CreateMultipartUploadResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreatePreauthenticatedRequestResponse> createPreauthenticatedRequest(CreatePreauthenticatedRequestRequest request, AsyncHandler<CreatePreauthenticatedRequestRequest, CreatePreauthenticatedRequestResponse> handler) {
        LOG.trace("Called async createPreauthenticatedRequest");
        CreatePreauthenticatedRequestRequest interceptedRequest = CreatePreauthenticatedRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePreauthenticatedRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreatePreauthenticatedRequestResponse> transformer = CreatePreauthenticatedRequestConverter.fromResponse();
        AsyncHandler<CreatePreauthenticatedRequestRequest, CreatePreauthenticatedRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreatePreauthenticatedRequestDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreatePreauthenticatedRequestRequest, CreatePreauthenticatedRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateReplicationPolicyResponse> createReplicationPolicy(CreateReplicationPolicyRequest request, AsyncHandler<CreateReplicationPolicyRequest, CreateReplicationPolicyResponse> handler) {
        LOG.trace("Called async createReplicationPolicy");
        CreateReplicationPolicyRequest interceptedRequest = CreateReplicationPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateReplicationPolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateReplicationPolicyResponse> transformer = CreateReplicationPolicyConverter.fromResponse();
        AsyncHandler<CreateReplicationPolicyRequest, CreateReplicationPolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateReplicationPolicyDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateReplicationPolicyRequest, CreateReplicationPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateRetentionRuleResponse> createRetentionRule(CreateRetentionRuleRequest request, AsyncHandler<CreateRetentionRuleRequest, CreateRetentionRuleResponse> handler) {
        LOG.trace("Called async createRetentionRule");
        CreateRetentionRuleRequest interceptedRequest = CreateRetentionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRetentionRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateRetentionRuleResponse> transformer = CreateRetentionRuleConverter.fromResponse();
        AsyncHandler<CreateRetentionRuleRequest, CreateRetentionRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateRetentionRuleDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateRetentionRuleRequest, CreateRetentionRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteBucketResponse> deleteBucket(DeleteBucketRequest request, AsyncHandler<DeleteBucketRequest, DeleteBucketResponse> handler) {
        LOG.trace("Called async deleteBucket");
        DeleteBucketRequest interceptedRequest = DeleteBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBucketConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteBucketResponse> transformer = DeleteBucketConverter.fromResponse();
        AsyncHandler<DeleteBucketRequest, DeleteBucketResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteBucketRequest, DeleteBucketResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteObjectResponse> deleteObject(DeleteObjectRequest request, AsyncHandler<DeleteObjectRequest, DeleteObjectResponse> handler) {
        LOG.trace("Called async deleteObject");
        DeleteObjectRequest interceptedRequest = DeleteObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteObjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteObjectResponse> transformer = DeleteObjectConverter.fromResponse();
        AsyncHandler<DeleteObjectRequest, DeleteObjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteObjectRequest, DeleteObjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteObjectLifecyclePolicyResponse> deleteObjectLifecyclePolicy(DeleteObjectLifecyclePolicyRequest request, AsyncHandler<DeleteObjectLifecyclePolicyRequest, DeleteObjectLifecyclePolicyResponse> handler) {
        LOG.trace("Called async deleteObjectLifecyclePolicy");
        DeleteObjectLifecyclePolicyRequest interceptedRequest = DeleteObjectLifecyclePolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteObjectLifecyclePolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteObjectLifecyclePolicyResponse> transformer = DeleteObjectLifecyclePolicyConverter.fromResponse();
        AsyncHandler<DeleteObjectLifecyclePolicyRequest, DeleteObjectLifecyclePolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteObjectLifecyclePolicyRequest, DeleteObjectLifecyclePolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeletePreauthenticatedRequestResponse> deletePreauthenticatedRequest(DeletePreauthenticatedRequestRequest request, AsyncHandler<DeletePreauthenticatedRequestRequest, DeletePreauthenticatedRequestResponse> handler) {
        LOG.trace("Called async deletePreauthenticatedRequest");
        DeletePreauthenticatedRequestRequest interceptedRequest = DeletePreauthenticatedRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePreauthenticatedRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeletePreauthenticatedRequestResponse> transformer = DeletePreauthenticatedRequestConverter.fromResponse();
        AsyncHandler<DeletePreauthenticatedRequestRequest, DeletePreauthenticatedRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeletePreauthenticatedRequestRequest, DeletePreauthenticatedRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteReplicationPolicyResponse> deleteReplicationPolicy(DeleteReplicationPolicyRequest request, AsyncHandler<DeleteReplicationPolicyRequest, DeleteReplicationPolicyResponse> handler) {
        LOG.trace("Called async deleteReplicationPolicy");
        DeleteReplicationPolicyRequest interceptedRequest = DeleteReplicationPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteReplicationPolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteReplicationPolicyResponse> transformer = DeleteReplicationPolicyConverter.fromResponse();
        AsyncHandler<DeleteReplicationPolicyRequest, DeleteReplicationPolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteReplicationPolicyRequest, DeleteReplicationPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteRetentionRuleResponse> deleteRetentionRule(DeleteRetentionRuleRequest request, AsyncHandler<DeleteRetentionRuleRequest, DeleteRetentionRuleResponse> handler) {
        LOG.trace("Called async deleteRetentionRule");
        DeleteRetentionRuleRequest interceptedRequest = DeleteRetentionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRetentionRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteRetentionRuleResponse> transformer = DeleteRetentionRuleConverter.fromResponse();
        AsyncHandler<DeleteRetentionRuleRequest, DeleteRetentionRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteRetentionRuleRequest, DeleteRetentionRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetBucketResponse> getBucket(GetBucketRequest request, AsyncHandler<GetBucketRequest, GetBucketResponse> handler) {
        LOG.trace("Called async getBucket");
        GetBucketRequest interceptedRequest = GetBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBucketConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetBucketResponse> transformer = GetBucketConverter.fromResponse();
        AsyncHandler<GetBucketRequest, GetBucketResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetBucketRequest, GetBucketResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetNamespaceResponse> getNamespace(GetNamespaceRequest request, AsyncHandler<GetNamespaceRequest, GetNamespaceResponse> handler) {
        LOG.trace("Called async getNamespace");
        GetNamespaceRequest interceptedRequest = GetNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNamespaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetNamespaceResponse> transformer = GetNamespaceConverter.fromResponse();
        AsyncHandler<GetNamespaceRequest, GetNamespaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetNamespaceRequest, GetNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetNamespaceMetadataResponse> getNamespaceMetadata(GetNamespaceMetadataRequest request, AsyncHandler<GetNamespaceMetadataRequest, GetNamespaceMetadataResponse> handler) {
        LOG.trace("Called async getNamespaceMetadata");
        GetNamespaceMetadataRequest interceptedRequest = GetNamespaceMetadataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNamespaceMetadataConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetNamespaceMetadataResponse> transformer = GetNamespaceMetadataConverter.fromResponse();
        AsyncHandler<GetNamespaceMetadataRequest, GetNamespaceMetadataResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetNamespaceMetadataRequest, GetNamespaceMetadataResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetObjectResponse> getObject(GetObjectRequest request, AsyncHandler<GetObjectRequest, GetObjectResponse> handler) {
        LOG.trace("Called async getObject");
        if (ApacheUtils.isExtraStreamLogsEnabled()) {
            LOG.warn("getObject returns a stream, please make sure to close the stream to avoid any indefinite hangs");
            if (this.apacheConnectionClosingStrategy != null) {
                LOG.warn("ApacheConnectionClosingStrategy set to {}. For large streams with partial reads of stream, please use ImmediateClosingStrategy. For small streams with partial reads of stream, please use GracefulClosingStrategy. More info in ApacheConnectorProperties", (Object)this.apacheConnectionClosingStrategy);
            }
        }
        GetObjectRequest interceptedRequest = GetObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetObjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetObjectResponse> transformer = GetObjectConverter.fromResponse();
        AsyncHandler<GetObjectRequest, GetObjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetObjectRequest, GetObjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetObjectLifecyclePolicyResponse> getObjectLifecyclePolicy(GetObjectLifecyclePolicyRequest request, AsyncHandler<GetObjectLifecyclePolicyRequest, GetObjectLifecyclePolicyResponse> handler) {
        LOG.trace("Called async getObjectLifecyclePolicy");
        GetObjectLifecyclePolicyRequest interceptedRequest = GetObjectLifecyclePolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetObjectLifecyclePolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetObjectLifecyclePolicyResponse> transformer = GetObjectLifecyclePolicyConverter.fromResponse();
        AsyncHandler<GetObjectLifecyclePolicyRequest, GetObjectLifecyclePolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetObjectLifecyclePolicyRequest, GetObjectLifecyclePolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetPreauthenticatedRequestResponse> getPreauthenticatedRequest(GetPreauthenticatedRequestRequest request, AsyncHandler<GetPreauthenticatedRequestRequest, GetPreauthenticatedRequestResponse> handler) {
        LOG.trace("Called async getPreauthenticatedRequest");
        GetPreauthenticatedRequestRequest interceptedRequest = GetPreauthenticatedRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPreauthenticatedRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetPreauthenticatedRequestResponse> transformer = GetPreauthenticatedRequestConverter.fromResponse();
        AsyncHandler<GetPreauthenticatedRequestRequest, GetPreauthenticatedRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetPreauthenticatedRequestRequest, GetPreauthenticatedRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetReplicationPolicyResponse> getReplicationPolicy(GetReplicationPolicyRequest request, AsyncHandler<GetReplicationPolicyRequest, GetReplicationPolicyResponse> handler) {
        LOG.trace("Called async getReplicationPolicy");
        GetReplicationPolicyRequest interceptedRequest = GetReplicationPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetReplicationPolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetReplicationPolicyResponse> transformer = GetReplicationPolicyConverter.fromResponse();
        AsyncHandler<GetReplicationPolicyRequest, GetReplicationPolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetReplicationPolicyRequest, GetReplicationPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRetentionRuleResponse> getRetentionRule(GetRetentionRuleRequest request, AsyncHandler<GetRetentionRuleRequest, GetRetentionRuleResponse> handler) {
        LOG.trace("Called async getRetentionRule");
        GetRetentionRuleRequest interceptedRequest = GetRetentionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRetentionRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetRetentionRuleResponse> transformer = GetRetentionRuleConverter.fromResponse();
        AsyncHandler<GetRetentionRuleRequest, GetRetentionRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRetentionRuleRequest, GetRetentionRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<HeadBucketResponse> headBucket(HeadBucketRequest request, AsyncHandler<HeadBucketRequest, HeadBucketResponse> handler) {
        LOG.trace("Called async headBucket");
        HeadBucketRequest interceptedRequest = HeadBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = HeadBucketConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, HeadBucketResponse> transformer = HeadBucketConverter.fromResponse();
        AsyncHandler<HeadBucketRequest, HeadBucketResponse> handlerToUse = handler;
        Function futureSupplier = this.client.headFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<HeadBucketRequest, HeadBucketResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<HeadObjectResponse> headObject(HeadObjectRequest request, AsyncHandler<HeadObjectRequest, HeadObjectResponse> handler) {
        LOG.trace("Called async headObject");
        HeadObjectRequest interceptedRequest = HeadObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = HeadObjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, HeadObjectResponse> transformer = HeadObjectConverter.fromResponse();
        AsyncHandler<HeadObjectRequest, HeadObjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.headFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<HeadObjectRequest, HeadObjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListBucketsResponse> listBuckets(ListBucketsRequest request, AsyncHandler<ListBucketsRequest, ListBucketsResponse> handler) {
        LOG.trace("Called async listBuckets");
        ListBucketsRequest interceptedRequest = ListBucketsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBucketsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListBucketsResponse> transformer = ListBucketsConverter.fromResponse();
        AsyncHandler<ListBucketsRequest, ListBucketsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListBucketsRequest, ListBucketsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListMultipartUploadPartsResponse> listMultipartUploadParts(ListMultipartUploadPartsRequest request, AsyncHandler<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse> handler) {
        LOG.trace("Called async listMultipartUploadParts");
        ListMultipartUploadPartsRequest interceptedRequest = ListMultipartUploadPartsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMultipartUploadPartsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListMultipartUploadPartsResponse> transformer = ListMultipartUploadPartsConverter.fromResponse();
        AsyncHandler<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListMultipartUploadsResponse> listMultipartUploads(ListMultipartUploadsRequest request, AsyncHandler<ListMultipartUploadsRequest, ListMultipartUploadsResponse> handler) {
        LOG.trace("Called async listMultipartUploads");
        ListMultipartUploadsRequest interceptedRequest = ListMultipartUploadsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMultipartUploadsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListMultipartUploadsResponse> transformer = ListMultipartUploadsConverter.fromResponse();
        AsyncHandler<ListMultipartUploadsRequest, ListMultipartUploadsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListMultipartUploadsRequest, ListMultipartUploadsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListObjectVersionsResponse> listObjectVersions(ListObjectVersionsRequest request, AsyncHandler<ListObjectVersionsRequest, ListObjectVersionsResponse> handler) {
        LOG.trace("Called async listObjectVersions");
        ListObjectVersionsRequest interceptedRequest = ListObjectVersionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListObjectVersionsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListObjectVersionsResponse> transformer = ListObjectVersionsConverter.fromResponse();
        AsyncHandler<ListObjectVersionsRequest, ListObjectVersionsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListObjectVersionsRequest, ListObjectVersionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListObjectsResponse> listObjects(ListObjectsRequest request, AsyncHandler<ListObjectsRequest, ListObjectsResponse> handler) {
        LOG.trace("Called async listObjects");
        ListObjectsRequest interceptedRequest = ListObjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListObjectsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListObjectsResponse> transformer = ListObjectsConverter.fromResponse();
        AsyncHandler<ListObjectsRequest, ListObjectsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListObjectsRequest, ListObjectsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPreauthenticatedRequestsResponse> listPreauthenticatedRequests(ListPreauthenticatedRequestsRequest request, AsyncHandler<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse> handler) {
        LOG.trace("Called async listPreauthenticatedRequests");
        ListPreauthenticatedRequestsRequest interceptedRequest = ListPreauthenticatedRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPreauthenticatedRequestsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListPreauthenticatedRequestsResponse> transformer = ListPreauthenticatedRequestsConverter.fromResponse();
        AsyncHandler<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListReplicationPoliciesResponse> listReplicationPolicies(ListReplicationPoliciesRequest request, AsyncHandler<ListReplicationPoliciesRequest, ListReplicationPoliciesResponse> handler) {
        LOG.trace("Called async listReplicationPolicies");
        ListReplicationPoliciesRequest interceptedRequest = ListReplicationPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListReplicationPoliciesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListReplicationPoliciesResponse> transformer = ListReplicationPoliciesConverter.fromResponse();
        AsyncHandler<ListReplicationPoliciesRequest, ListReplicationPoliciesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListReplicationPoliciesRequest, ListReplicationPoliciesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListReplicationSourcesResponse> listReplicationSources(ListReplicationSourcesRequest request, AsyncHandler<ListReplicationSourcesRequest, ListReplicationSourcesResponse> handler) {
        LOG.trace("Called async listReplicationSources");
        ListReplicationSourcesRequest interceptedRequest = ListReplicationSourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListReplicationSourcesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListReplicationSourcesResponse> transformer = ListReplicationSourcesConverter.fromResponse();
        AsyncHandler<ListReplicationSourcesRequest, ListReplicationSourcesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListReplicationSourcesRequest, ListReplicationSourcesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRetentionRulesResponse> listRetentionRules(ListRetentionRulesRequest request, AsyncHandler<ListRetentionRulesRequest, ListRetentionRulesResponse> handler) {
        LOG.trace("Called async listRetentionRules");
        ListRetentionRulesRequest interceptedRequest = ListRetentionRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRetentionRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListRetentionRulesResponse> transformer = ListRetentionRulesConverter.fromResponse();
        AsyncHandler<ListRetentionRulesRequest, ListRetentionRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRetentionRulesRequest, ListRetentionRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<MakeBucketWritableResponse> makeBucketWritable(MakeBucketWritableRequest request, AsyncHandler<MakeBucketWritableRequest, MakeBucketWritableResponse> handler) {
        LOG.trace("Called async makeBucketWritable");
        MakeBucketWritableRequest interceptedRequest = MakeBucketWritableConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = MakeBucketWritableConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, MakeBucketWritableResponse> transformer = MakeBucketWritableConverter.fromResponse();
        AsyncHandler<MakeBucketWritableRequest, MakeBucketWritableResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<MakeBucketWritableRequest, MakeBucketWritableResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<PutObjectResponse> putObject(PutObjectRequest request, AsyncHandler<PutObjectRequest, PutObjectResponse> handler) {
        LOG.trace("Called async putObject");
        if (request.getRetryConfiguration() != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            request = (PutObjectRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)PutObjectRequest.builder());
        }
        final PutObjectRequest interceptedRequest = PutObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PutObjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, PutObjectResponse> transformer = PutObjectConverter.fromResponse();
        ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
        StreamClosingAsyncHandler handlerToUse = new StreamClosingAsyncHandler(handler);
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getPutObjectBody(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<PutObjectRequest, PutObjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (AsyncHandler)handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                    LOG.debug("Resetting stream");
                    Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getPutObjectBody(), (boolean)true);
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<PutObjectLifecyclePolicyResponse> putObjectLifecyclePolicy(PutObjectLifecyclePolicyRequest request, AsyncHandler<PutObjectLifecyclePolicyRequest, PutObjectLifecyclePolicyResponse> handler) {
        LOG.trace("Called async putObjectLifecyclePolicy");
        PutObjectLifecyclePolicyRequest interceptedRequest = PutObjectLifecyclePolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PutObjectLifecyclePolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, PutObjectLifecyclePolicyResponse> transformer = PutObjectLifecyclePolicyConverter.fromResponse();
        AsyncHandler<PutObjectLifecyclePolicyRequest, PutObjectLifecyclePolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getPutObjectLifecyclePolicyDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<PutObjectLifecyclePolicyRequest, PutObjectLifecyclePolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ReencryptBucketResponse> reencryptBucket(ReencryptBucketRequest request, AsyncHandler<ReencryptBucketRequest, ReencryptBucketResponse> handler) {
        LOG.trace("Called async reencryptBucket");
        ReencryptBucketRequest interceptedRequest = ReencryptBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ReencryptBucketConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ReencryptBucketResponse> transformer = ReencryptBucketConverter.fromResponse();
        AsyncHandler<ReencryptBucketRequest, ReencryptBucketResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ReencryptBucketRequest, ReencryptBucketResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ReencryptObjectResponse> reencryptObject(ReencryptObjectRequest request, AsyncHandler<ReencryptObjectRequest, ReencryptObjectResponse> handler) {
        LOG.trace("Called async reencryptObject");
        ReencryptObjectRequest interceptedRequest = ReencryptObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ReencryptObjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ReencryptObjectResponse> transformer = ReencryptObjectConverter.fromResponse();
        AsyncHandler<ReencryptObjectRequest, ReencryptObjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getReencryptObjectDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ReencryptObjectRequest, ReencryptObjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RenameObjectResponse> renameObject(RenameObjectRequest request, AsyncHandler<RenameObjectRequest, RenameObjectResponse> handler) {
        LOG.trace("Called async renameObject");
        RenameObjectRequest interceptedRequest = RenameObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RenameObjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RenameObjectResponse> transformer = RenameObjectConverter.fromResponse();
        AsyncHandler<RenameObjectRequest, RenameObjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getRenameObjectDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RenameObjectRequest, RenameObjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RestoreObjectsResponse> restoreObjects(RestoreObjectsRequest request, AsyncHandler<RestoreObjectsRequest, RestoreObjectsResponse> handler) {
        LOG.trace("Called async restoreObjects");
        RestoreObjectsRequest interceptedRequest = RestoreObjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreObjectsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RestoreObjectsResponse> transformer = RestoreObjectsConverter.fromResponse();
        AsyncHandler<RestoreObjectsRequest, RestoreObjectsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getRestoreObjectsDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RestoreObjectsRequest, RestoreObjectsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateBucketResponse> updateBucket(UpdateBucketRequest request, AsyncHandler<UpdateBucketRequest, UpdateBucketResponse> handler) {
        LOG.trace("Called async updateBucket");
        UpdateBucketRequest interceptedRequest = UpdateBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBucketConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateBucketResponse> transformer = UpdateBucketConverter.fromResponse();
        AsyncHandler<UpdateBucketRequest, UpdateBucketResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateBucketDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateBucketRequest, UpdateBucketResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateNamespaceMetadataResponse> updateNamespaceMetadata(UpdateNamespaceMetadataRequest request, AsyncHandler<UpdateNamespaceMetadataRequest, UpdateNamespaceMetadataResponse> handler) {
        LOG.trace("Called async updateNamespaceMetadata");
        UpdateNamespaceMetadataRequest interceptedRequest = UpdateNamespaceMetadataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNamespaceMetadataConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateNamespaceMetadataResponse> transformer = UpdateNamespaceMetadataConverter.fromResponse();
        AsyncHandler<UpdateNamespaceMetadataRequest, UpdateNamespaceMetadataResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateNamespaceMetadataDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateNamespaceMetadataRequest, UpdateNamespaceMetadataResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateObjectStorageTierResponse> updateObjectStorageTier(UpdateObjectStorageTierRequest request, AsyncHandler<UpdateObjectStorageTierRequest, UpdateObjectStorageTierResponse> handler) {
        LOG.trace("Called async updateObjectStorageTier");
        UpdateObjectStorageTierRequest interceptedRequest = UpdateObjectStorageTierConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateObjectStorageTierConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateObjectStorageTierResponse> transformer = UpdateObjectStorageTierConverter.fromResponse();
        AsyncHandler<UpdateObjectStorageTierRequest, UpdateObjectStorageTierResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateObjectStorageTierDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateObjectStorageTierRequest, UpdateObjectStorageTierResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateRetentionRuleResponse> updateRetentionRule(UpdateRetentionRuleRequest request, AsyncHandler<UpdateRetentionRuleRequest, UpdateRetentionRuleResponse> handler) {
        LOG.trace("Called async updateRetentionRule");
        UpdateRetentionRuleRequest interceptedRequest = UpdateRetentionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRetentionRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateRetentionRuleResponse> transformer = UpdateRetentionRuleConverter.fromResponse();
        AsyncHandler<UpdateRetentionRuleRequest, UpdateRetentionRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateRetentionRuleDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateRetentionRuleRequest, UpdateRetentionRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UploadPartResponse> uploadPart(UploadPartRequest request, AsyncHandler<UploadPartRequest, UploadPartResponse> handler) {
        LOG.trace("Called async uploadPart");
        if (request.getRetryConfiguration() != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            request = (UploadPartRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)UploadPartRequest.builder());
        }
        final UploadPartRequest interceptedRequest = UploadPartConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UploadPartConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UploadPartResponse> transformer = UploadPartConverter.fromResponse();
        ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
        StreamClosingAsyncHandler handlerToUse = new StreamClosingAsyncHandler(handler);
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUploadPartBody(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UploadPartRequest, UploadPartResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (AsyncHandler)handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                    LOG.debug("Resetting stream");
                    Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getUploadPartBody(), (boolean)true);
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ObjectStorageAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ObjectStorageAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ObjectStorageAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

