/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchJson;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchTransport;

class Scrolling {
    private final ElasticsearchTransport transport;
    private final int fetchSize;

    Scrolling(ElasticsearchTransport transport) {
        this.transport = Objects.requireNonNull(transport, "transport");
        int fetchSize = transport.fetchSize;
        Preconditions.checkArgument((fetchSize > 0 ? 1 : 0) != 0, (String)"invalid fetch size. Expected %s > 0", (int)fetchSize);
        this.fetchSize = fetchSize;
    }

    Iterator<ElasticsearchJson.SearchHit> query(ObjectNode query) {
        long limit;
        Objects.requireNonNull(query, "query");
        if (query.has("size")) {
            limit = query.get("size").asLong();
            if ((long)this.fetchSize > limit) {
                return this.transport.search().apply(query).searchHits().hits().iterator();
            }
        } else {
            limit = Long.MAX_VALUE;
        }
        query.put("size", this.fetchSize);
        ElasticsearchJson.Result first = this.transport.search(Collections.singletonMap("scroll", "1m")).apply(query);
        AutoClosingIterator iterator = new AutoClosingIterator((Iterator)((Object)new SequentialIterator(first, this.transport, limit)), scrollId -> this.transport.closeScroll(Collections.singleton(scrollId)));
        Iterator result = Scrolling.flatten(iterator);
        if (limit != Long.MAX_VALUE) {
            result = Iterators.limit(result, (int)((int)limit));
        }
        return result;
    }

    private static Iterator<ElasticsearchJson.SearchHit> flatten(Iterator<ElasticsearchJson.Result> results) {
        Iterator inputs = Iterators.transform(results, input -> input.searchHits().hits().iterator());
        return Iterators.concat((Iterator)inputs);
    }

    private static class SequentialIterator
    extends AbstractSequentialIterator<ElasticsearchJson.Result> {
        private final ElasticsearchTransport transport;
        private final long limit;
        private long count;

        private SequentialIterator(ElasticsearchJson.Result first, ElasticsearchTransport transport, long limit) {
            super((Object)first);
            this.transport = transport;
            Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (String)"limit: %s >= 0", (long)limit);
            this.limit = limit;
        }

        protected ElasticsearchJson.Result computeNext(ElasticsearchJson.Result previous) {
            int hits = previous.searchHits().hits().size();
            if (hits == 0 || this.count >= this.limit) {
                return null;
            }
            this.count += (long)hits;
            String scrollId = previous.scrollId().orElseThrow(() -> new IllegalStateException("scrollId has to be present"));
            return this.transport.scroll().apply(scrollId);
        }
    }

    private static class AutoClosingIterator
    implements Iterator<ElasticsearchJson.Result>,
    AutoCloseable {
        private final Iterator<ElasticsearchJson.Result> delegate;
        private final Consumer<String> closer;
        private boolean closed;
        private String scrollId;

        private AutoClosingIterator(Iterator<ElasticsearchJson.Result> delegate, Consumer<String> closer) {
            this.delegate = delegate;
            this.closer = closer;
        }

        @Override
        public void close() {
            if (!this.closed && this.scrollId != null) {
                this.closer.accept(this.scrollId);
            }
            this.closed = true;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.delegate.hasNext();
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }

        @Override
        public ElasticsearchJson.Result next() {
            ElasticsearchJson.Result next = this.delegate.next();
            next.scrollId().ifPresent(id -> {
                this.scrollId = id;
            });
            return next;
        }
    }
}

