/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchJson;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.Primitive;

class ElasticsearchEnumerators {
    private ElasticsearchEnumerators() {
    }

    private static Function1<ElasticsearchJson.SearchHit, Map> mapGetter() {
        return ElasticsearchJson.SearchHit::sourceOrFields;
    }

    private static Function1<ElasticsearchJson.SearchHit, Object> singletonGetter(String fieldName, Class fieldClass, Map<String, String> mapping) {
        return hit -> {
            String key = hit.sourceOrFields().containsKey(fieldName) ? fieldName : mapping.getOrDefault(fieldName, fieldName);
            Object value = "_id".equals(key) || "_id".equals(mapping.getOrDefault(fieldName, fieldName)) ? hit.id() : hit.valueOrNull(key);
            return ElasticsearchEnumerators.convert(value, fieldClass);
        };
    }

    private static Function1<ElasticsearchJson.SearchHit, Object[]> listGetter(List<Map.Entry<String, Class>> fields, Map<String, String> mapping) {
        return hit -> {
            Object[] objects = new Object[fields.size()];
            for (int i = 0; i < fields.size(); ++i) {
                Map.Entry field = (Map.Entry)fields.get(i);
                String key = hit.sourceOrFields().containsKey(field.getKey()) ? (String)field.getKey() : (String)mapping.getOrDefault(field.getKey(), (String)field.getKey());
                Object value = "_id".equals(key) || "_id".equals(mapping.get(field.getKey())) || "_id".equals(field.getKey()) ? hit.id() : hit.valueOrNull(key);
                Class type = (Class)field.getValue();
                objects[i] = ElasticsearchEnumerators.convert(value, type);
            }
            return objects;
        };
    }

    static Function1<ElasticsearchJson.SearchHit, Object> getter(List<Map.Entry<String, Class>> fields, Map<String, String> mapping) {
        Objects.requireNonNull(fields, "fields");
        Object getter = fields.size() == 1 ? ElasticsearchEnumerators.singletonGetter(fields.get(0).getKey(), fields.get(0).getValue(), mapping) : ElasticsearchEnumerators.listGetter(fields, mapping);
        return getter;
    }

    private static Object convert(Object o, Class clazz) {
        if (o == null) {
            return null;
        }
        Primitive primitive = Primitive.of((Type)clazz);
        if (primitive != null) {
            clazz = primitive.boxClass;
        } else {
            primitive = Primitive.ofBox((Type)clazz);
        }
        if (clazz.isInstance(o)) {
            return o;
        }
        if (o instanceof Date && primitive != null) {
            o = ((Date)o).getTime() / 86400000L;
        }
        if (o instanceof Number && primitive != null) {
            return primitive.number((Number)o);
        }
        return o;
    }
}

