/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.ClusterNameMismatchException;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.GuavaCompatibility;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.ShardingInfo;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.BusyPoolException;
import com.datastax.driver.core.exceptions.ConnectionException;
import com.datastax.driver.core.exceptions.UnsupportedProtocolVersionException;
import com.datastax.driver.core.utils.MoreFutures;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import io.netty.util.concurrent.EventExecutor;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HostConnectionPool
implements Connection.Owner {
    private static final Logger logger = LoggerFactory.getLogger(HostConnectionPool.class);
    private static final int MAX_SIMULTANEOUS_CREATION = 1;
    private static final Random RAND = new Random();
    final Host host;
    volatile HostDistance hostDistance;
    protected final SessionManager manager;
    private int connectionsPerShard;
    private int maxConnectionsPerShard;
    List<Connection>[] connections;
    private AtomicInteger[] open;
    final AtomicInteger totalInFlight = new AtomicInteger();
    private final AtomicInteger maxTotalInFlight = new AtomicInteger();
    @VisibleForTesting
    Set<Connection>[] trash;
    private Queue<PendingBorrow>[] pendingBorrows;
    final AtomicInteger pendingBorrowCount = new AtomicInteger();
    private AtomicInteger[] scheduledForCreation;
    private final EventExecutor timeoutsExecutor;
    private final AtomicReference<CloseFuture> closeFuture = new AtomicReference();
    private long advShardAwarenessBlockedUntil = 0L;
    protected final AtomicReference<Phase> phase = new AtomicReference<Phase>(Phase.INITIALIZING);
    private final ConnectionTasksSharedState connectionTasksSharedState = new ConnectionTasksSharedState();
    private final int minAllowedStreams;

    private boolean canUseAdvancedShardAwareness(boolean logResult) {
        boolean isSSLUsed;
        ShardingInfo shardingInfo = this.host.getShardingInfo();
        if (shardingInfo == null) {
            if (logResult) {
                logger.warn("Not using advanced port-based shard awareness with {} because sharding info is missing", (Object)this.host);
            }
            return false;
        }
        if (!this.manager.configuration().getProtocolOptions().isUseAdvancedShardAwareness()) {
            if (logResult) {
                logger.warn("Not using advanced port-based shard awareness with {} because it's disabled in configuration", (Object)this.host);
            }
            return false;
        }
        boolean bl = isSSLUsed = null != this.manager.configuration().getProtocolOptions().getSSLOptions();
        if (shardingInfo.getShardAwarePort(isSSLUsed) == 0) {
            if (logResult) {
                logger.warn("Not using advanced port-based shard awareness with {} because we're missing port-based shard awareness port on the server", (Object)this.host);
            }
            return false;
        }
        if (System.currentTimeMillis() < this.advShardAwarenessBlockedUntil) {
            if (logResult) {
                logger.warn("Not using advanced port-based shard awareness with {} because of a previous error", (Object)this.host);
            }
            return false;
        }
        if (logResult) {
            logger.info("Using advanced port-based shard awareness with {}", (Object)this.host);
        }
        return true;
    }

    public void tempBlockAdvShardAwareness(long millis) {
        this.advShardAwarenessBlockedUntil = Math.max(System.currentTimeMillis() + millis, this.advShardAwarenessBlockedUntil);
    }

    private void scheduleConnectionTask(final ConnectionTask task) {
        this.timeoutsExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                HostConnectionPool.this.manager.blockingExecutor().submit((Runnable)task);
            }
        }, 100L, TimeUnit.MILLISECONDS);
    }

    HostConnectionPool(Host host, HostDistance hostDistance, SessionManager manager) {
        assert (hostDistance != HostDistance.IGNORED);
        this.host = host;
        this.hostDistance = hostDistance;
        this.manager = manager;
        this.minAllowedStreams = this.options().getMaxRequestsPerConnection(hostDistance) * 3 / 4;
        this.timeoutsExecutor = manager.getCluster().manager.connectionFactory.eventLoopGroup.next();
    }

    ListenableFuture<Void> initAsync(Connection reusedConnection) {
        if (reusedConnection != null && reusedConnection.setOwner(this)) {
            return this.initAsyncWithConnection(reusedConnection);
        }
        try {
            return this.initAsyncWithConnection(this.manager.connectionFactory().open(this));
        }
        catch (Exception e) {
            this.phase.compareAndSet(Phase.INITIALIZING, Phase.INIT_FAILED);
            SettableFuture future = SettableFuture.create();
            future.setException((Throwable)e);
            return future;
        }
    }

    ListenableFuture<Void> initAsyncWithConnection(Connection reusedConnection) {
        Executor initExecutor = this.manager.cluster.manager.configuration.getPoolingOptions().getInitializationExecutor();
        int coreSize = this.options().getCoreConnectionsPerHost(this.hostDistance);
        int maxConnections = this.options().getMaxConnectionsPerHost(this.hostDistance);
        int shardsCount = this.host.getShardingInfo() == null ? 1 : this.host.getShardingInfo().getShardsCount();
        this.connectionsPerShard = coreSize / shardsCount + (coreSize % shardsCount > 0 ? 1 : 0);
        this.maxConnectionsPerShard = maxConnections / shardsCount + (maxConnections % shardsCount > 0 ? 1 : 0);
        int toCreate = shardsCount * this.connectionsPerShard;
        this.connections = new List[shardsCount];
        this.scheduledForCreation = new AtomicInteger[shardsCount];
        this.open = new AtomicInteger[shardsCount];
        this.trash = new Set[shardsCount];
        this.pendingBorrows = new Queue[shardsCount];
        for (int i = 0; i < shardsCount; ++i) {
            this.connections[i] = new CopyOnWriteArrayList<Connection>();
            this.scheduledForCreation[i] = new AtomicInteger();
            this.open[i] = new AtomicInteger();
            this.trash[i] = new CopyOnWriteArraySet<Connection>();
            this.pendingBorrows[i] = new ConcurrentLinkedQueue<PendingBorrow>();
        }
        ArrayList connections = Lists.newArrayListWithCapacity((int)toCreate);
        ArrayList connectionFutures = Lists.newArrayListWithCapacity((int)(2 * toCreate));
        connections.add(reusedConnection);
        connectionFutures.add(MoreFutures.VOID_SUCCESS);
        List<Connection> newConnections = this.manager.connectionFactory().newConnections(this, --toCreate);
        connections.addAll(newConnections);
        if (this.canUseAdvancedShardAwareness(true)) {
            ShardingInfo shardingInfo = this.host.getShardingInfo();
            boolean isSSLUsed = null != this.manager.configuration().getProtocolOptions().getSSLOptions();
            int serverPort = shardingInfo.getShardAwarePort(isSSLUsed);
            int shardId = 0;
            int shardConnectionIndex = 0;
            for (Connection connection : newConnections) {
                if (shardConnectionIndex == this.connectionsPerShard) {
                    shardConnectionIndex = 0;
                    ++shardId;
                }
                if (shardId == reusedConnection.shardId() && shardConnectionIndex == 0 && ++shardConnectionIndex == this.connectionsPerShard) {
                    shardConnectionIndex = 0;
                    ++shardId;
                }
                ListenableFuture<Void> connectionFuture = connection.initAsync(shardId, serverPort);
                connectionFutures.add(this.handleErrors(connectionFuture, initExecutor));
                ++shardConnectionIndex;
            }
        } else {
            for (Connection connection : newConnections) {
                ListenableFuture<Void> connectionFuture = connection.initAsync();
                connectionFutures.add(this.handleErrors(connectionFuture, initExecutor));
            }
        }
        SettableFuture initFuture = SettableFuture.create();
        this.addCallback(connections, connectionFutures, (SettableFuture<Void>)initFuture);
        return initFuture;
    }

    private void addCallback(final List<Connection> connections, List<ListenableFuture<Void>> connectionFutures, final SettableFuture<Void> initFuture) {
        Executor initExecutor = this.manager.cluster.manager.configuration.getPoolingOptions().getInitializationExecutor();
        ListenableFuture allConnectionsFuture = Futures.allAsList(connectionFutures);
        GuavaCompatibility.INSTANCE.addCallback(allConnectionsFuture, new FutureCallback<List<Void>>(){

            public void onSuccess(List<Void> l) {
                for (Connection c : connections) {
                    if (c.isClosed()) continue;
                    if (HostConnectionPool.this.connections[c.shardId()].size() < HostConnectionPool.this.connectionsPerShard) {
                        HostConnectionPool.this.connections[c.shardId()].add(c);
                        HostConnectionPool.this.open[c.shardId()].addAndGet(1);
                        continue;
                    }
                    c.closeAsync();
                }
                if (HostConnectionPool.this.isClosed()) {
                    initFuture.setException((Throwable)new ConnectionException(HostConnectionPool.this.host.getEndPoint(), "Pool was closed during initialization"));
                    HostConnectionPool.this.forceClose(connections);
                    for (List<Connection> shardConnections : HostConnectionPool.this.connections) {
                        HostConnectionPool.this.forceClose(shardConnections);
                    }
                    for (AtomicInteger o : HostConnectionPool.this.open) {
                        o.set(0);
                    }
                } else {
                    int shardId = 0;
                    int[] needed = new int[HostConnectionPool.this.connections.length];
                    for (List<Connection> shardsConnections : HostConnectionPool.this.connections) {
                        needed[shardId] = Math.max(0, HostConnectionPool.this.connectionsPerShard - shardsConnections.size());
                        ++shardId;
                    }
                    for (shardId = 0; shardId < HostConnectionPool.this.connections.length; ++shardId) {
                        if (needed[shardId] <= 0 || HostConnectionPool.this.scheduledForCreation[shardId].compareAndSet(0, needed[shardId])) continue;
                        needed[shardId] = 0;
                    }
                    HostConnectionPool.this.phase.compareAndSet(Phase.INITIALIZING, Phase.READY);
                    shardId = 0;
                    while (shardId < HostConnectionPool.this.connections.length) {
                        while (true) {
                            int n = shardId++;
                            int n2 = needed[n];
                            needed[n] = n2 - 1;
                            if (n2 <= 0) break;
                            HostConnectionPool.this.manager.blockingExecutor().submit((Runnable)new ConnectionTask(shardId));
                        }
                    }
                    initFuture.set(null);
                }
            }

            public void onFailure(Throwable t) {
                HostConnectionPool.this.phase.compareAndSet(Phase.INITIALIZING, Phase.INIT_FAILED);
                HostConnectionPool.this.forceClose(connections);
                for (List<Connection> shardConnections : HostConnectionPool.this.connections) {
                    HostConnectionPool.this.forceClose(shardConnections);
                }
                for (AtomicInteger o : HostConnectionPool.this.open) {
                    o.set(0);
                }
                initFuture.setException(t);
            }
        }, initExecutor);
    }

    private ListenableFuture<Void> handleErrors(ListenableFuture<Void> connectionInitFuture, Executor executor) {
        return GuavaCompatibility.INSTANCE.withFallback(connectionInitFuture, new AsyncFunction<Throwable, Void>(){

            public ListenableFuture<Void> apply(Throwable t) throws Exception {
                Throwables.propagateIfInstanceOf((Throwable)t, ClusterNameMismatchException.class);
                Throwables.propagateIfInstanceOf((Throwable)t, UnsupportedProtocolVersionException.class);
                Throwables.propagateIfInstanceOf((Throwable)t, AuthenticationException.class);
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                logger.warn("Error creating connection to " + HostConnectionPool.this.host, t);
                return MoreFutures.VOID_SUCCESS;
            }
        }, executor);
    }

    private void forceClose(Collection<Connection> connections) {
        for (Connection connection : connections) {
            connection.closeAsync().force();
        }
    }

    private PoolingOptions options() {
        return this.manager.configuration().getPoolingOptions();
    }

    private Connection findLeastBusyForShard(int shardId) {
        int minInFlight = Integer.MAX_VALUE;
        Connection result = null;
        for (Connection connection : this.connections[shardId]) {
            int inFlight = connection.inFlight.get();
            if (inFlight >= minInFlight) continue;
            minInFlight = inFlight;
            result = connection;
        }
        return result;
    }

    ListenableFuture<Connection> borrowConnection(long timeout, TimeUnit unit, int maxQueueSize, Token.Factory partitioner, ByteBuffer routingKey) {
        int currentCapacity;
        int oldMax;
        int inFlight;
        Phase phase = this.phase.get();
        if (phase != Phase.READY) {
            return Futures.immediateFailedFuture((Throwable)new ConnectionException(this.host.getEndPoint(), "Pool is " + (Object)((Object)phase)));
        }
        int shardId = 0;
        if (this.host.getShardingInfo() != null) {
            if (routingKey != null) {
                Metadata metadata = this.manager.cluster.getMetadata();
                Token t = metadata.newToken(partitioner, routingKey);
                shardId = this.host.getShardingInfo().shardId(t);
            } else {
                shardId = RAND.nextInt(this.host.getShardingInfo().getShardsCount());
            }
        }
        Connection leastBusy = null;
        if (this.connections[shardId].isEmpty()) {
            int firstShardToCheck;
            if (this.host.convictionPolicy.canReconnectNow()) {
                if (this.connectionsPerShard == 0) {
                    this.maybeSpawnNewConnection(shardId);
                } else if (this.scheduledForCreation[shardId].compareAndSet(0, this.connectionsPerShard)) {
                    for (int i = 0; i < this.connectionsPerShard; ++i) {
                        this.manager.blockingExecutor().submit((Runnable)new ConnectionTask(shardId));
                    }
                }
            }
            int shardToCheck = firstShardToCheck = RAND.nextInt(this.connections.length);
            do {
                leastBusy = this.findLeastBusyForShard(shardToCheck);
                shardToCheck = (shardToCheck + 1) % this.connections.length;
            } while (leastBusy == null && shardToCheck != firstShardToCheck);
        } else {
            leastBusy = this.findLeastBusyForShard(shardId);
        }
        if (leastBusy == null) {
            if (this.isClosed()) {
                return Futures.immediateFailedFuture((Throwable)new ConnectionException(this.host.getEndPoint(), "Pool is shutdown"));
            }
            return this.enqueue(timeout, unit, maxQueueSize, shardId);
        }
        do {
            if ((inFlight = leastBusy.inFlight.get()) < Math.min(leastBusy.maxAvailableStreams(), this.options().getMaxRequestsPerConnection(this.hostDistance))) continue;
            return this.enqueue(timeout, unit, maxQueueSize, shardId);
        } while (!leastBusy.inFlight.compareAndSet(inFlight, inFlight + 1));
        int totalInFlightCount = this.totalInFlight.incrementAndGet();
        while (totalInFlightCount > (oldMax = this.maxTotalInFlight.get()) && !this.maxTotalInFlight.compareAndSet(oldMax, totalInFlightCount)) {
        }
        int connectionCount = this.connections[shardId].size() + this.scheduledForCreation[shardId].get();
        if (connectionCount < this.connectionsPerShard) {
            this.maybeSpawnNewConnection(shardId);
        } else if (connectionCount < this.maxConnectionsPerShard && totalInFlightCount > (currentCapacity = (connectionCount - 1) * this.options().getMaxRequestsPerConnection(this.hostDistance) + this.options().getNewConnectionThreshold(this.hostDistance))) {
            this.maybeSpawnNewConnection(shardId);
        }
        return leastBusy.setKeyspaceAsync(this.manager.poolsState.keyspace);
    }

    private ListenableFuture<Connection> enqueue(long timeout, TimeUnit unit, int maxQueueSize, int shardId) {
        int count;
        if (timeout == 0L || maxQueueSize == 0) {
            return Futures.immediateFailedFuture((Throwable)new BusyPoolException(this.host.getEndPoint(), 0));
        }
        do {
            if ((count = this.pendingBorrowCount.get()) < maxQueueSize) continue;
            return Futures.immediateFailedFuture((Throwable)new BusyPoolException(this.host.getEndPoint(), maxQueueSize));
        } while (!this.pendingBorrowCount.compareAndSet(count, count + 1));
        PendingBorrow pendingBorrow = new PendingBorrow(timeout, unit, this.timeoutsExecutor);
        this.pendingBorrows[shardId].add(pendingBorrow);
        if (this.phase.get() == Phase.CLOSING) {
            pendingBorrow.setException(new ConnectionException(this.host.getEndPoint(), "Pool is shutdown"));
        }
        return pendingBorrow.future;
    }

    void returnConnection(Connection connection, boolean busy) {
        connection.inFlight.decrementAndGet();
        this.totalInFlight.decrementAndGet();
        if (this.isClosed()) {
            this.close(connection);
            return;
        }
        if (connection.isDefunct()) {
            return;
        }
        if (connection.state.get() != Connection.State.TRASHED) {
            if (connection.maxAvailableStreams() < this.minAllowedStreams) {
                this.replaceConnection(connection);
            } else if (!busy) {
                this.dequeue(connection);
            }
        }
    }

    private void dequeue(final Connection connection) {
        while (!this.pendingBorrows[connection.shardId()].isEmpty()) {
            int inFlight;
            do {
                if ((inFlight = connection.inFlight.get()) < Math.min(connection.maxAvailableStreams(), this.options().getMaxRequestsPerConnection(this.hostDistance))) continue;
                return;
            } while (!connection.inFlight.compareAndSet(inFlight, inFlight + 1));
            final PendingBorrow pendingBorrow = this.pendingBorrows[connection.shardId()].poll();
            if (pendingBorrow == null) {
                connection.inFlight.decrementAndGet();
                continue;
            }
            this.pendingBorrowCount.decrementAndGet();
            ListenableFuture<Connection> setKeyspaceFuture = connection.setKeyspaceAsync(this.manager.poolsState.keyspace);
            if (setKeyspaceFuture.isDone()) {
                try {
                    if (pendingBorrow.set((Connection)Uninterruptibles.getUninterruptibly(setKeyspaceFuture))) {
                        this.totalInFlight.incrementAndGet();
                        continue;
                    }
                    connection.inFlight.decrementAndGet();
                }
                catch (ExecutionException e) {
                    pendingBorrow.setException(e.getCause());
                    connection.inFlight.decrementAndGet();
                }
                continue;
            }
            GuavaCompatibility.INSTANCE.addCallback(setKeyspaceFuture, new FutureCallback<Connection>(){

                public void onSuccess(Connection c) {
                    if (pendingBorrow.set(c)) {
                        HostConnectionPool.this.totalInFlight.incrementAndGet();
                    } else {
                        connection.inFlight.decrementAndGet();
                    }
                }

                public void onFailure(Throwable t) {
                    pendingBorrow.setException(t);
                    connection.inFlight.decrementAndGet();
                }
            });
        }
    }

    private void replaceConnection(Connection connection) {
        if (!connection.state.compareAndSet(Connection.State.OPEN, Connection.State.TRASHED)) {
            return;
        }
        this.open[connection.shardId()].decrementAndGet();
        this.maybeSpawnNewConnection(connection.shardId());
        connection.maxIdleTime = Long.MIN_VALUE;
        this.doTrashConnection(connection);
    }

    private boolean trashConnection(Connection connection) {
        int opened;
        if (!connection.state.compareAndSet(Connection.State.OPEN, Connection.State.TRASHED)) {
            return true;
        }
        do {
            if ((opened = this.open[connection.shardId()].get()) > this.options().getCoreConnectionsPerHost(this.hostDistance)) continue;
            connection.state.set(Connection.State.OPEN);
            return false;
        } while (!this.open[connection.shardId()].compareAndSet(opened, opened - 1));
        logger.trace("Trashing {}", (Object)connection);
        connection.maxIdleTime = System.currentTimeMillis() + (long)(this.options().getIdleTimeoutSeconds() * 1000);
        this.doTrashConnection(connection);
        return true;
    }

    private void doTrashConnection(Connection connection) {
        this.connections[connection.shardId()].remove(connection);
        this.trash[connection.shardId()].add(connection);
    }

    private ConnectionResult addConnectionIfUnderMaximum(int shardId, ConnectionTasksSharedState sharedState) {
        int opened;
        do {
            if ((opened = this.open[shardId].get()) < this.maxConnectionsPerShard) continue;
            return ConnectionResult.FAILED;
        } while (!this.open[shardId].compareAndSet(opened, opened + 1));
        if (this.phase.get() != Phase.READY) {
            this.open[shardId].decrementAndGet();
            return ConnectionResult.FAILED;
        }
        try {
            Connection newConnection = this.tryResurrectFromTrash(shardId);
            if (newConnection == null) {
                if (!this.host.convictionPolicy.canReconnectNow()) {
                    this.open[shardId].decrementAndGet();
                    return ConnectionResult.SHOULD_RETRY;
                }
                newConnection = sharedState.getConnection(shardId);
                if (newConnection == null) {
                    int serverPort;
                    InetSocketAddress serverAddress = this.host.getEndPoint().resolve();
                    int effectiveShardId = shardId;
                    if (this.canUseAdvancedShardAwareness(false)) {
                        ShardingInfo shardingInfo = this.host.getShardingInfo();
                        boolean isSSLUsed = null != this.manager.configuration().getProtocolOptions().getSSLOptions();
                        serverPort = shardingInfo.getShardAwarePort(isSSLUsed);
                    } else {
                        effectiveShardId = -1;
                        serverPort = serverAddress.getPort();
                    }
                    logger.debug("Creating new connection to {}:{} for shard {}", new Object[]{serverAddress.getAddress().getHostAddress(), serverPort, shardId});
                    newConnection = this.manager.connectionFactory().open(this, effectiveShardId, serverPort);
                    if (newConnection.shardId() == shardId) {
                        newConnection.setKeyspace(this.manager.poolsState.keyspace);
                    } else if ((newConnection = sharedState.addConnectionToClose(shardId, newConnection)) == null) {
                        this.open[shardId].decrementAndGet();
                        return ConnectionResult.SHOULD_RETRY;
                    }
                }
            }
            this.connections[newConnection.shardId()].add(newConnection);
            newConnection.state.compareAndSet(Connection.State.RESURRECTING, Connection.State.OPEN);
            if (this.isClosed() && !newConnection.isClosed()) {
                this.close(newConnection);
                this.open[shardId].decrementAndGet();
                return ConnectionResult.FAILED;
            }
            this.dequeue(newConnection);
            return ConnectionResult.SUCCESS;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.open[shardId].decrementAndGet();
            return ConnectionResult.FAILED;
        }
        catch (ConnectionException e) {
            this.open[shardId].decrementAndGet();
            logger.debug("Connection error to {} while creating additional connection", (Object)this.host);
            return ConnectionResult.FAILED;
        }
        catch (AuthenticationException e) {
            this.open[shardId].decrementAndGet();
            logger.error("Authentication error while creating additional connection (error is: {})", (Object)e.getMessage());
            return ConnectionResult.FAILED;
        }
        catch (UnsupportedProtocolVersionException e) {
            this.open[shardId].decrementAndGet();
            logger.error("UnsupportedProtocolVersionException error while creating additional connection (error is: {})", (Object)e.getMessage());
            return ConnectionResult.FAILED;
        }
        catch (ClusterNameMismatchException e) {
            this.open[shardId].decrementAndGet();
            logger.error("ClusterNameMismatchException error while creating additional connection (error is: {})", (Object)e.getMessage());
            return ConnectionResult.FAILED;
        }
    }

    private Connection tryResurrectFromTrash(int shardId) {
        long highestMaxIdleTime = System.currentTimeMillis();
        Connection chosen = null;
        do {
            for (Connection connection : this.trash[shardId]) {
                if (connection.maxIdleTime <= highestMaxIdleTime || connection.maxAvailableStreams() <= this.minAllowedStreams) continue;
                chosen = connection;
                highestMaxIdleTime = connection.maxIdleTime;
            }
            if (chosen != null) continue;
            return null;
        } while (!chosen.state.compareAndSet(Connection.State.TRASHED, Connection.State.RESURRECTING));
        logger.trace("Resurrecting {}", chosen);
        this.trash[shardId].remove(chosen);
        return chosen;
    }

    private void maybeSpawnNewConnection(int shardId) {
        int inCreation;
        if (this.isClosed() || !this.host.convictionPolicy.canReconnectNow()) {
            return;
        }
        do {
            if ((inCreation = this.scheduledForCreation[shardId].get()) < 1) continue;
            return;
        } while (!this.scheduledForCreation[shardId].compareAndSet(inCreation, inCreation + 1));
        this.scheduleConnectionTask(new ConnectionTask(shardId));
    }

    @Override
    public void onConnectionDefunct(Connection connection) {
        if (connection.state.compareAndSet(Connection.State.OPEN, Connection.State.GONE)) {
            this.open[connection.shardId()].decrementAndGet();
        }
        this.connections[connection.shardId()].remove(connection);
    }

    void cleanupIdleConnections(long now) {
        if (this.isClosed() || this.phase.get() != Phase.READY) {
            return;
        }
        this.shrinkIfBelowCapacity();
        this.cleanupTrash(now);
    }

    private void shrinkIfBelowCapacity() {
        int currentLoad = this.maxTotalInFlight.getAndSet(this.totalInFlight.get());
        int maxRequestsPerConnection = this.options().getMaxRequestsPerConnection(this.hostDistance);
        int needed = currentLoad / maxRequestsPerConnection + 1;
        if (currentLoad % maxRequestsPerConnection > this.options().getNewConnectionThreshold(this.hostDistance)) {
            ++needed;
        }
        needed = Math.max(needed, this.options().getCoreConnectionsPerHost(this.hostDistance));
        int neededPerShard = needed / this.connections.length + (needed % this.connections.length > 0 ? 1 : 0);
        for (List<Connection> shardsConnections : this.connections) {
            if (shardsConnections.size() <= neededPerShard) continue;
            int toTrash = shardsConnections.size() - neededPerShard;
            for (Connection connection : shardsConnections) {
                if (this.trashConnection(connection) && --toTrash == 0) break;
            }
        }
    }

    private void cleanupTrash(long now) {
        for (Set<Connection> shardConnections : this.trash) {
            for (Connection connection : shardConnections) {
                if (connection.maxIdleTime >= now || !connection.state.compareAndSet(Connection.State.TRASHED, Connection.State.GONE)) continue;
                if (connection.inFlight.get() == 0) {
                    logger.trace("Cleaning up {}", (Object)connection);
                    shardConnections.remove(connection);
                    this.close(connection);
                    continue;
                }
                connection.state.set(Connection.State.TRASHED);
            }
        }
    }

    private void close(Connection connection) {
        connection.closeAsync();
    }

    final boolean isClosed() {
        return this.closeFuture.get() != null;
    }

    final CloseFuture closeAsync() {
        CloseFuture future = this.closeFuture.get();
        if (future != null) {
            return future;
        }
        this.phase.set(Phase.CLOSING);
        for (Queue<PendingBorrow> queue : this.pendingBorrows) {
            for (PendingBorrow pendingBorrow : queue) {
                pendingBorrow.setException(new ConnectionException(this.host.getEndPoint(), "Pool is shutdown"));
            }
        }
        future = new CloseFuture.Forwarding(this.discardAvailableConnections());
        return this.closeFuture.compareAndSet(null, future) ? future : this.closeFuture.get();
    }

    int opened() {
        int result = 0;
        for (AtomicInteger o : this.open) {
            result += o.get();
        }
        return result;
    }

    int trashed() {
        int size = 0;
        for (Set<Connection> shardConnections : this.trash) {
            size += shardConnections.size();
        }
        return size;
    }

    /*
     * WARNING - void declaration
     */
    private List<CloseFuture> discardAvailableConnections() {
        void var5_12;
        void var5_10;
        int size = 0;
        for (Set<Connection> set : this.trash) {
            size += set.size();
        }
        for (Collection<Connection> collection : this.connections) {
            size += collection.size();
        }
        ArrayList<CloseFuture> futures = new ArrayList<CloseFuture>(size);
        Collection<Connection>[] collectionArray = this.connections;
        int n = collectionArray.length;
        boolean bl = false;
        while (var5_10 < n) {
            List<Connection> list = collectionArray[var5_10];
            for (final Connection connection : list) {
                CloseFuture future = connection.closeAsync();
                future.addListener(new Runnable(){

                    @Override
                    public void run() {
                        if (connection.state.compareAndSet(Connection.State.OPEN, Connection.State.GONE)) {
                            HostConnectionPool.this.open[connection.shardId()].decrementAndGet();
                        }
                    }
                }, GuavaCompatibility.INSTANCE.sameThreadExecutor());
                futures.add(future);
            }
            ++var5_10;
        }
        collectionArray = this.trash;
        n = collectionArray.length;
        boolean bl2 = false;
        while (var5_12 < n) {
            Collection<Connection> collection = collectionArray[var5_12];
            for (final Connection connection : collection) {
                futures.add(connection.closeAsync());
            }
            ++var5_12;
        }
        return futures;
    }

    void ensureCoreConnections() {
        if (this.isClosed()) {
            return;
        }
        if (!this.host.convictionPolicy.canReconnectNow()) {
            return;
        }
        for (int shardId = 0; shardId < this.connections.length; ++shardId) {
            List<Connection> shardConnections = this.connections[shardId];
            for (int i = shardConnections.size(); i < this.connectionsPerShard; ++i) {
                this.scheduledForCreation[shardId].incrementAndGet();
                this.scheduleConnectionTask(new ConnectionTask(shardId));
            }
        }
    }

    private class PendingBorrow {
        final SettableFuture<Connection> future = SettableFuture.create();
        final Future<?> timeoutTask;

        PendingBorrow(final long timeout, final TimeUnit unit, EventExecutor timeoutsExecutor) {
            this.timeoutTask = timeoutsExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    PendingBorrow.this.future.setException((Throwable)new BusyPoolException(HostConnectionPool.this.host.getEndPoint(), timeout, unit));
                }
            }, timeout, unit);
        }

        boolean set(Connection connection) {
            boolean succeeded = this.future.set((Object)connection);
            this.timeoutTask.cancel(false);
            return succeeded;
        }

        void setException(Throwable exception) {
            this.future.setException(exception);
            this.timeoutTask.cancel(false);
        }
    }

    static class PoolState {
        volatile String keyspace;

        PoolState() {
        }

        void setKeyspace(String keyspace) {
            this.keyspace = keyspace;
        }
    }

    private class ConnectionTask
    implements Runnable {
        private final int shardId;

        public ConnectionTask(int shardId) {
            this.shardId = shardId;
            HostConnectionPool.this.connectionTasksSharedState.registerTask();
        }

        @Override
        public void run() {
            switch (HostConnectionPool.this.addConnectionIfUnderMaximum(this.shardId, HostConnectionPool.this.connectionTasksSharedState)) {
                case SUCCESS: 
                case FAILED: {
                    HostConnectionPool.this.connectionTasksSharedState.unregisterTask();
                    HostConnectionPool.this.scheduledForCreation[this.shardId].decrementAndGet();
                    break;
                }
                case SHOULD_RETRY: {
                    HostConnectionPool.this.scheduleConnectionTask(this);
                }
            }
        }
    }

    private static enum ConnectionResult {
        SUCCESS,
        SHOULD_RETRY,
        FAILED;

    }

    public static class ConnectionTasksSharedState {
        private final Object lock = new Object();
        private int tasksInFlight = 0;
        private Map<Integer, Connection> connectionsToClose = new HashMap<Integer, Connection>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerTask() {
            Object object = this.lock;
            synchronized (object) {
                ++this.tasksInFlight;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterTask() {
            Map<Integer, Connection> toClose = null;
            Iterator<Connection> iterator = this.lock;
            synchronized (iterator) {
                --this.tasksInFlight;
                if (this.tasksInFlight == 0) {
                    toClose = this.connectionsToClose;
                    this.connectionsToClose = new HashMap<Integer, Connection>();
                }
            }
            if (toClose != null) {
                for (Connection c : toClose.values()) {
                    c.closeAsync();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Connection getConnection(int shardId) {
            Object object = this.lock;
            synchronized (object) {
                return this.connectionsToClose.remove(shardId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Connection addConnectionToClose(int shardId, Connection c) {
            Connection res = null;
            boolean close = false;
            Object object = this.lock;
            synchronized (object) {
                res = this.connectionsToClose.remove(shardId);
                boolean bl = close = this.connectionsToClose.get(c.shardId()) != null;
                if (!close) {
                    this.connectionsToClose.put(c.shardId(), c);
                }
            }
            if (close) {
                c.closeAsync();
            }
            return res;
        }
    }

    private static enum Phase {
        INITIALIZING,
        READY,
        INIT_FAILED,
        CLOSING;

    }
}

