/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.hbase.txprune;

import java.util.Objects;
import java.util.SortedSet;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.tephra.shaded.com.google.common.base.Function;
import org.apache.tephra.shaded.com.google.common.base.Joiner;
import org.apache.tephra.shaded.com.google.common.collect.Iterables;

public class TimeRegions {
    static final Function<byte[], String> BYTE_ARR_TO_STRING_FN = new Function<byte[], String>(){

        public String apply(byte[] input) {
            return Bytes.toStringBinary((byte[])input);
        }
    };
    private final long time;
    private final SortedSet<byte[]> regions;

    public TimeRegions(long time, SortedSet<byte[]> regions) {
        this.time = time;
        this.regions = regions;
    }

    public long getTime() {
        return this.time;
    }

    public SortedSet<byte[]> getRegions() {
        return this.regions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeRegions that = (TimeRegions)o;
        return this.time == that.time && Objects.equals(this.regions, that.regions);
    }

    public int hashCode() {
        return Objects.hash(this.time, this.regions);
    }

    public String toString() {
        Iterable regionStrings = Iterables.transform(this.regions, BYTE_ARR_TO_STRING_FN);
        return "TimeRegions{time=" + this.time + ", regions=[" + Joiner.on((String)" ").join(regionStrings) + "]" + '}';
    }
}

