/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.committable.hbase;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.committable.hbase.HBaseCommitTableConfig;
import org.apache.omid.committable.hbase.KeyGenerator;
import org.apache.omid.committable.hbase.KeyGeneratorImplementations;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.AbstractFuture;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.SettableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseCommitTable
implements CommitTable {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseCommitTable.class);
    private final Connection hbaseConnection;
    private final String tableName;
    private final byte[] commitTableFamily;
    private final byte[] lowWatermarkFamily;
    private final KeyGenerator keygen;

    @Inject
    public HBaseCommitTable(Configuration hbaseConfig, HBaseCommitTableConfig config) throws IOException {
        this(ConnectionFactory.createConnection((Configuration)hbaseConfig), config, KeyGeneratorImplementations.defaultKeyGenerator());
    }

    public HBaseCommitTable(Connection hbaseConnection, HBaseCommitTableConfig config) throws IOException {
        this(hbaseConnection, config, KeyGeneratorImplementations.defaultKeyGenerator());
    }

    public HBaseCommitTable(Configuration hbaseConfig, HBaseCommitTableConfig config, KeyGenerator keygen) throws IOException {
        this(ConnectionFactory.createConnection((Configuration)hbaseConfig), config, keygen);
    }

    public HBaseCommitTable(Connection hbaseConnection, HBaseCommitTableConfig config, KeyGenerator keygen) throws IOException {
        this.hbaseConnection = hbaseConnection;
        this.tableName = config.getTableName();
        this.commitTableFamily = config.getCommitTableFamily();
        this.lowWatermarkFamily = config.getLowWatermarkFamily();
        this.keygen = keygen;
    }

    public CommitTable.Writer getWriter() throws IOException {
        return new HBaseWriter();
    }

    public CommitTable.Client getClient() throws IOException {
        return new HBaseClient();
    }

    static long removeCheckpointBits(long startTimestamp) {
        return startTimestamp - startTimestamp % 50L;
    }

    private byte[] startTimestampToKey(long startTimestamp) throws IOException {
        return this.keygen.startTimestampToKey(startTimestamp);
    }

    private static byte[] encodeCommitTimestamp(long startTimestamp, long commitTimestamp) throws IOException {
        assert (startTimestamp < commitTimestamp);
        long diff = commitTimestamp - startTimestamp;
        byte[] bytes = new byte[CodedOutputStream.computeInt64SizeNoTag((long)diff)];
        CodedOutputStream cos = CodedOutputStream.newInstance((byte[])bytes);
        cos.writeInt64NoTag(diff);
        cos.flush();
        return bytes;
    }

    private static long decodeCommitTimestamp(long startTimestamp, byte[] encodedCommitTimestamp) throws IOException {
        CodedInputStream cis = CodedInputStream.newInstance((byte[])encodedCommitTimestamp);
        long diff = cis.readInt64();
        return startTimestamp + diff;
    }

    class HBaseClient
    implements CommitTable.Client {
        HBaseClient() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ListenableFuture<Optional<CommitTable.CommitTimestamp>> getCommitTimestamp(long startTimestamp) {
            startTimestamp = HBaseCommitTable.removeCheckpointBits(startTimestamp);
            SettableFuture f = SettableFuture.create();
            try (Table table = HBaseCommitTable.this.hbaseConnection.getTable(TableName.valueOf((String)HBaseCommitTable.this.tableName));){
                Get get = new Get(HBaseCommitTable.this.startTimestampToKey(startTimestamp));
                get.addColumn(HBaseCommitTable.this.commitTableFamily, HBaseCommitTableConfig.COMMIT_TABLE_QUALIFIER);
                get.addColumn(HBaseCommitTable.this.commitTableFamily, HBaseCommitTableConfig.INVALID_TX_QUALIFIER);
                Result result = table.get(get);
                if (this.containsInvalidTransaction(result)) {
                    CommitTable.CommitTimestamp invalidCT = new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.COMMIT_TABLE, -1L, false);
                    f.set((Object)Optional.of((Object)invalidCT));
                    SettableFuture settableFuture = f;
                    return settableFuture;
                }
                if (this.containsATimestamp(result)) {
                    long commitTSValue = HBaseCommitTable.decodeCommitTimestamp(startTimestamp, result.getValue(HBaseCommitTable.this.commitTableFamily, HBaseCommitTableConfig.COMMIT_TABLE_QUALIFIER));
                    CommitTable.CommitTimestamp validCT = new CommitTable.CommitTimestamp(CommitTable.CommitTimestamp.Location.COMMIT_TABLE, commitTSValue, true);
                    f.set((Object)Optional.of((Object)validCT));
                    return f;
                }
                f.set((Object)Optional.absent());
                return f;
            }
            catch (IOException e) {
                LOG.error("Error getting commit timestamp for TX {}", (Object)startTimestamp, (Object)e);
                f.setException((Throwable)e);
            }
            return f;
        }

        public ListenableFuture<Long> readLowWatermark() {
            SettableFuture f = SettableFuture.create();
            try (Table table = HBaseCommitTable.this.hbaseConnection.getTable(TableName.valueOf((String)HBaseCommitTable.this.tableName));){
                Get get = new Get(HBaseCommitTableConfig.LOW_WATERMARK_ROW);
                get.addColumn(HBaseCommitTable.this.lowWatermarkFamily, HBaseCommitTableConfig.LOW_WATERMARK_QUALIFIER);
                Result result = table.get(get);
                if (this.containsLowWatermark(result)) {
                    long lowWatermark = Bytes.toLong((byte[])result.getValue(HBaseCommitTable.this.lowWatermarkFamily, HBaseCommitTableConfig.LOW_WATERMARK_QUALIFIER));
                    f.set((Object)lowWatermark);
                } else {
                    f.set((Object)0L);
                }
            }
            catch (IOException e) {
                LOG.error("Error getting low watermark", (Throwable)e);
                f.setException((Throwable)e);
            }
            return f;
        }

        public ListenableFuture<Void> deleteCommitEntry(long startTimestamp) {
            byte[] key;
            startTimestamp = HBaseCommitTable.removeCheckpointBits(startTimestamp);
            try {
                key = HBaseCommitTable.this.startTimestampToKey(startTimestamp);
            }
            catch (IOException e) {
                LOG.warn("Error generating timestamp for transaction completion", (Throwable)e);
                SettableFuture f = SettableFuture.create();
                f.setException((Throwable)e);
                return f;
            }
            Delete delete = new Delete(key, startTimestamp);
            try (Table table = HBaseCommitTable.this.hbaseConnection.getTable(TableName.valueOf((String)HBaseCommitTable.this.tableName));){
                table.delete(delete);
            }
            catch (IOException e) {
                SettableFuture f = SettableFuture.create();
                LOG.warn("Error contacting hbase", (Throwable)e);
                f.setException((Throwable)e);
            }
            SettableFuture f = SettableFuture.create();
            f.set(null);
            return f;
        }

        public ListenableFuture<Boolean> tryInvalidateTransaction(long startTimestamp) {
            startTimestamp = HBaseCommitTable.removeCheckpointBits(startTimestamp);
            SettableFuture f = SettableFuture.create();
            try (Table table = HBaseCommitTable.this.hbaseConnection.getTable(TableName.valueOf((String)HBaseCommitTable.this.tableName));){
                byte[] row = HBaseCommitTable.this.startTimestampToKey(startTimestamp);
                Put invalidationPut = new Put(row, startTimestamp);
                invalidationPut.addColumn(HBaseCommitTable.this.commitTableFamily, HBaseCommitTableConfig.INVALID_TX_QUALIFIER, Bytes.toBytes((int)1));
                boolean result = table.checkAndPut(row, HBaseCommitTable.this.commitTableFamily, HBaseCommitTableConfig.COMMIT_TABLE_QUALIFIER, null, invalidationPut);
                f.set((Object)result);
            }
            catch (IOException ioe) {
                f.setException((Throwable)ioe);
            }
            return f;
        }

        private boolean containsATimestamp(Result result) {
            return result != null && result.containsColumn(HBaseCommitTable.this.commitTableFamily, HBaseCommitTableConfig.COMMIT_TABLE_QUALIFIER);
        }

        private boolean containsInvalidTransaction(Result result) {
            return result != null && result.containsColumn(HBaseCommitTable.this.commitTableFamily, HBaseCommitTableConfig.INVALID_TX_QUALIFIER);
        }

        private boolean containsLowWatermark(Result result) {
            return result != null && result.containsColumn(HBaseCommitTable.this.lowWatermarkFamily, HBaseCommitTableConfig.LOW_WATERMARK_QUALIFIER);
        }

        private class DeleteRequest
        extends AbstractFuture<Void> {
            final Delete delete;

            DeleteRequest(Delete delete) {
                this.delete = delete;
            }

            void error(IOException ioe) {
                this.setException(ioe);
            }

            void complete() {
                this.set(null);
            }

            Delete getDelete() {
                return this.delete;
            }
        }
    }

    private class HBaseWriter
    implements CommitTable.Writer {
        private static final long INITIAL_LWM_VALUE = -1L;
        final List<Put> writeBuffer = new LinkedList<Put>();
        volatile long lowWatermarkToStore = -1L;

        HBaseWriter() {
        }

        public void addCommittedTransaction(long startTimestamp, long commitTimestamp) throws IOException {
            assert (startTimestamp < commitTimestamp);
            Put put = new Put(HBaseCommitTable.this.startTimestampToKey(startTimestamp), startTimestamp);
            byte[] value = HBaseCommitTable.encodeCommitTimestamp(startTimestamp, commitTimestamp);
            put.addColumn(HBaseCommitTable.this.commitTableFamily, HBaseCommitTableConfig.COMMIT_TABLE_QUALIFIER, value);
            this.writeBuffer.add(put);
        }

        public void updateLowWatermark(long lowWatermark) throws IOException {
            this.lowWatermarkToStore = lowWatermark;
        }

        public void flush() throws IOException {
            try (Table table = HBaseCommitTable.this.hbaseConnection.getTable(TableName.valueOf((String)HBaseCommitTable.this.tableName));){
                this.addLowWatermarkToStoreToWriteBuffer();
                table.put(this.writeBuffer);
                this.writeBuffer.clear();
            }
            catch (IOException e) {
                LOG.error("Error flushing data", (Throwable)e);
                throw e;
            }
        }

        public void clearWriteBuffer() {
            this.writeBuffer.clear();
        }

        public boolean atomicAddCommittedTransaction(long startTimestamp, long commitTimestamp) throws IOException {
            try (Table table = HBaseCommitTable.this.hbaseConnection.getTable(TableName.valueOf((String)HBaseCommitTable.this.tableName));){
                assert (startTimestamp < commitTimestamp);
                byte[] transactionRow = HBaseCommitTable.this.startTimestampToKey(startTimestamp);
                Put put = new Put(transactionRow, startTimestamp);
                byte[] value = HBaseCommitTable.encodeCommitTimestamp(startTimestamp, commitTimestamp);
                put.addColumn(HBaseCommitTable.this.commitTableFamily, HBaseCommitTableConfig.COMMIT_TABLE_QUALIFIER, value);
                boolean bl = table.checkAndPut(transactionRow, HBaseCommitTable.this.commitTableFamily, HBaseCommitTableConfig.INVALID_TX_QUALIFIER, null, put);
                return bl;
            }
        }

        private void addLowWatermarkToStoreToWriteBuffer() {
            long lowWatermark = this.lowWatermarkToStore;
            if (lowWatermark != -1L) {
                Put put = new Put(HBaseCommitTableConfig.LOW_WATERMARK_ROW);
                put.addColumn(HBaseCommitTable.this.lowWatermarkFamily, HBaseCommitTableConfig.LOW_WATERMARK_QUALIFIER, Bytes.toBytes((long)lowWatermark));
                this.writeBuffer.add(put);
            }
        }
    }
}

