/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.internal;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.apache.tephra.shaded.com.google.common.collect.Maps;
import org.apache.tephra.shaded.com.google.common.util.concurrent.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ListenerExecutor
implements Service.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerExecutor.class);
    private final Service.Listener delegate;
    private final Executor executor;
    private final ConcurrentMap<Service.State, Boolean> callStates = Maps.newConcurrentMap();

    ListenerExecutor(Service.Listener delegate, Executor executor) {
        this.delegate = delegate;
        this.executor = executor;
    }

    @Override
    public void starting() {
        if (this.hasCalled(Service.State.STARTING)) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ListenerExecutor.this.delegate.starting();
                }
                catch (Throwable t) {
                    LOG.warn("Exception thrown from listener", t);
                }
            }
        });
    }

    @Override
    public void running() {
        if (this.hasCalled(Service.State.RUNNING)) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ListenerExecutor.this.delegate.running();
                }
                catch (Throwable t) {
                    LOG.warn("Exception thrown from listener", t);
                }
            }
        });
    }

    @Override
    public void stopping(final Service.State from) {
        if (this.hasCalled(Service.State.STOPPING)) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ListenerExecutor.this.delegate.stopping(from);
                }
                catch (Throwable t) {
                    LOG.warn("Exception thrown from listener", t);
                }
            }
        });
    }

    @Override
    public void terminated(final Service.State from) {
        if (this.hasCalled(Service.State.TERMINATED)) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ListenerExecutor.this.delegate.terminated(from);
                }
                catch (Throwable t) {
                    LOG.warn("Exception thrown from listener", t);
                }
            }
        });
    }

    @Override
    public void failed(final Service.State from, final Throwable failure) {
        if (this.hasCalled(Service.State.TERMINATED)) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ListenerExecutor.this.delegate.failed(from, failure);
                }
                catch (Throwable t) {
                    LOG.warn("Exception thrown from listener", t);
                }
            }
        });
    }

    private boolean hasCalled(Service.State state) {
        return this.callStates.putIfAbsent(state, true) != null;
    }
}

