/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.internal;

import org.apache.tephra.shaded.com.google.common.collect.HashMultimap;
import org.apache.tephra.shaded.com.google.common.collect.Multimap;
import org.apache.tephra.shaded.com.google.common.collect.Multimaps;
import org.apache.tephra.shaded.org.apache.twill.api.ElectionHandler;
import org.apache.tephra.shaded.org.apache.twill.common.Cancellable;
import org.apache.tephra.shaded.org.apache.twill.internal.zookeeper.LeaderElection;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ZKClient;

public class ElectionRegistry {
    private final ZKClient zkClient;
    private final Multimap<String, LeaderElection> registry;

    public ElectionRegistry(ZKClient zkClient) {
        this.zkClient = zkClient;
        HashMultimap multimap = HashMultimap.create();
        this.registry = Multimaps.synchronizedMultimap(multimap);
    }

    public Cancellable register(String name, ElectionHandler handler) {
        LeaderElection election = new LeaderElection(this.zkClient, name, handler);
        election.start();
        this.registry.put(name, election);
        return new CancellableElection(name, election);
    }

    public void shutdown() {
        for (LeaderElection election : this.registry.values()) {
            election.stop();
        }
    }

    private class CancellableElection
    implements Cancellable {
        private final String name;
        private final LeaderElection election;

        public CancellableElection(String name, LeaderElection election) {
            this.name = name;
            this.election = election;
        }

        @Override
        public void cancel() {
            this.election.stop();
            ElectionRegistry.this.registry.remove(this.name, this.election);
        }
    }
}

