/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.api;

import org.apache.tephra.shaded.org.apache.twill.internal.DefaultResourceSpecification;

public interface ResourceSpecification {
    public static final ResourceSpecification BASIC = Builder.with().setVirtualCores(1).setMemory(512, SizeUnit.MEGA).build();

    @Deprecated
    public int getCores();

    public int getVirtualCores();

    public int getMemorySize();

    public int getUplink();

    public int getDownlink();

    public int getInstances();

    public static final class Builder {
        private int cores;
        private int memory;
        private int uplink = -1;
        private int downlink = -1;
        private int instances = 1;

        public static CoreSetter with() {
            return new Builder().new CoreSetter();
        }

        private Builder() {
        }

        public abstract class Build {
            public ResourceSpecification build() {
                return new DefaultResourceSpecification(Builder.this.cores, Builder.this.memory, Builder.this.instances, Builder.this.uplink, Builder.this.downlink);
            }
        }

        public final class Done
        extends Build {
        }

        public final class AfterUplink
        extends Build {
            public Done setDownlink(int downlink, SizeUnit unit) {
                Builder.this.downlink = downlink * unit.multiplier;
                return new Done();
            }
        }

        public final class AfterInstances
        extends Build {
            public AfterUplink setUplink(int uplink, SizeUnit unit) {
                Builder.this.uplink = uplink * unit.multiplier;
                return new AfterUplink();
            }
        }

        public final class AfterMemory
        extends Build {
            public AfterInstances setInstances(int instances) {
                Builder.this.instances = instances;
                return new AfterInstances();
            }
        }

        public final class MemorySetter {
            public AfterMemory setMemory(int size, SizeUnit unit) {
                Builder.this.memory = size * unit.multiplier;
                return new AfterMemory();
            }
        }

        public final class CoreSetter {
            @Deprecated
            public MemorySetter setCores(int cores) {
                Builder.this.cores = cores;
                return new MemorySetter();
            }

            public MemorySetter setVirtualCores(int cores) {
                Builder.this.cores = cores;
                return new MemorySetter();
            }
        }
    }

    public static enum SizeUnit {
        MEGA(1),
        GIGA(1024);

        private final int multiplier;

        private SizeUnit(int multiplier) {
            this.multiplier = multiplier;
        }
    }
}

