/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.runtime;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import org.apache.tephra.DefaultTransactionExecutor;
import org.apache.tephra.TransactionExecutor;
import org.apache.tephra.TransactionExecutorFactory;
import org.apache.tephra.TransactionManager;
import org.apache.tephra.TransactionSystemClient;
import org.apache.tephra.distributed.TransactionServiceClient;
import org.apache.tephra.metrics.DefaultMetricsCollector;
import org.apache.tephra.metrics.MetricsCollector;
import org.apache.tephra.persist.HDFSTransactionStateStorage;
import org.apache.tephra.persist.TransactionStateStorage;
import org.apache.tephra.runtime.TransactionStateStorageProvider;
import org.apache.tephra.snapshot.SnapshotCodecProvider;

final class TransactionDistributedModule
extends AbstractModule {
    private final String clientId;

    public TransactionDistributedModule() {
        this(ManagementFactory.getRuntimeMXBean().getName());
    }

    public TransactionDistributedModule(String clientId) {
        this.clientId = clientId;
    }

    protected void configure() {
        this.bind(SnapshotCodecProvider.class).in(Singleton.class);
        this.bind(TransactionStateStorage.class).annotatedWith((Annotation)Names.named((String)"persist")).to(HDFSTransactionStateStorage.class);
        this.bind(TransactionStateStorage.class).toProvider(TransactionStateStorageProvider.class);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"tephra.client.id")).to(this.clientId);
        this.bind(TransactionManager.class);
        this.bind(TransactionSystemClient.class).to(TransactionServiceClient.class).in(Scopes.SINGLETON);
        this.bind(MetricsCollector.class).to(DefaultMetricsCollector.class);
        this.install(new FactoryModuleBuilder().implement(TransactionExecutor.class, DefaultTransactionExecutor.class).build(TransactionExecutorFactory.class));
    }
}

