/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.persist;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.tephra.ChangeId;
import org.apache.tephra.TransactionType;
import org.apache.tephra.persist.TransactionEdit;
import org.apache.tephra.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.tephra.shaded.com.google.common.collect.Sets;

public class TransactionEditCodecs {
    private static final TransactionEditCodec[] ALL_CODECS = new TransactionEditCodec[]{new TransactionEditCodecV1(), new TransactionEditCodecV2(), new TransactionEditCodecV3(), new TransactionEditCodecV4()};
    private static final SortedMap<Byte, TransactionEditCodec> CODECS = new TreeMap<Byte, TransactionEditCodec>();

    public static void decode(TransactionEdit dest, DataInput in) throws IOException {
        byte version = in.readByte();
        TransactionEditCodec codec = (TransactionEditCodec)CODECS.get(version);
        if (codec == null) {
            throw new IOException("TransactionEdit was serialized with an unknown codec version " + version + ". Was it written with a newer version of Tephra?");
        }
        codec.decode(dest, in);
    }

    public static void encode(TransactionEdit src, DataOutput out) throws IOException {
        TransactionEditCodec latestCodec = (TransactionEditCodec)CODECS.get(CODECS.firstKey());
        out.writeByte(latestCodec.getVersion());
        latestCodec.encode(src, out);
    }

    @VisibleForTesting
    static void encode(TransactionEdit src, DataOutput out, TransactionEditCodec codec) throws IOException {
        out.writeByte(codec.getVersion());
        codec.encode(src, out);
    }

    static {
        for (TransactionEditCodec codec : ALL_CODECS) {
            CODECS.put(codec.getVersion(), codec);
        }
    }

    static class TransactionEditCodecV4
    extends TransactionEditCodecV3 {
        TransactionEditCodecV4() {
        }

        @Override
        public void decode(TransactionEdit dest, DataInput in) throws IOException {
            super.decode(dest, in);
            dest.setParentWritePointer(in.readLong());
            int checkpointPointersLen = in.readInt();
            if (checkpointPointersLen >= 0) {
                long[] checkpointPointers = new long[checkpointPointersLen];
                for (int i = 0; i < checkpointPointersLen; ++i) {
                    checkpointPointers[i] = in.readLong();
                }
                dest.setCheckpointPointers(checkpointPointers);
            }
        }

        @Override
        public void encode(TransactionEdit src, DataOutput out) throws IOException {
            super.encode(src, out);
            out.writeLong(src.getParentWritePointer());
            long[] checkpointPointers = src.getCheckpointPointers();
            if (checkpointPointers == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(checkpointPointers.length);
                for (int i = 0; i < checkpointPointers.length; ++i) {
                    out.writeLong(checkpointPointers[i]);
                }
            }
        }

        @Override
        public byte getVersion() {
            return -4;
        }
    }

    static class TransactionEditCodecV3
    extends TransactionEditCodecV2
    implements TransactionEditCodec {
        TransactionEditCodecV3() {
        }

        @Override
        public void decode(TransactionEdit dest, DataInput in) throws IOException {
            super.decode(dest, in);
            int typeIdx = in.readInt();
            if (typeIdx < 0) {
                dest.setType(null);
            } else {
                try {
                    dest.setType(TransactionType.values()[typeIdx]);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IOException("Type enum ordinal value is out of range: " + typeIdx);
                }
            }
            int truncateInvalidTxSize = in.readInt();
            Set<Long> truncateInvalidTx2 = this.emptySet(dest.getTruncateInvalidTx());
            for (int i = 0; i < truncateInvalidTxSize; ++i) {
                truncateInvalidTx2.add(in.readLong());
            }
            dest.setTruncateInvalidTx(truncateInvalidTx2);
            dest.setTruncateInvalidTxTime(in.readLong());
        }

        private <T> Set<T> emptySet(Set<T> set) {
            if (set == null) {
                return Sets.newHashSet();
            }
            set.clear();
            return set;
        }

        @Override
        public void encode(TransactionEdit src, DataOutput out) throws IOException {
            super.encode(src, out);
            if (src.getType() == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(src.getType().ordinal());
            }
            Set<Long> truncateInvalidTx2 = src.getTruncateInvalidTx();
            if (truncateInvalidTx2 == null) {
                out.writeInt(0);
            } else {
                out.writeInt(truncateInvalidTx2.size());
                for (long id : truncateInvalidTx2) {
                    out.writeLong(id);
                }
            }
            out.writeLong(src.getTruncateInvalidTxTime());
        }

        @Override
        public byte getVersion() {
            return -3;
        }
    }

    static class TransactionEditCodecV2
    extends TransactionEditCodecV1
    implements TransactionEditCodec {
        TransactionEditCodecV2() {
        }

        @Override
        public void decode(TransactionEdit dest, DataInput in) throws IOException {
            super.decode(dest, in);
            dest.setVisibilityUpperBound(in.readLong());
        }

        @Override
        public void encode(TransactionEdit src, DataOutput out) throws IOException {
            super.encode(src, out);
            out.writeLong(src.getVisibilityUpperBound());
        }

        @Override
        public byte getVersion() {
            return -2;
        }
    }

    static class TransactionEditCodecV1
    implements TransactionEditCodec {
        TransactionEditCodecV1() {
        }

        @Override
        public void decode(TransactionEdit dest, DataInput in) throws IOException {
            dest.setWritePointer(in.readLong());
            int stateIdx = in.readInt();
            try {
                dest.setState(TransactionEdit.State.values()[stateIdx]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("State enum ordinal value is out of range: " + stateIdx);
            }
            dest.setExpiration(in.readLong());
            dest.setCommitPointer(in.readLong());
            dest.setCanCommit(in.readBoolean());
            int changeSize = in.readInt();
            HashSet<ChangeId> changes = Sets.newHashSet();
            for (int i = 0; i < changeSize; ++i) {
                int currentLength = in.readInt();
                byte[] currentBytes = new byte[currentLength];
                in.readFully(currentBytes);
                changes.add(new ChangeId(currentBytes));
            }
            dest.setChanges(changes);
            dest.setVisibilityUpperBound(0L);
        }

        @Override
        @Deprecated
        public void encode(TransactionEdit src, DataOutput out) throws IOException {
            out.writeLong(src.getWritePointer());
            out.writeInt(src.getState().ordinal());
            out.writeLong(src.getExpiration());
            out.writeLong(src.getCommitPointer());
            out.writeBoolean(src.getCanCommit());
            Set<ChangeId> changes = src.getChanges();
            if (changes == null) {
                out.writeInt(0);
            } else {
                out.writeInt(changes.size());
                for (ChangeId c : changes) {
                    byte[] cKey = c.getKey();
                    out.writeInt(cKey.length);
                    out.write(cKey);
                }
            }
        }

        @Override
        public byte getVersion() {
            return -1;
        }
    }

    static interface TransactionEditCodec {
        public void decode(TransactionEdit var1, DataInput var2) throws IOException;

        public void encode(TransactionEdit var1, DataOutput var2) throws IOException;

        public byte getVersion();
    }
}

