/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.tephra.TransactionExecutor;
import org.apache.tephra.TransactionFailureException;
import org.apache.tephra.shaded.com.google.common.base.Throwables;
import org.apache.tephra.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.tephra.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.tephra.shaded.com.google.common.util.concurrent.MoreExecutors;

public abstract class AbstractTransactionExecutor
implements TransactionExecutor {
    private final ListeningExecutorService executorService;

    protected AbstractTransactionExecutor(ExecutorService executorService) {
        this.executorService = MoreExecutors.listeningDecorator(executorService);
    }

    @Override
    public <I, O> O executeUnchecked(TransactionExecutor.Function<I, O> function, I input) {
        try {
            return this.execute(function, input);
        }
        catch (TransactionFailureException e) {
            throw Throwables.propagate(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate(e);
        }
    }

    @Override
    public <I> void executeUnchecked(TransactionExecutor.Procedure<I> procedure, I input) {
        try {
            this.execute(procedure, input);
        }
        catch (TransactionFailureException e) {
            throw Throwables.propagate(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate(e);
        }
    }

    @Override
    public <O> O executeUnchecked(Callable<O> callable) {
        try {
            return this.execute(callable);
        }
        catch (TransactionFailureException e) {
            throw Throwables.propagate(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void executeUnchecked(TransactionExecutor.Subroutine subroutine) {
        try {
            this.execute(subroutine);
        }
        catch (TransactionFailureException e) {
            throw Throwables.propagate(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate(e);
        }
    }

    @Override
    public <I, O> ListenableFuture<O> submit(final TransactionExecutor.Function<I, O> function, final I input) {
        return this.executorService.submit(new Callable<O>(){

            @Override
            public O call() throws Exception {
                return AbstractTransactionExecutor.this.execute(function, input);
            }
        });
    }

    @Override
    public <I> ListenableFuture<?> submit(final TransactionExecutor.Procedure<I> procedure, final I input) {
        return this.executorService.submit(new Callable<Object>(){

            @Override
            public I call() throws Exception {
                AbstractTransactionExecutor.this.execute(procedure, input);
                return null;
            }
        });
    }

    @Override
    public <O> ListenableFuture<O> submit(final Callable<O> callable) {
        return this.executorService.submit(new Callable<O>(){

            @Override
            public O call() throws Exception {
                return AbstractTransactionExecutor.this.execute(callable);
            }
        });
    }

    @Override
    public ListenableFuture<?> submit(final TransactionExecutor.Subroutine subroutine) {
        return this.executorService.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                AbstractTransactionExecutor.this.execute(subroutine);
                return null;
            }
        });
    }
}

