/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.openTSDB;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.openTSDB.OpenTSDBSubScan;
import org.apache.drill.exec.store.openTSDB.Util;
import org.apache.drill.exec.store.openTSDB.client.OpenTSDBTypes;
import org.apache.drill.exec.store.openTSDB.client.Schema;
import org.apache.drill.exec.store.openTSDB.client.Service;
import org.apache.drill.exec.store.openTSDB.dto.ColumnDTO;
import org.apache.drill.exec.store.openTSDB.dto.MetricDTO;
import org.apache.drill.exec.vector.NullableFloat8Vector;
import org.apache.drill.exec.vector.NullableTimeStampVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTSDBRecordReader
extends AbstractRecordReader {
    private static final Logger logger = LoggerFactory.getLogger(OpenTSDBRecordReader.class);
    private static final int TARGET_RECORD_COUNT = 4000;
    private static final Map<OpenTSDBTypes, TypeProtos.MinorType> TYPES = ImmutableMap.builder().put((Object)OpenTSDBTypes.STRING, (Object)TypeProtos.MinorType.VARCHAR).put((Object)OpenTSDBTypes.DOUBLE, (Object)TypeProtos.MinorType.FLOAT8).put((Object)OpenTSDBTypes.TIMESTAMP, (Object)TypeProtos.MinorType.TIMESTAMP).build();
    private Service db;
    private Iterator<MetricDTO> tableIterator;
    private OutputMutator output;
    private ImmutableList<ProjectedColumnInfo> projectedCols;
    private Map<String, String> params;

    public OpenTSDBRecordReader(Service client, OpenTSDBSubScan.OpenTSDBSubScanSpec subScanSpec, List<SchemaPath> projectedColumns) {
        this.setColumns(projectedColumns);
        this.db = client;
        this.params = Util.fromRowData(subScanSpec.getTableName());
        logger.debug("Scan spec: {}", (Object)subScanSpec);
    }

    public void setup(OperatorContext context, OutputMutator output) {
        this.output = output;
        Set<MetricDTO> metrics = this.db.getAllMetrics(this.params);
        if (metrics == null) {
            throw UserException.validationError().message(String.format("Table '%s' not found", this.params.get("metric")), new Object[0]).build(logger);
        }
        this.tableIterator = metrics.iterator();
    }

    public int next() {
        try {
            return this.processOpenTSDBTablesData();
        }
        catch (SchemaChangeException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }

    public void close() {
    }

    private int processOpenTSDBTablesData() throws SchemaChangeException {
        int rowCounter = 0;
        while (this.tableIterator.hasNext() && rowCounter < 4000) {
            MetricDTO metricDTO = this.tableIterator.next();
            rowCounter = this.addRowResult(metricDTO, rowCounter);
        }
        return rowCounter;
    }

    private int addRowResult(MetricDTO table, int rowCounter) throws SchemaChangeException {
        this.setupProjectedColsIfItNull();
        for (String time : table.getDps().keySet()) {
            String value = table.getDps().get(time);
            this.setupDataToDrillTable(table, time, value, table.getTags(), rowCounter);
            ++rowCounter;
        }
        return rowCounter;
    }

    private void setupProjectedColsIfItNull() throws SchemaChangeException {
        if (this.projectedCols == null) {
            this.initCols(new Schema(this.db, this.params.get("metric")));
        }
    }

    private void setupDataToDrillTable(MetricDTO table, String timestamp, String value, Map<String, String> tags, int rowCount) {
        block12: for (ProjectedColumnInfo pci : this.projectedCols) {
            switch (pci.openTSDBColumn.getColumnName()) {
                case "metric": {
                    this.setStringColumnValue(table.getMetric(), pci, rowCount);
                    continue block12;
                }
                case "aggregate tags": {
                    this.setStringColumnValue(table.getAggregateTags().toString(), pci, rowCount);
                    continue block12;
                }
                case "timestamp": {
                    this.setTimestampColumnValue(timestamp, pci, rowCount);
                    continue block12;
                }
                case "aggregated value": {
                    this.setDoubleColumnValue(value, pci, rowCount);
                    continue block12;
                }
            }
            this.setStringColumnValue(tags.get(pci.openTSDBColumn.getColumnName()), pci, rowCount);
        }
    }

    private void setTimestampColumnValue(String timestamp, ProjectedColumnInfo pci, int rowCount) {
        this.setTimestampColumnValue(timestamp != null ? Long.parseLong(timestamp) : Long.parseLong("0"), pci, rowCount);
    }

    private void setDoubleColumnValue(String value, ProjectedColumnInfo pci, int rowCount) {
        this.setDoubleColumnValue(value != null ? Double.parseDouble(value) : 0.0, pci, rowCount);
    }

    private void setStringColumnValue(String data, ProjectedColumnInfo pci, int rowCount) {
        if (data == null) {
            data = "null";
        }
        ByteBuffer value = ByteBuffer.wrap(data.getBytes(StandardCharsets.UTF_8));
        ((NullableVarCharVector.Mutator)pci.vv.getMutator()).setSafe(rowCount, value, 0, value.remaining());
    }

    private void setTimestampColumnValue(Long data, ProjectedColumnInfo pci, int rowCount) {
        ((NullableTimeStampVector.Mutator)pci.vv.getMutator()).setSafe(rowCount, data * 1000L);
    }

    private void setDoubleColumnValue(Double data, ProjectedColumnInfo pci, int rowCount) {
        ((NullableFloat8Vector.Mutator)pci.vv.getMutator()).setSafe(rowCount, data.doubleValue());
    }

    private void initCols(Schema schema) throws SchemaChangeException {
        ImmutableList.Builder pciBuilder = ImmutableList.builder();
        for (int i = 0; i < schema.getColumnCount(); ++i) {
            ColumnDTO column = schema.getColumnByIndex(i);
            String name = column.getColumnName();
            OpenTSDBTypes type = column.getColumnType();
            TypeProtos.MinorType minorType = TYPES.get((Object)type);
            if (this.isMinorTypeNull(minorType)) {
                String message = String.format("A column you queried has a data type that is not currently supported by the OpenTSDB storage plugin. The column's name was %s and its OpenTSDB data type was %s. ", name, type.toString());
                throw UserException.unsupportedError().message(message, new Object[0]).build(logger);
            }
            ProjectedColumnInfo pci = this.getProjectedColumnInfo(column, name, minorType);
            pciBuilder.add((Object)pci);
        }
        this.projectedCols = pciBuilder.build();
    }

    private boolean isMinorTypeNull(TypeProtos.MinorType minorType) {
        return minorType == null;
    }

    private ProjectedColumnInfo getProjectedColumnInfo(ColumnDTO column, String name, TypeProtos.MinorType minorType) throws SchemaChangeException {
        TypeProtos.MajorType majorType = this.getMajorType(minorType);
        MaterializedField field = MaterializedField.create((String)name, (TypeProtos.MajorType)majorType);
        ValueVector vector = this.getValueVector(minorType, majorType, field);
        return this.getProjectedColumnInfo(column, vector);
    }

    private TypeProtos.MajorType getMajorType(TypeProtos.MinorType minorType) {
        TypeProtos.MajorType majorType = Types.optional((TypeProtos.MinorType)minorType);
        return majorType;
    }

    private ValueVector getValueVector(TypeProtos.MinorType minorType, TypeProtos.MajorType majorType, MaterializedField field) throws SchemaChangeException {
        Class clazz = TypeHelper.getValueVectorClass((TypeProtos.MinorType)minorType, (TypeProtos.DataMode)majorType.getMode());
        ValueVector vector = this.output.addField(field, clazz);
        vector.allocateNew();
        return vector;
    }

    private ProjectedColumnInfo getProjectedColumnInfo(ColumnDTO column, ValueVector vector) {
        ProjectedColumnInfo pci = new ProjectedColumnInfo();
        pci.vv = vector;
        pci.openTSDBColumn = column;
        return pci;
    }

    private static class ProjectedColumnInfo {
        ValueVector vv;
        ColumnDTO openTSDBColumn;

        private ProjectedColumnInfo() {
        }
    }
}

