/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlDialectFactory;
import org.apache.calcite.sql.SqlDialectFactoryImpl;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.planner.PlannerPhase;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.jdbc.DrillJdbcConvention;
import org.apache.drill.exec.store.jdbc.JdbcConventionFactory;
import org.apache.drill.exec.store.jdbc.JdbcDialect;
import org.apache.drill.exec.store.jdbc.JdbcDialectFactory;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStoragePlugin
extends AbstractStoragePlugin {
    static final Logger logger = LoggerFactory.getLogger(JdbcStoragePlugin.class);
    private final JdbcStorageConfig jdbcStorageConfig;
    private final JdbcDialectFactory dialectFactory;
    private final JdbcConventionFactory conventionFactory;
    private volatile SqlDialect sqlDialect;
    private final Map<String, HikariDataSource> dataSources = new ConcurrentHashMap<String, HikariDataSource>();

    public JdbcStoragePlugin(JdbcStorageConfig jdbcStorageConfig, DrillbitContext context, String name) {
        super(context, name);
        this.jdbcStorageConfig = jdbcStorageConfig;
        this.dialectFactory = new JdbcDialectFactory();
        this.conventionFactory = new JdbcConventionFactory();
    }

    public void registerSchemas(SchemaConfig config, SchemaPlus parent) {
        UserBitShared.UserCredentials userCreds = config.getQueryUserCredentials();
        Optional<DataSource> dataSource = this.getDataSource(userCreds);
        if (!dataSource.isPresent()) {
            logger.debug("No schemas will be registered in {} for query user {}.", (Object)this.getName(), (Object)config.getUserName());
            return;
        }
        SqlDialect dialect = this.getDialect(userCreds);
        this.getJdbcDialect(dialect).registerSchemas(config, parent);
    }

    public Optional<DataSource> getDataSource(UserBitShared.UserCredentials userCredentials) {
        Optional<UsernamePasswordCredentials> jdbcCreds = this.jdbcStorageConfig.getUsernamePasswordCredentials(userCredentials);
        if (!jdbcCreds.isPresent() && this.jdbcStorageConfig.getAuthMode() == StoragePluginConfig.AuthMode.USER_TRANSLATION) {
            logger.info("There are no {} mode credentials in {} for query user {}, will not attempt to connect.", new Object[]{StoragePluginConfig.AuthMode.USER_TRANSLATION, this.getName(), userCredentials.getUserName()});
            return Optional.empty();
        }
        String dsKey = jdbcCreds.isPresent() ? jdbcCreds.get().getUsername() : ImpersonationUtil.getProcessUserName();
        return Optional.of((DataSource)this.dataSources.computeIfAbsent(dsKey, ds -> JdbcStoragePlugin.initDataSource(this.jdbcStorageConfig, jdbcCreds.orElse(null))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlDialect getDialect(UserBitShared.UserCredentials userCredentials) {
        SqlDialect sd = this.sqlDialect;
        if (sd == null) {
            JdbcStoragePlugin jdbcStoragePlugin = this;
            synchronized (jdbcStoragePlugin) {
                sd = this.sqlDialect;
                if (sd == null) {
                    this.sqlDialect = sd = JdbcSchema.createDialect((SqlDialectFactory)SqlDialectFactoryImpl.INSTANCE, (DataSource)this.getDataSource(userCredentials).get());
                }
            }
        }
        return sd;
    }

    public JdbcDialect getJdbcDialect(SqlDialect dialect) {
        return this.dialectFactory.getJdbcDialect(this, dialect);
    }

    public DrillJdbcConvention getConvention(SqlDialect dialect, UserBitShared.UserCredentials userCredentials) {
        return this.conventionFactory.getJdbcConvention(this, dialect, userCredentials);
    }

    public JdbcStorageConfig getConfig() {
        return this.jdbcStorageConfig;
    }

    public boolean supportsRead() {
        return true;
    }

    public boolean supportsWrite() {
        return this.jdbcStorageConfig.isWritable();
    }

    public boolean supportsInsert() {
        return this.jdbcStorageConfig.isWritable();
    }

    public Set<? extends RelOptRule> getOptimizerRules(OptimizerRulesContext optimizerContext, PlannerPhase phase) {
        switch (phase) {
            case LOGICAL: 
            case PHYSICAL: {
                UserBitShared.UserCredentials userCreds = optimizerContext.getContextInformation().getQueryUserCredentials();
                return this.getDataSource(userCreds).map(dataSource -> this.getConvention(this.getDialect(userCreds), userCreds).getRules()).orElse((Set)ImmutableSet.of());
            }
        }
        return ImmutableSet.of();
    }

    public void close() throws Exception {
        AutoCloseables.close(this.dataSources.values());
    }

    @VisibleForTesting
    static HikariDataSource initDataSource(JdbcStorageConfig config, UsernamePasswordCredentials jdbcCredentials) {
        try {
            Properties properties = new Properties();
            properties.setProperty("idleTimeout", String.valueOf(TimeUnit.HOURS.toMillis(2L)));
            properties.setProperty("keepaliveTime", String.valueOf(TimeUnit.MINUTES.toMillis(5L)));
            properties.setProperty("maxLifetime", String.valueOf(TimeUnit.HOURS.toMillis(12L)));
            properties.setProperty("minimumIdle", "0");
            properties.setProperty("maximumPoolSize", "10");
            properties.putAll(config.getSourceParameters());
            HikariConfig hikariConfig = new HikariConfig(properties);
            hikariConfig.setDriverClassName(config.getDriver());
            hikariConfig.setJdbcUrl(config.getUrl());
            if (jdbcCredentials != null) {
                hikariConfig.setUsername(jdbcCredentials.getUsername());
                hikariConfig.setPassword(jdbcCredentials.getPassword());
            }
            if (config.isWritable() != null) {
                hikariConfig.setReadOnly(config.isWritable() == false);
            }
            return new HikariDataSource(hikariConfig);
        }
        catch (RuntimeException e) {
            throw UserException.connectionError((Throwable)e).message("Unable to configure data source: %s", new Object[]{e.getMessage()}).build(logger);
        }
    }
}

