/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.time.Duration;
import org.apache.calcite.sql.SqlDialect;
import org.apache.drill.exec.store.jdbc.DefaultJdbcDialect;
import org.apache.drill.exec.store.jdbc.JdbcDialect;
import org.apache.drill.exec.store.jdbc.JdbcStoragePlugin;
import org.apache.drill.exec.store.jdbc.clickhouse.ClickhouseJdbcDialect;

public class JdbcDialectFactory {
    public static final String JDBC_CLICKHOUSE_PREFIX = "jdbc:clickhouse";
    public static final int CACHE_SIZE = 100;
    public static final Duration CACHE_TTL = Duration.ofHours(1L);
    private volatile JdbcDialect jdbcDialect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcDialect getJdbcDialect(JdbcStoragePlugin plugin, SqlDialect dialect) {
        JdbcDialect jd = this.jdbcDialect;
        if (jd == null) {
            JdbcDialectFactory jdbcDialectFactory = this;
            synchronized (jdbcDialectFactory) {
                jd = this.jdbcDialect;
                if (jd == null) {
                    this.jdbcDialect = jd = plugin.getConfig().getUrl().startsWith(JDBC_CLICKHOUSE_PREFIX) ? new ClickhouseJdbcDialect(plugin, dialect) : new DefaultJdbcDialect(plugin, dialect);
                }
            }
        }
        return jd;
    }
}

