/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlDialect;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.jdbc.CapitalizingJdbcSchema;
import org.apache.drill.exec.store.jdbc.DrillJdbcConvention;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JdbcCatalogSchema
extends AbstractSchema {
    private static final Logger logger = LoggerFactory.getLogger(JdbcCatalogSchema.class);
    private final Map<String, CapitalizingJdbcSchema> schemaMap = new HashMap<String, CapitalizingJdbcSchema>();
    private final CapitalizingJdbcSchema defaultSchema;

    JdbcCatalogSchema(String name, DataSource source, SqlDialect dialect, DrillJdbcConvention convention, boolean caseSensitive) {
        super(Collections.emptyList(), name);
        String connectionSchemaName = null;
        try (Connection con = source.getConnection();
             ResultSet set = con.getMetaData().getCatalogs();){
            try {
                connectionSchemaName = con.getSchema();
            }
            catch (AbstractMethodError ex) {
                logger.warn("{} does not provide an implementation of getSchema(), default schema will be guessed", con.getClass());
            }
            while (set.next()) {
                String catalogName = set.getString(1);
                if (catalogName == null) continue;
                CapitalizingJdbcSchema schema = new CapitalizingJdbcSchema(this.getSchemaPath(), catalogName, source, dialect, convention, catalogName, null, caseSensitive);
                this.schemaMap.put(schema.getName(), schema);
            }
        }
        catch (SQLException e) {
            logger.warn("Failure while attempting to load JDBC schema.", (Throwable)e);
        }
        if (this.schemaMap.isEmpty()) {
            boolean schemasAdded = this.addSchemas(source, dialect, convention, caseSensitive);
            if (!schemasAdded) {
                this.schemaMap.put("default", new CapitalizingJdbcSchema(Collections.emptyList(), name, source, dialect, convention, null, null, caseSensitive));
            }
        } else {
            this.addSchemas(source, dialect, convention, caseSensitive);
        }
        this.defaultSchema = this.determineDefaultSchema(connectionSchemaName);
    }

    private CapitalizingJdbcSchema determineDefaultSchema(String connectionSchemaName) {
        CapitalizingJdbcSchema connSchema;
        if (connectionSchemaName == null || (connSchema = this.schemaMap.get(connectionSchemaName.toLowerCase())) == null) {
            connSchema = this.schemaMap.values().iterator().next();
        }
        return connSchema.getDefaultSchema();
    }

    void setHolder(SchemaPlus plusOfThis) {
        for (String s : this.getSubSchemaNames()) {
            CapitalizingJdbcSchema inner = this.getSubSchema(s);
            SchemaPlus holder = plusOfThis.add(s, (Schema)inner);
            inner.setHolder(holder);
        }
    }

    private boolean addSchemas(DataSource source, SqlDialect dialect, DrillJdbcConvention convention, boolean caseSensitive) {
        boolean added = false;
        try (Connection con = source.getConnection();
             ResultSet set = con.getMetaData().getSchemas();){
            while (set.next()) {
                CapitalizingJdbcSchema schema;
                String schemaName = set.getString(1);
                String catalogName = set.getString(2);
                String parentKey = StringUtils.lowerCase((String)catalogName);
                CapitalizingJdbcSchema parentSchema = this.schemaMap.get(parentKey);
                if (parentSchema == null) {
                    schema = new CapitalizingJdbcSchema(this.getSchemaPath(), schemaName, source, dialect, convention, catalogName, schemaName, caseSensitive);
                    this.schemaMap.put(schema.getName(), schema);
                } else {
                    schema = new CapitalizingJdbcSchema(parentSchema.getSchemaPath(), schemaName, source, dialect, convention, catalogName, schemaName, caseSensitive);
                    parentSchema.addSubSchema(schema);
                }
                added = true;
            }
        }
        catch (SQLException e) {
            logger.warn("Failure while attempting to load JDBC schema.", (Throwable)e);
        }
        return added;
    }

    public String getTypeName() {
        return "jdbc";
    }

    public Schema getDefaultSchema() {
        return this.defaultSchema;
    }

    public CapitalizingJdbcSchema getSubSchema(String name) {
        return this.schemaMap.get(name);
    }

    public Set<String> getSubSchemaNames() {
        return this.schemaMap.keySet();
    }

    public Table getTable(String name) {
        if (this.defaultSchema != null) {
            try {
                return this.defaultSchema.getTable(name);
            }
            catch (RuntimeException e) {
                logger.warn("Failure while attempting to read table '{}' from JDBC source.", (Object)name, (Object)e);
            }
        }
        return null;
    }

    public Set<String> getTableNames() {
        return this.defaultSchema.getTableNames();
    }

    public boolean areTableNamesCaseSensitive() {
        return this.defaultSchema.areTableNamesCaseSensitive();
    }
}

