/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiator;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.planner.types.DrillRelDataTypeSystem;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.jdbc.writers.JdbcBigintWriter;
import org.apache.drill.exec.store.jdbc.writers.JdbcBitWriter;
import org.apache.drill.exec.store.jdbc.writers.JdbcColumnWriter;
import org.apache.drill.exec.store.jdbc.writers.JdbcDateWriter;
import org.apache.drill.exec.store.jdbc.writers.JdbcDoubleWriter;
import org.apache.drill.exec.store.jdbc.writers.JdbcFloatWriter;
import org.apache.drill.exec.store.jdbc.writers.JdbcIntWriter;
import org.apache.drill.exec.store.jdbc.writers.JdbcTimeWriter;
import org.apache.drill.exec.store.jdbc.writers.JdbcTimestampWriter;
import org.apache.drill.exec.store.jdbc.writers.JdbcVarbinaryWriter;
import org.apache.drill.exec.store.jdbc.writers.JdbcVarcharWriter;
import org.apache.drill.exec.store.jdbc.writers.JdbcVardecimalWriter;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcBatchReader
implements ManagedReader<SchemaNegotiator> {
    private static final Logger logger = LoggerFactory.getLogger(JdbcBatchReader.class);
    private static final ImmutableMap<Integer, TypeProtos.MinorType> JDBC_TYPE_MAPPINGS = ImmutableMap.builder().put((Object)8, (Object)TypeProtos.MinorType.FLOAT8).put((Object)6, (Object)TypeProtos.MinorType.FLOAT4).put((Object)-6, (Object)TypeProtos.MinorType.INT).put((Object)5, (Object)TypeProtos.MinorType.INT).put((Object)4, (Object)TypeProtos.MinorType.INT).put((Object)-5, (Object)TypeProtos.MinorType.BIGINT).put((Object)1, (Object)TypeProtos.MinorType.VARCHAR).put((Object)12, (Object)TypeProtos.MinorType.VARCHAR).put((Object)-1, (Object)TypeProtos.MinorType.VARCHAR).put((Object)2005, (Object)TypeProtos.MinorType.VARCHAR).put((Object)-15, (Object)TypeProtos.MinorType.VARCHAR).put((Object)-9, (Object)TypeProtos.MinorType.VARCHAR).put((Object)-16, (Object)TypeProtos.MinorType.VARCHAR).put((Object)-3, (Object)TypeProtos.MinorType.VARBINARY).put((Object)-4, (Object)TypeProtos.MinorType.VARBINARY).put((Object)2004, (Object)TypeProtos.MinorType.VARBINARY).put((Object)2, (Object)TypeProtos.MinorType.FLOAT8).put((Object)3, (Object)TypeProtos.MinorType.VARDECIMAL).put((Object)7, (Object)TypeProtos.MinorType.FLOAT8).put((Object)91, (Object)TypeProtos.MinorType.DATE).put((Object)92, (Object)TypeProtos.MinorType.TIME).put((Object)93, (Object)TypeProtos.MinorType.TIMESTAMP).put((Object)16, (Object)TypeProtos.MinorType.BIT).put((Object)-7, (Object)TypeProtos.MinorType.BIT).build();
    private final DataSource source;
    private final String sql;
    private final List<SchemaPath> columns;
    private Connection connection;
    private PreparedStatement statement;
    private ResultSet resultSet;
    private Integer updateCount;
    private RowSetLoader rowWriter;
    private CustomErrorContext errorContext;
    private List<JdbcColumnWriter> columnWriters;
    private List<JdbcColumn> jdbcColumns;

    public JdbcBatchReader(DataSource source, String sql, List<SchemaPath> columns) {
        this.source = source;
        this.sql = sql;
        this.columns = columns;
    }

    public boolean open(SchemaNegotiator negotiator) {
        this.errorContext = negotiator.parentErrorContext();
        try {
            TupleMetadata drillSchema;
            this.connection = this.source.getConnection();
            this.statement = this.connection.prepareStatement(this.sql);
            if (this.statement.execute()) {
                this.resultSet = this.statement.getResultSet();
                drillSchema = this.buildSchema();
            } else {
                this.updateCount = this.statement.getUpdateCount();
                drillSchema = this.buildUpdateQuerySchema();
            }
            negotiator.tableSchema(drillSchema, true);
            ResultSetLoader resultSetLoader = negotiator.build();
            this.rowWriter = resultSetLoader.writer();
            this.populateWriterArray();
        }
        catch (SQLException e) {
            throw UserException.dataReadError((Throwable)e).message("The JDBC storage plugin failed while trying setup the SQL query. ", new Object[0]).addContext("Sql", this.sql).addContext(this.errorContext).build(logger);
        }
        return true;
    }

    public boolean next() {
        while (!this.rowWriter.isFull()) {
            if (this.processRow()) continue;
            return false;
        }
        return true;
    }

    private boolean processRow() {
        try {
            if (this.resultSet != null) {
                return this.processResultSetRow();
            }
            return this.processUpdateRow();
        }
        catch (SQLException e) {
            throw UserException.dataReadError((Throwable)e).message("Failure while attempting to read from database.", new Object[0]).addContext("Sql", this.sql).addContext(this.errorContext).build(logger);
        }
    }

    private boolean processResultSetRow() throws SQLException {
        if (!this.resultSet.next()) {
            return false;
        }
        this.rowWriter.start();
        for (JdbcColumnWriter writer : this.columnWriters) {
            writer.load(this.resultSet);
        }
        this.rowWriter.save();
        return true;
    }

    private boolean processUpdateRow() {
        if (this.updateCount == null) {
            return false;
        }
        this.rowWriter.start();
        this.rowWriter.scalar(this.columns.get(0).getRootSegmentPath()).setLong((long)this.updateCount.intValue());
        this.rowWriter.save();
        this.updateCount = null;
        return true;
    }

    public void close() {
        AutoCloseables.closeSilently((AutoCloseable[])new AutoCloseable[]{this.resultSet, this.statement, this.connection});
    }

    private TupleMetadata buildSchema() throws SQLException {
        SchemaBuilder builder = new SchemaBuilder();
        ResultSetMetaData meta = this.resultSet.getMetaData();
        this.jdbcColumns = new ArrayList<JdbcColumn>();
        int columnsCount = meta.getColumnCount();
        if (this.columns.size() != columnsCount) {
            throw UserException.validationError().message("Expected columns count differs from the returned one.\nExpected columns: %s\nReturned columns count: %s", new Object[]{this.columns, columnsCount}).addContext("Sql", this.sql).addContext(this.errorContext).build(logger);
        }
        for (int i = 1; i <= columnsCount; ++i) {
            String name = this.columns.get(i - 1).getRootSegmentPath();
            int jdbcType = meta.getColumnType(i);
            int width = Math.min(meta.getPrecision(i), DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision());
            int scale = Math.min(meta.getScale(i), DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericScale() - 1);
            TypeProtos.MinorType minorType = (TypeProtos.MinorType)JDBC_TYPE_MAPPINGS.get((Object)jdbcType);
            if (minorType == null) {
                logger.warn("Ignoring column that is unsupported.", (Throwable)UserException.unsupportedError().message("A column you queried has a data type that is not currently supported by the JDBC storage plugin. The column's name was %s and its JDBC data type was %s. ", new Object[]{name, JdbcBatchReader.nameFromType(jdbcType)}).addContext("Sql", this.sql).addContext("Column Name", name).addContext(this.errorContext).build(logger));
                continue;
            }
            this.jdbcColumns.add(new JdbcColumn(name, minorType, i, scale, width));
            builder.addNullable(name, minorType, width, scale);
        }
        return builder.buildSchema();
    }

    private TupleMetadata buildUpdateQuerySchema() throws SQLException {
        if (this.columns.size() != 1) {
            throw UserException.validationError().message("Expected columns count differs from the returned one.\nExpected columns: %s\nReturned columns count: %s", new Object[]{this.columns, 1}).addContext("Sql", this.sql).addContext(this.errorContext).build(logger);
        }
        String name = this.columns.get(0).getRootSegmentPath();
        int width = DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision();
        int scale = 0;
        TypeProtos.MinorType minorType = TypeProtos.MinorType.BIGINT;
        this.jdbcColumns = new ArrayList<JdbcColumn>();
        this.jdbcColumns.add(new JdbcColumn(name, minorType, 0, scale, width));
        return new SchemaBuilder().addNullable(name, minorType, width, scale).buildSchema();
    }

    private void populateWriterArray() {
        this.columnWriters = new ArrayList<JdbcColumnWriter>();
        block13: for (JdbcColumn col : this.jdbcColumns) {
            switch (col.type) {
                case VARCHAR: {
                    this.columnWriters.add(new JdbcVarcharWriter(col.colName, this.rowWriter, col.colPosition));
                    continue block13;
                }
                case FLOAT4: {
                    this.columnWriters.add(new JdbcFloatWriter(col.colName, this.rowWriter, col.colPosition));
                    continue block13;
                }
                case FLOAT8: {
                    this.columnWriters.add(new JdbcDoubleWriter(col.colName, this.rowWriter, col.colPosition));
                    continue block13;
                }
                case INT: {
                    this.columnWriters.add(new JdbcIntWriter(col.colName, this.rowWriter, col.colPosition));
                    continue block13;
                }
                case BIGINT: {
                    this.columnWriters.add(new JdbcBigintWriter(col.colName, this.rowWriter, col.colPosition));
                    continue block13;
                }
                case DATE: {
                    this.columnWriters.add(new JdbcDateWriter(col.colName, this.rowWriter, col.colPosition));
                    continue block13;
                }
                case TIME: {
                    this.columnWriters.add(new JdbcTimeWriter(col.colName, this.rowWriter, col.colPosition));
                    continue block13;
                }
                case TIMESTAMP: {
                    this.columnWriters.add(new JdbcTimestampWriter(col.colName, this.rowWriter, col.colPosition));
                    continue block13;
                }
                case VARBINARY: {
                    this.columnWriters.add(new JdbcVarbinaryWriter(col.colName, this.rowWriter, col.colPosition));
                    continue block13;
                }
                case BIT: {
                    this.columnWriters.add(new JdbcBitWriter(col.colName, this.rowWriter, col.colPosition));
                    continue block13;
                }
                case VARDECIMAL: {
                    this.columnWriters.add(new JdbcVardecimalWriter(col.colName, this.rowWriter, col.colPosition, col.scale, col.precision));
                    continue block13;
                }
            }
            logger.warn("Unsupported data type {} found at column {}", (Object)col.type.getDescriptorForType(), (Object)col.colName);
        }
    }

    private static String nameFromType(int javaSqlType) {
        try {
            for (Field f : Types.class.getFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || f.getType() != Integer.TYPE || f.getInt(null) != javaSqlType) continue;
                return f.getName();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.debug("Unable to SQL type {} into String: {}", (Object)javaSqlType, (Object)e.getMessage());
        }
        return Integer.toString(javaSqlType);
    }

    public static class JdbcColumn {
        final String colName;
        final TypeProtos.MinorType type;
        final int colPosition;
        final int scale;
        final int precision;

        public JdbcColumn(String colName, TypeProtos.MinorType type, int colPosition, int scale, int precision) {
            this.colName = colName;
            this.type = type;
            this.colPosition = colPosition;
            this.scale = scale;
            this.precision = precision;
        }
    }
}

