/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.blockmanagement.BlocksMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.ReplicaUnderConstruction;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.util.LightWeightGSet;

@InterfaceAudience.Private
public abstract class BlockInfo
extends Block
implements LightWeightGSet.LinkedElement {
    public static final BlockInfo[] EMPTY_ARRAY = new BlockInfo[0];
    private short replication;
    private volatile long bcId;
    private LightWeightGSet.LinkedElement nextLinkedElement;
    protected Object[] triplets;
    private BlockUnderConstructionFeature uc;

    public BlockInfo(short size) {
        this.triplets = new Object[3 * size];
        this.bcId = -1L;
        this.replication = this.isStriped() ? (short)0 : size;
    }

    public BlockInfo(Block blk, short size) {
        super(blk);
        this.triplets = new Object[3 * size];
        this.bcId = -1L;
        this.replication = this.isStriped() ? (short)0 : size;
    }

    public short getReplication() {
        return this.replication;
    }

    public void setReplication(short repl) {
        this.replication = repl;
    }

    public long getBlockCollectionId() {
        return this.bcId;
    }

    public void setBlockCollectionId(long id) {
        this.bcId = id;
    }

    public void delete() {
        this.setBlockCollectionId(-1L);
    }

    public boolean isDeleted() {
        return this.bcId == -1L;
    }

    public Iterator<DatanodeStorageInfo> getStorageInfos() {
        return new BlocksMap.StorageIterator(this);
    }

    public DatanodeDescriptor getDatanode(int index) {
        DatanodeStorageInfo storage = this.getStorageInfo(index);
        return storage == null ? null : storage.getDatanodeDescriptor();
    }

    DatanodeStorageInfo getStorageInfo(int index) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 < this.triplets.length) : "Index is out of bound";
        return (DatanodeStorageInfo)this.triplets[index * 3];
    }

    BlockInfo getPrevious(int index) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 + 1 < this.triplets.length) : "Index is out of bound";
        BlockInfo info = (BlockInfo)((Object)this.triplets[index * 3 + 1]);
        assert (info == null || ((Object)((Object)info)).getClass().getName().startsWith(BlockInfo.class.getName())) : "BlockInfo is expected at " + index * 3;
        return info;
    }

    BlockInfo getNext(int index) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 + 2 < this.triplets.length) : "Index is out of bound";
        BlockInfo info = (BlockInfo)((Object)this.triplets[index * 3 + 2]);
        assert (info == null || ((Object)((Object)info)).getClass().getName().startsWith(BlockInfo.class.getName())) : "BlockInfo is expected at " + index * 3;
        return info;
    }

    void setStorageInfo(int index, DatanodeStorageInfo storage) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 < this.triplets.length) : "Index is out of bound";
        this.triplets[index * 3] = storage;
    }

    BlockInfo setPrevious(int index, BlockInfo to) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 + 1 < this.triplets.length) : "Index is out of bound";
        BlockInfo info = (BlockInfo)((Object)this.triplets[index * 3 + 1]);
        this.triplets[index * 3 + 1] = to;
        return info;
    }

    BlockInfo setNext(int index, BlockInfo to) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 + 2 < this.triplets.length) : "Index is out of bound";
        BlockInfo info = (BlockInfo)((Object)this.triplets[index * 3 + 2]);
        this.triplets[index * 3 + 2] = to;
        return info;
    }

    public int getCapacity() {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (this.triplets.length % 3 == 0) : "Malformed BlockInfo";
        return this.triplets.length / 3;
    }

    public abstract int numNodes();

    abstract boolean addStorage(DatanodeStorageInfo var1, Block var2);

    abstract boolean removeStorage(DatanodeStorageInfo var1);

    public abstract boolean isStriped();

    public abstract BlockType getBlockType();

    abstract boolean hasNoStorage();

    DatanodeStorageInfo findStorageInfo(DatanodeDescriptor dn) {
        int len = this.getCapacity();
        DatanodeStorageInfo providedStorageInfo = null;
        for (int idx = 0; idx < len; ++idx) {
            DatanodeStorageInfo cur = this.getStorageInfo(idx);
            if (cur == null) continue;
            if (cur.getStorageType() == StorageType.PROVIDED) {
                if (dn.getStorageInfo(cur.getStorageID()) == null) continue;
                providedStorageInfo = cur;
                continue;
            }
            if (cur.getDatanodeDescriptor() != dn) continue;
            return cur;
        }
        return providedStorageInfo;
    }

    int findStorageInfo(DatanodeStorageInfo storageInfo) {
        int len = this.getCapacity();
        for (int idx = 0; idx < len; ++idx) {
            DatanodeStorageInfo cur = this.getStorageInfo(idx);
            if (cur != storageInfo) continue;
            return idx;
        }
        return -1;
    }

    BlockInfo listInsert(BlockInfo head, DatanodeStorageInfo storage) {
        int dnIndex = this.findStorageInfo(storage);
        assert (dnIndex >= 0) : "Data node is not found: current";
        assert (this.getPrevious(dnIndex) == null && this.getNext(dnIndex) == null) : "Block is already in the list and cannot be inserted.";
        this.setPrevious(dnIndex, null);
        this.setNext(dnIndex, head);
        if (head != null) {
            head.setPrevious(head.findStorageInfo(storage), this);
        }
        return this;
    }

    BlockInfo listRemove(BlockInfo head, DatanodeStorageInfo storage) {
        if (head == null) {
            return null;
        }
        int dnIndex = this.findStorageInfo(storage);
        if (dnIndex < 0) {
            return head;
        }
        BlockInfo next = this.getNext(dnIndex);
        BlockInfo prev = this.getPrevious(dnIndex);
        this.setNext(dnIndex, null);
        this.setPrevious(dnIndex, null);
        if (prev != null) {
            prev.setNext(prev.findStorageInfo(storage), next);
        }
        if (next != null) {
            next.setPrevious(next.findStorageInfo(storage), prev);
        }
        if (this == head) {
            head = next;
        }
        return head;
    }

    public BlockInfo moveBlockToHead(BlockInfo head, DatanodeStorageInfo storage, int curIndex, int headIndex) {
        if (head == this) {
            return this;
        }
        BlockInfo next = this.setNext(curIndex, head);
        BlockInfo prev = this.setPrevious(curIndex, null);
        head.setPrevious(headIndex, this);
        prev.setNext(prev.findStorageInfo(storage), next);
        if (next != null) {
            next.setPrevious(next.findStorageInfo(storage), prev);
        }
        return this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    public LightWeightGSet.LinkedElement getNext() {
        return this.nextLinkedElement;
    }

    public void setNext(LightWeightGSet.LinkedElement next) {
        this.nextLinkedElement = next;
    }

    public BlockUnderConstructionFeature getUnderConstructionFeature() {
        return this.uc;
    }

    public HdfsServerConstants.BlockUCState getBlockUCState() {
        return this.uc == null ? HdfsServerConstants.BlockUCState.COMPLETE : this.uc.getBlockUCState();
    }

    public boolean isComplete() {
        return this.getBlockUCState().equals((Object)HdfsServerConstants.BlockUCState.COMPLETE);
    }

    public boolean isUnderRecovery() {
        return this.getBlockUCState().equals((Object)HdfsServerConstants.BlockUCState.UNDER_RECOVERY);
    }

    public final boolean isCompleteOrCommitted() {
        HdfsServerConstants.BlockUCState state = this.getBlockUCState();
        return state.equals((Object)HdfsServerConstants.BlockUCState.COMPLETE) || state.equals((Object)HdfsServerConstants.BlockUCState.COMMITTED);
    }

    public void convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState s, DatanodeStorageInfo[] targets) {
        if (this.isComplete()) {
            this.uc = new BlockUnderConstructionFeature(this, s, targets, this.getBlockType());
        } else {
            this.uc.setBlockUCState(s);
            this.uc.setExpectedLocations(this, targets, this.getBlockType());
        }
    }

    void convertToCompleteBlock() {
        assert (this.getBlockUCState() != HdfsServerConstants.BlockUCState.COMPLETE) : "Trying to convert a COMPLETE block";
        this.uc = null;
    }

    public List<ReplicaUnderConstruction> setGenerationStampAndVerifyReplicas(long genStamp) {
        Preconditions.checkState((this.uc != null && !this.isComplete() ? 1 : 0) != 0);
        this.setGenerationStamp(genStamp);
        return this.uc.getStaleReplicas(genStamp);
    }

    List<ReplicaUnderConstruction> commitBlock(Block block) throws IOException {
        if (this.getBlockId() != block.getBlockId()) {
            throw new IOException("Trying to commit inconsistent block: id = " + block.getBlockId() + ", expected id = " + this.getBlockId());
        }
        Preconditions.checkState((!this.isComplete() ? 1 : 0) != 0);
        this.uc.commit();
        this.setNumBytes(block.getNumBytes());
        return this.setGenerationStampAndVerifyReplicas(block.getGenerationStamp());
    }
}

