/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.net;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.net.DFSTopologyNodeImpl;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.net.InnerNode;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.util.ReflectionUtils;

public class DFSNetworkTopology
extends NetworkTopology {
    private static final Random RANDOM = new Random();

    public static DFSNetworkTopology getInstance(Configuration conf) {
        DFSNetworkTopology nt = (DFSNetworkTopology)((Object)ReflectionUtils.newInstance((Class)conf.getClass("dfs.net.topology.impl", DFSConfigKeys.DFS_NET_TOPOLOGY_IMPL_DEFAULT, DFSNetworkTopology.class), (Configuration)conf));
        return (DFSNetworkTopology)nt.init((InnerNode.Factory)DFSTopologyNodeImpl.FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node chooseRandomWithStorageType(String scope, Collection<Node> excludedNodes, StorageType type) {
        this.netlock.readLock().lock();
        try {
            if (scope.startsWith("~")) {
                Node node = this.chooseRandomWithStorageType("", scope.substring(1), excludedNodes, type);
                return node;
            }
            Node node = this.chooseRandomWithStorageType(scope, null, excludedNodes, type);
            return node;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node chooseRandomWithStorageTypeTwoTrial(String scope, Collection<Node> excludedNodes, StorageType type) {
        this.netlock.readLock().lock();
        try {
            String excludedScope;
            String searchScope;
            if (scope.startsWith("~")) {
                searchScope = "";
                excludedScope = scope.substring(1);
            } else {
                searchScope = scope;
                excludedScope = null;
            }
            Node n = this.chooseRandom(searchScope, excludedScope, excludedNodes);
            if (n == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No node to choose.");
                }
                Node node = null;
                return node;
            }
            Preconditions.checkArgument((boolean)(n instanceof DatanodeDescriptor));
            DatanodeDescriptor dnDescriptor = (DatanodeDescriptor)n;
            if (dnDescriptor.hasStorageType(type)) {
                DatanodeDescriptor datanodeDescriptor = dnDescriptor;
                return datanodeDescriptor;
            }
            LOG.debug("First trial failed, node has no type {}, making second trial carrying this type", (Object)type);
            Node node = this.chooseRandomWithStorageType(searchScope, excludedScope, excludedNodes, type);
            return node;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    @VisibleForTesting
    Node chooseRandomWithStorageType(String scope, String excludedScope, Collection<Node> excludedNodes, StorageType type) {
        Node chosen;
        Node node;
        if (excludedScope != null) {
            if (scope.startsWith(excludedScope)) {
                return null;
            }
            if (!excludedScope.startsWith(scope)) {
                excludedScope = null;
            }
        }
        if ((node = this.getNode(scope)) == null) {
            LOG.debug("Invalid scope {}, non-existing node", (Object)scope);
            return null;
        }
        if (!(node instanceof DFSTopologyNodeImpl)) {
            return ((DatanodeDescriptor)node).hasStorageType(type) ? node : null;
        }
        DFSTopologyNodeImpl root = (DFSTopologyNodeImpl)node;
        Node excludeRoot = excludedScope == null ? null : this.getNode(excludedScope);
        int availableCount = root.getSubtreeStorageCount(type);
        if (excludeRoot != null && root.isAncestor(excludeRoot)) {
            availableCount = excludeRoot instanceof DFSTopologyNodeImpl ? (availableCount -= ((DFSTopologyNodeImpl)excludeRoot).getSubtreeStorageCount(type)) : (availableCount -= ((DatanodeDescriptor)excludeRoot).hasStorageType(type) ? 1 : 0);
        }
        if (excludedNodes != null) {
            for (Node excludedNode : excludedNodes) {
                if (excludeRoot != null && this.isNodeInScope(excludedNode, excludedScope)) continue;
                if (excludedNode instanceof DatanodeDescriptor) {
                    availableCount -= ((DatanodeDescriptor)excludedNode).hasStorageType(type) ? 1 : 0;
                    continue;
                }
                if (excludedNode instanceof DFSTopologyNodeImpl) {
                    availableCount -= ((DFSTopologyNodeImpl)excludedNode).getSubtreeStorageCount(type);
                    continue;
                }
                if (excludedNode instanceof DatanodeInfo) {
                    String nodeLocation = excludedNode.getNetworkLocation() + "/" + excludedNode.getName();
                    DatanodeDescriptor dn = (DatanodeDescriptor)this.getNode(nodeLocation);
                    if (dn == null) continue;
                    availableCount -= dn.hasStorageType(type) ? 1 : 0;
                    continue;
                }
                LOG.error("Unexpected node type: {}.", excludedNode.getClass());
            }
        }
        if (availableCount <= 0) {
            return null;
        }
        while (true) {
            chosen = this.chooseRandomWithStorageTypeAndExcludeRoot(root, excludeRoot, type);
            if (excludedNodes == null || !excludedNodes.contains(chosen)) break;
            LOG.debug("Node {} is excluded, continuing.", (Object)chosen);
        }
        LOG.debug("chooseRandom returning {}", (Object)chosen);
        return chosen;
    }

    private boolean isNodeInScope(Node node, String scope) {
        if (!scope.endsWith("/")) {
            scope = scope + "/";
        }
        String nodeLocation = node.getNetworkLocation() + "/";
        return nodeLocation.startsWith(scope);
    }

    private Node chooseRandomWithStorageTypeAndExcludeRoot(DFSTopologyNodeImpl root, Node excludeRoot, StorageType type) {
        Node chosenNode;
        if (root.isRack()) {
            ArrayList<Node> candidates = new ArrayList<Node>();
            for (Node node : root.getChildren()) {
                DatanodeDescriptor dnDescriptor;
                if (node.equals(excludeRoot) || !(dnDescriptor = (DatanodeDescriptor)node).hasStorageType(type)) continue;
                candidates.add(node);
            }
            if (candidates.size() == 0) {
                return null;
            }
            chosenNode = (Node)candidates.get(RANDOM.nextInt(candidates.size()));
        } else {
            ArrayList<DFSTopologyNodeImpl> candidates = this.getEligibleChildren(root, excludeRoot, type);
            if (candidates.size() == 0) {
                return null;
            }
            int totalCounts = 0;
            int[] countArray = new int[candidates.size()];
            for (int i = 0; i < candidates.size(); ++i) {
                DFSTopologyNodeImpl innerNode = candidates.get(i);
                int subTreeCount = innerNode.getSubtreeStorageCount(type);
                totalCounts += subTreeCount;
                countArray[i] = subTreeCount;
            }
            int randomCounts = RANDOM.nextInt(totalCounts) + 1;
            int idxChosen = 0;
            for (int i = 0; i < countArray.length; ++i) {
                if (randomCounts <= countArray[i]) {
                    idxChosen = i;
                    break;
                }
                randomCounts -= countArray[i];
            }
            DFSTopologyNodeImpl nextRoot = candidates.get(idxChosen);
            chosenNode = this.chooseRandomWithStorageTypeAndExcludeRoot(nextRoot, excludeRoot, type);
        }
        return chosenNode;
    }

    private ArrayList<DFSTopologyNodeImpl> getEligibleChildren(DFSTopologyNodeImpl root, Node excludeRoot, StorageType type) {
        ArrayList<DFSTopologyNodeImpl> candidates = new ArrayList<DFSTopologyNodeImpl>();
        int excludeCount = 0;
        if (excludeRoot != null && root.isAncestor(excludeRoot)) {
            if (excludeRoot instanceof DFSTopologyNodeImpl) {
                excludeCount = ((DFSTopologyNodeImpl)excludeRoot).getSubtreeStorageCount(type);
            } else if (((DatanodeDescriptor)excludeRoot).hasStorageType(type)) {
                excludeCount = 1;
            }
        }
        for (Node node : root.getChildren()) {
            DFSTopologyNodeImpl dfsNode = (DFSTopologyNodeImpl)node;
            int storageCount = dfsNode.getSubtreeStorageCount(type);
            if (excludeRoot != null && excludeCount != 0 && (dfsNode.isAncestor(excludeRoot) || dfsNode.equals(excludeRoot))) {
                storageCount -= excludeCount;
            }
            if (storageCount <= 0) continue;
            candidates.add(dfsNode);
        }
        return candidates;
    }
}

