/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.scan.framework.BasicScanFactory;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedScanFramework;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.kafka.KafkaPartitionScanSpec;
import org.apache.drill.exec.store.kafka.KafkaRecordReader;
import org.apache.drill.exec.store.kafka.KafkaSubScan;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class KafkaScanBatchCreator
implements BatchCreator<KafkaSubScan> {
    public CloseableRecordBatch getBatch(ExecutorFragmentContext context, KafkaSubScan subScan, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        try {
            ManagedScanFramework.ScanFrameworkBuilder builder = this.createBuilder(context.getOptions(), subScan);
            return builder.buildScanOperator((FragmentContext)context, (PhysicalOperator)subScan);
        }
        catch (UserException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ExecutionSetupException(e);
        }
    }

    private ManagedScanFramework.ScanFrameworkBuilder createBuilder(OptionManager options, KafkaSubScan subScan) {
        ManagedScanFramework.ScanFrameworkBuilder builder = new ManagedScanFramework.ScanFrameworkBuilder();
        builder.projection(subScan.getColumns());
        builder.setUserName(subScan.getUserName());
        List readers = subScan.getPartitionSubScanSpecList().stream().map(scanSpec -> new KafkaRecordReader((KafkaPartitionScanSpec)scanSpec, options, subScan.getKafkaStoragePlugin(), subScan.getRecords())).collect(Collectors.toList());
        BasicScanFactory readerFactory = new BasicScanFactory(readers.iterator());
        builder.setReaderFactory((ManagedScanFramework.ReaderFactory)readerFactory);
        builder.nullType(Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
        return builder;
    }
}

