/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import java.util.List;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.FilterPrel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.kafka.KafkaGroupScan;
import org.apache.drill.exec.store.kafka.KafkaPartitionScanSpec;
import org.apache.drill.exec.store.kafka.KafkaPartitionScanSpecBuilder;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPushDownFilterIntoScan
extends StoragePluginOptimizerRule {
    private static final Logger logger = LoggerFactory.getLogger(KafkaPushDownFilterIntoScan.class);
    public static final StoragePluginOptimizerRule INSTANCE = new KafkaPushDownFilterIntoScan(RelOptHelper.some(FilterPrel.class, (RelOptRuleOperand)RelOptHelper.any(ScanPrel.class), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "KafkaPushFilterIntoScan:Filter_On_Scan");

    private KafkaPushDownFilterIntoScan(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    public void onMatch(RelOptRuleCall call) {
        List<KafkaPartitionScanSpec> newScanSpec;
        ScanPrel scan = (ScanPrel)call.rel(1);
        FilterPrel filter = (FilterPrel)call.rel(0);
        RexNode condition = filter.getCondition();
        LogicalExpression conditionExp = DrillOptiq.toDrill((DrillParseContext)new DrillParseContext(PrelUtil.getPlannerSettings((RelOptPlanner)call.getPlanner())), (RelNode)scan, (RexNode)condition);
        KafkaGroupScan groupScan = (KafkaGroupScan)scan.getGroupScan();
        if (logger.isDebugEnabled()) {
            logger.debug("Partitions ScanSpec before push down: {}", groupScan.getPartitionScanSpecList());
        }
        try (KafkaPartitionScanSpecBuilder builder = new KafkaPartitionScanSpecBuilder(groupScan, conditionExp);){
            newScanSpec = builder.parseTree();
        }
        if (newScanSpec == null) {
            return;
        }
        logger.debug("Partitions ScanSpec after pushdown: {}", newScanSpec);
        GroupScan newGroupScan = groupScan.cloneWithNewSpec(newScanSpec);
        ScanPrel newScanPrel = new ScanPrel(scan.getCluster(), filter.getTraitSet(), newGroupScan, scan.getRowType(), scan.getTable());
        call.transformTo(filter.copy(filter.getTraitSet(), (List)ImmutableList.of((Object)newScanPrel)));
    }

    public boolean matches(RelOptRuleCall call) {
        ScanPrel scan = (ScanPrel)call.rel(1);
        if (scan.getGroupScan() instanceof KafkaGroupScan) {
            return super.matches(call);
        }
        return false;
    }
}

